/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.configuration.storage.tee;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.yaml.IYamlStorable;
import com.nxp.swtools.common.utils.yaml.YamlStorableList;
import com.nxp.swtools.common.utils.yaml.YamlStorableValue;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeBaseMemoryRegionConfig;
import com.nxp.swtools.provider.configuration.storage.tee.StorageTeeUserDomainAccessConfig;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Root(strict=false)
public class StorageTeeUserMemoryRegionConfig
extends StorageTeeBaseMemoryRegionConfig {
    public static final String DEFAULT_ID_PREFIX = "Region";
    protected static final String NAME_ID = "name";
    protected static final String DESCRIPTION_ID = "description";
    protected static final String SECURITY_LEVEL_ID = "security";
    @Attribute(name="id", required=true)
    private String id;
    @Attribute(name="description", required=false)
    @Nullable
    private @Attribute(name="description", required=false) @Nullable String description;
    @Attribute(name="name", required=false)
    @Nullable
    protected @Attribute(name="name", required=false) @Nullable String name;
    @Attribute(name="security", required=false)
    @Nullable
    protected @Attribute(name="security", required=false) @Nullable String securityLevel;
    @ElementList(entry="accesses", type=StorageTeeUserDomainAccessConfig.class, required=false, inline=true)
    @Nullable
    private @ElementList(entry="accesses", type=StorageTeeUserDomainAccessConfig.class, required=false, inline=true) @Nullable List<StorageTeeUserDomainAccessConfig> accessConfigs;

    public StorageTeeUserMemoryRegionConfig() {
        this.id = DEFAULT_ID_PREFIX;
    }

    public StorageTeeUserMemoryRegionConfig(String id, BigInteger start, BigInteger size, @Nullable String name, @Nullable String description, @Nullable String securityLevel, @Nullable List<StorageTeeUserDomainAccessConfig> accessConfigs) {
        this.id = id;
        this.setStart(start);
        this.setSize(size);
        this.setName(name);
        this.setDescription(description);
        this.setSecurityLevel(securityLevel);
        this.setAccessConfigs(accessConfigs);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String value) {
        this.description = value;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public @Nullable String getSecurityLevel() {
        return this.securityLevel;
    }

    public void setSecurityLevel(@Nullable String secLevel) {
        this.securityLevel = secLevel;
    }

    public List<StorageTeeUserDomainAccessConfig> getAccessConfigs() {
        List<StorageTeeUserDomainAccessConfig> accessConfigsLoc = this.accessConfigs;
        return accessConfigsLoc == null ? Collections.emptyList() : accessConfigsLoc;
    }

    public void setAccessConfigs(@Nullable List<StorageTeeUserDomainAccessConfig> accessConfigs) {
        this.accessConfigs = accessConfigs == null || accessConfigs.isEmpty() ? null : accessConfigs;
    }

    @Override
    protected String getYamlId() {
        return "user_memory_region";
    }

    @Override
    protected List<IYamlStorable> createYamlStorable() {
        List<StorageTeeUserDomainAccessConfig> accessConfigsLoc;
        ArrayList<IYamlStorable> storable = new ArrayList<IYamlStorable>();
        storable.add((IYamlStorable)new YamlStorableValue("id", this.id));
        if (this.securityLevel != null) {
            storable.add((IYamlStorable)new YamlStorableValue(SECURITY_LEVEL_ID, this.securityLevel));
        }
        if (this.name != null) {
            storable.add((IYamlStorable)new YamlStorableValue(NAME_ID, this.name));
        }
        if (this.description != null) {
            storable.add((IYamlStorable)new YamlStorableValue(DESCRIPTION_ID, this.description));
        }
        if (!(accessConfigsLoc = this.getAccessConfigs()).isEmpty()) {
            YamlStorableList accessConfigsYaml = new YamlStorableList("accesses", Boolean.TRUE, true, true);
            accessConfigsLoc.forEach(each -> each.fillYamlStorable((IYamlStorable)accessConfigsYaml));
            storable.add((IYamlStorable)accessConfigsYaml);
        }
        storable.addAll(super.createYamlStorable());
        return storable;
    }

    @Override
    protected boolean loadYamlConvertible(Collection<IYamlStorable> children) {
        if (!super.loadYamlConvertible(children)) {
            return false;
        }
        String idLoc = "";
        String descriptionLoc = null;
        String nameLoc = null;
        String securityLevelLoc = "";
        ArrayList<StorageTeeUserDomainAccessConfig> accessConfigsLoc = new ArrayList<StorageTeeUserDomainAccessConfig>();
        for (IYamlStorable childYaml : children) {
            Collection accessYamls;
            if (childYaml instanceof YamlStorableValue) {
                if (childYaml.getYamlId().equals(SECURITY_LEVEL_ID)) {
                    securityLevelLoc = childYaml.getYamlValue();
                } else if (childYaml.getYamlId().equals("id")) {
                    idLoc = childYaml.getYamlValue();
                } else if (childYaml.getYamlId().equals(NAME_ID)) {
                    nameLoc = childYaml.getYamlValue();
                } else if (childYaml.getYamlId().equals(DESCRIPTION_ID)) {
                    descriptionLoc = childYaml.getYamlValue();
                }
            }
            if (!(childYaml instanceof YamlStorableList) || !childYaml.getYamlId().equals("accesses") || (accessYamls = childYaml.getYamlChildren()) == null) continue;
            Iterator iterator = accessYamls.iterator();
            while (iterator.hasNext()) {
                StorageTeeUserDomainAccessConfig fromYaml = new StorageTeeUserDomainAccessConfig();
                IYamlStorable accessYaml = (IYamlStorable)iterator.next();
                if (!fromYaml.updateFromYamlStorable(accessYaml)) continue;
                accessConfigsLoc.add(fromYaml);
            }
        }
        this.setSecurityLevel(securityLevelLoc);
        this.setId(idLoc);
        this.setName(nameLoc);
        this.setDescription(descriptionLoc);
        this.setAccessConfigs(accessConfigsLoc);
        return true;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.description, this.id, this.name, this.securityLevel);
        return result;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equals(obj) || this.getClass() != obj.getClass()) {
            return false;
        }
        StorageTeeUserMemoryRegionConfig other = (StorageTeeUserMemoryRegionConfig)obj;
        return Objects.equals(this.description, other.description) && Objects.equals(this.id, other.id) && Objects.equals(this.name, other.name) && Objects.equals(this.securityLevel, other.securityLevel) && Objects.equals(this.accessConfigs, other.accessConfigs);
    }
}

