/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.features;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.expert.processordb.AProcessorFilterForSwTools;
import com.nxp.swtools.expert.processordb.ExternalMcuDataHelper;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.features.McuDataId;
import com.nxp.swtools.provider.features.SdkFeatures;
import java.io.File;
import java.lang.ref.SoftReference;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class SdkFeaturesProvider {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(SdkFeaturesProvider.class);
    @NonNull
    private static final @NonNull Map<@NonNull McuDataId, SoftReference<SdkFeatures>> FEATURES = new HashMap<McuDataId, SoftReference<SdkFeatures>>();
    @NonNull
    private static final String SDK_FEATURES_PATTERN = "sdk_features_.*\\.xml";

    private SdkFeaturesProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable SdkFeatures getSdkFeatures(@NonNull ISupportedDerivativesForSwTools derivatives, @NonNull IMcuIdentification mcuSelection) {
        String mcu = mcuSelection.getMcu();
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(mcu, mcuSelection.getSdkVersion());
        if (info == null) {
            LOGGER.severe("Mcu info not found: " + mcuSelection);
            return null;
        }
        McuDataId mcuId = new McuDataId(mcu, info.getVersion(), mcuSelection.getSdkVersion());
        Class<SdkFeaturesProvider> clazz = SdkFeaturesProvider.class;
        synchronized (SdkFeaturesProvider.class) {
            SdkFeatures result;
            SoftReference<SdkFeatures> softReference = FEATURES.get(mcuId);
            SdkFeatures sdkFeatures = result = softReference == null ? null : softReference.get();
            if (result == null) {
                String file = derivatives.getDbFileName(info, mcuSelection.getPackage(), AProcessorFilterForSwTools.DB_TYPE_SDK_FEATURES);
                if (file != null) {
                    Path derivativesPath = new File(derivatives.getDataDir()).toPath();
                    Path sdkFeaturesFile = derivativesPath.resolve(file);
                    if (sdkFeaturesFile.toFile().exists()) {
                        result = SdkFeatures.read(sdkFeaturesFile);
                    }
                    SdkFeaturesProvider.readSdkFeaturesFromFile(result, sdkFeaturesFile, derivativesPath);
                    String externalDataDir = ExternalMcuDataHelper.getInstance().getExternalMcuDataDir(mcuSelection.getMcu(), mcuSelection.getSdkVersion());
                    if (externalDataDir != null) {
                        SdkFeatures extSdkFeatures;
                        Path externalDataPath = new File(externalDataDir).toPath();
                        Path externalSdkFeaturesFile = externalDataPath.resolve(file);
                        HashMap<@NonNull String, @NonNull SdkFeatures> externalSdkFeatures = new HashMap<String, SdkFeatures>();
                        if (externalSdkFeaturesFile.toFile().exists() && (extSdkFeatures = SdkFeatures.read(externalSdkFeaturesFile)) != null) {
                            if (result == null) {
                                result = extSdkFeatures;
                            } else {
                                externalSdkFeatures.put(externalSdkFeaturesFile.toFile().getName(), extSdkFeatures);
                                result.mergeContent(externalSdkFeatures);
                                SdkFeaturesProvider.readSdkFeaturesFromFile(result, externalSdkFeaturesFile, externalDataPath);
                            }
                        }
                    }
                }
                if (result != null) {
                    FEATURES.put(mcuId, new SoftReference<SdkFeatures>(result));
                }
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return result;
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void readSdkFeaturesFromFile(SdkFeatures result, Path sdkFeaturesFile, Path derivativesPath) {
        Path sdkFeaturesRoot = sdkFeaturesFile.getParent();
        if (sdkFeaturesRoot != null && result != null) {
            @NonNull List sdkFeaturesFiles = UtilsFile.findAllFiles((String)UtilsText.safeString((String)sdkFeaturesRoot.toString()), (boolean)false);
            HashMap<@NonNull String, @NonNull SdkFeatures> foundSdkFeatures = new HashMap<String, SdkFeatures>();
            for (String filePath : sdkFeaturesFiles) {
                SdkFeatures tempFeaturesFile;
                File fileInst = new File(filePath);
                if (!fileInst.exists() || !fileInst.getName().matches(SDK_FEATURES_PATTERN) || (tempFeaturesFile = SdkFeatures.read(derivativesPath.resolve(filePath))) == null) continue;
                foundSdkFeatures.put(fileInst.getName(), tempFeaturesFile);
            }
            if (!foundSdkFeatures.isEmpty()) {
                result.mergeContent(foundSdkFeatures);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushCache() {
        Class<SdkFeaturesProvider> clazz = SdkFeaturesProvider.class;
        synchronized (SdkFeaturesProvider.class) {
            FEATURES.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

