/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.sdk;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.kex.sdk.ISdkApiClient;
import com.nxp.swtools.kex.sdk.ISdkContent;
import com.nxp.swtools.kex.sdk.ISdkTag;
import com.nxp.swtools.kex.sdk.SdkApiFactory;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SdkInfoProvider {
    @NonNull
    static final Logger LOGGER = LogManager.getLogger(SdkInfoProvider.class);
    @NonNull
    IMcuIdentification identification;
    @NonNull
    private ISdkApiClient sdkApi;
    @Nullable
    private ISdkTag tag;
    @Nullable
    private ISdkContent sdkContentCache;

    public SdkInfoProvider(@NonNull IMcuIdentification identification, @NonNull ISdkTag tag) {
        this.identification = identification;
        this.sdkApi = SdkApiFactory.createSdkClientApi();
        this.tag = tag;
    }

    public SdkInfoProvider(@NonNull IMcuIdentification identification) {
        this.identification = identification;
        this.sdkApi = SdkApiFactory.createSdkClientApi();
        String config = SdkInfoProvider.createConfigForWeb(identification);
        if (config != null) {
            try {
                this.tag = this.sdkApi.getSdkTag(UtilsText.safeString((String)config));
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "sdkApi.getSdkTag", e);
            }
        } else {
            LOGGER.severe("MCU identification does not have neither processor, kit nor board. Required for accessing SDK API");
        }
    }

    public static @Nullable String createConfigForWeb(@NonNull IMcuIdentification identification) {
        String config = UtilsText.getFirstNonEmptyString((String[])new String[]{identification.getKit(), identification.getBoard(), identification.getMcu()});
        return config;
    }

    public @Nullable InputStream getManifest() {
        ISdkTag tagLoc = this.tag;
        if (tagLoc == null) {
            LOGGER.severe("No information about SDK");
            return null;
        }
        return this.sdkApi.getManifest(tagLoc);
    }

    public @Nullable ISdkContent getSdkContent() {
        ISdkTag tagLoc = this.tag;
        if (tagLoc == null) {
            LOGGER.severe("No information about SDK");
            return null;
        }
        ISdkContent sdkContentLoc = this.sdkContentCache;
        if (sdkContentLoc != null) {
            return sdkContentLoc;
        }
        this.sdkContentCache = this.sdkApi.getSdkContent(tagLoc.getTag());
        return this.sdkContentCache;
    }

    public @Nullable InputStream getFile(@NonNull String fileName) {
        ISdkTag tagLoc = this.tag;
        if (tagLoc == null) {
            LOGGER.severe("No information about SDK");
            return null;
        }
        assert (fileName.startsWith("/"));
        return this.sdkApi.getFile(tagLoc.getTag(), fileName);
    }
}

