/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.provider.toolchainproject.files;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.toolchainproject.files.IProjectFileAccess;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Stream;

public class ProjectFileAccessFactory {
    public static @NonNull IProjectFileAccess getProjectFileAccess(final Path prjBasePath) {
        assert (!SWToolsPlatform.isRunningInMCUXpressoIde());
        return new IProjectFileAccess(){

            @Override
            public @NonNull Stream<@NonNull String> listFiles(@NonNull Path relDir) {
                File abs = prjBasePath.resolve(relDir).normalize().toFile();
                File[] files = abs.listFiles();
                if (files == null) {
                    files = new File[]{};
                }
                Stream<@NonNull String> result = Arrays.stream(files).filter(f -> f.isFile()).map(f -> f.getName());
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError();
                }
                return result;
            }

            @Override
            public @NonNull Stream<@NonNull String> listSubDirectories(@NonNull Path relDir) {
                File abs = prjBasePath.resolve(relDir).toFile();
                File[] files = abs.listFiles();
                if (files == null) {
                    files = new File[]{};
                }
                Stream<@NonNull String> result = Arrays.stream(files).filter(f -> f.isDirectory()).map(f -> f.getName());
                if (!$assertionsDisabled && result == null) {
                    throw new AssertionError();
                }
                return result;
            }
        };
    }
}

