/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.core.memory.transport;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import org.eclipse.cdt.debug.core.memory.transport.ExportRequest;
import org.eclipse.cdt.debug.core.memory.transport.IReadMemory;
import org.eclipse.cdt.debug.internal.core.memory.transport.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class FileExport
implements ICoreRunnable {
    protected final BigInteger start;
    protected final BigInteger end;
    protected final BigInteger addressable;
    protected final IReadMemory read;
    private final File file;

    protected FileExport(File input, ExportRequest request) {
        this.file = input;
        this.start = request.start();
        this.end = request.end();
        this.addressable = request.addressable();
        this.read = request.read();
    }

    /*
     * Loose catch block
     */
    public void run(IProgressMonitor monitor) throws CoreException {
        try {
            try {
                Throwable throwable = null;
                Object var3_7 = null;
                try (OutputStream output = this.output(this.file);){
                    BigInteger jobs = this.end.subtract(this.start).divide(this.chunkSize());
                    BigInteger factor = BigInteger.ONE;
                    if (jobs.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
                        factor = jobs.divide(BigInteger.valueOf(Integer.MAX_VALUE));
                        jobs = jobs.divide(factor);
                    }
                    monitor.beginTask(Messages.FileExport_task_transferring, jobs.intValue());
                    this.transfer(output, factor, monitor);
                    output.flush();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException ex) {
                this.requestFailed(Messages.FileExport_e_write_file, ex);
                monitor.done();
            }
            catch (DebugException ex) {
                this.requestFailed(Messages.FileExport_e_read_target, ex);
                monitor.done();
            }
            catch (Exception ex) {
                this.internalError(Messages.FileExport_e_export_memory, ex);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    protected OutputStream output(File file) throws IOException {
        file.getParentFile().mkdirs();
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    protected abstract BigInteger chunkSize();

    protected abstract void transfer(OutputStream var1, BigInteger var2, IProgressMonitor var3) throws IOException, DebugException;

    protected String transferring(BigInteger length, BigInteger address) {
        return String.format(Messages.FileExport_sub_transferring, length.toString(10), address.toString(16));
    }

    protected void requestFailed(String message, Throwable exception) throws DebugException {
        this.failed(5012, message, exception);
    }

    protected void internalError(String message, Throwable exception) throws DebugException {
        this.failed(5013, message, exception);
    }

    protected void failed(int code, String message, Throwable exception) throws DebugException {
        Status status = new Status(4, this.getClass(), code, message, exception);
        this.failed(new DebugException((IStatus)status));
    }

    protected void failed(DebugException exception) throws DebugException {
        if (Platform.isRunning()) {
            Platform.getLog((Bundle)FrameworkUtil.getBundle(this.getClass())).log(exception.getStatus());
        }
        throw exception;
    }
}

