/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.jse.utils;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public final class FuncUtils {
    private FuncUtils() {
    }

    public static <A, E extends Exception> Consumer<A> rethrowingConsumer(ThrowingConsumer<A, E> consumer) {
        return arg -> {
            try {
                consumer.consume(arg);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static <A, R, E extends Exception> Function<A, R> loggingFunction(ThrowingFunction<A, R, E> func, R defaultValue) {
        return arg -> {
            try {
                return func.apply(arg);
            }
            catch (Exception exception) {
                return defaultValue;
            }
        };
    }

    public static <T> Predicate<T> not(Predicate<T> predicate) {
        return predicate.negate();
    }

    public static <A, E extends Exception> Predicate<A> loggingPredicate(ThrowingPredicate<A, E> predicate, boolean value) {
        return arg -> {
            try {
                return predicate.test(arg);
            }
            catch (Exception exception) {
                return value;
            }
        };
    }

    public static <A, E extends Exception> Consumer<A> loggingConsumer(ThrowingConsumer<A, E> consumer) {
        return arg -> {
            try {
                consumer.consume(arg);
            }
            catch (Exception exception) {}
        };
    }

    public static <A, B> Consumer<A> bindConsumer(BiConsumer<A, B> f, B b) {
        return a -> f.accept(a, b);
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<A, E extends Exception> {
        public void consume(A var1) throws E;
    }

    @FunctionalInterface
    public static interface ThrowingFunction<A, R, E extends Exception> {
        public R apply(A var1) throws E;
    }

    @FunctionalInterface
    public static interface ThrowingPredicate<A, E extends Exception> {
        public boolean test(A var1) throws E;
    }
}

