/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.core.searchengine;

import com.nxp.s32ds.ext.ide.core.internal.ExtIdeCoreActivator;
import com.nxp.s32ds.ext.ide.core.searchengine.ResourceSearchRequestor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.text.edits.ReplaceEdit;

public class ResourceSearchEngine {
    private static final String REVERT_SEARCH = "(?s)\\A((?!%s).)*\\Z";

    static Map<IFile, List<ReplaceEdit>> revertSearch(IResource project, String[] filesExtensions, String search, String replace, IProgressMonitor pm) {
        IResource[] roots = new IResource[]{project};
        Pattern searchPattern = Pattern.compile(String.format(REVERT_SEARCH, search), 8);
        return ResourceSearchEngine.searchResourceByExtensions(filesExtensions, replace, pm, roots, searchPattern);
    }

    static Map<IFile, List<ReplaceEdit>> directSearch(IResource project, String[] filesExtensions, String search, String replace, IProgressMonitor pm) {
        IResource[] roots = new IResource[]{project};
        Pattern searchPattern = Pattern.compile(search, 8);
        return ResourceSearchEngine.searchResourceByExtensions(filesExtensions, replace, pm, roots, searchPattern);
    }

    private static Map<IFile, List<ReplaceEdit>> searchResourceByExtensions(String[] filesExtensions, String replace, IProgressMonitor pm, IResource[] roots, Pattern searchPattern) {
        HashMap<IFile, List<ReplaceEdit>> result = new HashMap<IFile, List<ReplaceEdit>>();
        String[] stringArray = filesExtensions;
        int n = filesExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern filePattern;
            TextSearchScope filesScope;
            Map<IFile, List<ReplaceEdit>> resources;
            String extension = stringArray[n2];
            if (extension.startsWith("*")) {
                extension = "." + extension;
            }
            if ((resources = ResourceSearchEngine.searchResourceByPattern(searchPattern, replace, filesScope = TextSearchScope.newSearchScope((IResource[])roots, (Pattern)(filePattern = Pattern.compile(extension)), (boolean)false), pm)) != null) {
                result.putAll(resources);
            }
            ++n2;
        }
        return result;
    }

    private static Map<IFile, List<ReplaceEdit>> searchResourceByPattern(Pattern searchPattern, String replace, TextSearchScope filesScope, IProgressMonitor pm) {
        ResourceSearchRequestor searchRequestor = new ResourceSearchRequestor(replace);
        TextSearchEngine engine = TextSearchEngine.createDefault();
        if (engine == null) {
            Status status = new Status(4, ExtIdeCoreActivator.getPluginId(), "TextSearchEngine not accessiable");
            ExtIdeCoreActivator.getInstance().log((IStatus)status);
            return null;
        }
        IStatus searchStatus = engine.search(filesScope, (TextSearchRequestor)searchRequestor, searchPattern, (IProgressMonitor)new NullProgressMonitor());
        if (searchStatus.isOK()) {
            return searchRequestor.getFileChanges();
        }
        ExtIdeCoreActivator.getInstance().log(searchStatus);
        return null;
    }
}

