/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.svd.registry.core;

import com.nxp.s32ds.cle.runtime.svd.internal.registry.core.SvdRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.svd.registry.SvdDescriptor;
import com.nxp.s32ds.cle.runtime.svd.registry.SvdRegistry;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class SvdDescriptors {
    public static SvdRegistry getSvdRegistry() {
        return SvdRegistryCoreActivator.getInstance().getSvdRegistry();
    }

    public static void addSvdDescriptor(SvdDescriptor descriptor) {
        SvdDescriptors.getSvdRegistry().addSvdDescriptor(descriptor);
    }

    public static List<SvdDescriptor> getSvdDescriptors() {
        return SvdDescriptors.getSvdRegistry().getSvdDescriptors();
    }

    public static void removeSvdDescriptor(SvdDescriptor descriptor) {
        SvdDescriptors.getSvdRegistry().removeSvdDescriptor(descriptor);
    }

    public static SvdDescriptor getSvdDescriptor(String svdId) {
        return SvdDescriptors.getSvdRegistry().getSvdDescriptor(svdId);
    }

    public static List<SvdDescriptor> getSvdDescriptorsByDeviceId(String deviceId) {
        return SvdDescriptors.getSvdDescriptors().stream().filter(d -> d.getDeviceId().equals(deviceId)).collect(Collectors.toList());
    }

    public static List<SvdDescriptor> getSvdDescriptorsByCoreId(String coreId) {
        return SvdDescriptors.getSvdDescriptors().stream().filter(d -> d.getCoreId().equals(coreId)).collect(Collectors.toList());
    }

    public static Optional<SvdDescriptor> getSvdDescriptorsByDeviceIdCoreIds(String deviceId, String coreId) {
        return SvdDescriptors.getSvdDescriptors().stream().filter(d -> d.getCoreId().equals(coreId) && d.getDeviceId().equals(deviceId)).findFirst();
    }

    public static Optional<SvdDescriptor> getSystemRegistersSvdByCoreId(String coreId) {
        return SvdDescriptors.getSvdDescriptors().stream().filter(d -> d.getCoreId().equals(coreId)).filter(d -> d.getSysPath() != null && !d.getSysPath().isEmpty()).findFirst();
    }

    public static Optional<SvdDescriptor> getCoreRegistersSvdByCoreId(String coreId) {
        return SvdDescriptors.getSvdDescriptors().stream().filter(d -> d.getCoreId().equals(coreId)).filter(d -> d.getArmPath() != null).findFirst();
    }
}

