/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.makefilegenerator;

import com.nxp.s32ds.ext.cdt.core.makefilegenerator.GnuMakefileGenerator;
import com.nxp.s32ds.ext.cdt.makefilegenerator.Activator;
import com.nxp.s32ds.ext.cdt.makefilegenerator.ArgumentFileBuilder;
import com.nxp.s32ds.ext.cdt.makefilegenerator.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFileInfo;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.macros.BuildMacroException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;

public class MakefileGenerator
extends GnuMakefileGenerator {
    protected final ArgumentFileBuilder argumentFileBuilder;
    private final HashMap<String, List<String>> buildVarsAgregateValues = new HashMap();

    public MakefileGenerator() {
        this.argumentFileBuilder = new ArgumentFileBuilder(this);
    }

    public MultiStatus generateMakefiles(IResourceDelta delta) throws CoreException {
        this.argumentFileBuilder.resetNameList();
        return super.generateMakefiles(delta);
    }

    protected void populateTopMakefile(IFile fileHandle, boolean rebuild) throws CoreException {
        this.enableCompactBuildCommands();
        super.populateTopMakefile(fileHandle, rebuild);
        this.disableCompactBuildCommands();
        this.argumentFileBuilder.writeBuildCommands(fileHandle.getParent().getLocation(), this.topBuildDir);
    }

    protected IPath populateFragmentMakefile(IContainer module) throws CoreException {
        this.enableCompactBuildCommands();
        IPath moduleOutputDir = super.populateFragmentMakefile(module);
        this.disableCompactBuildCommands();
        this.argumentFileBuilder.writeBuildCommands(moduleOutputDir, moduleOutputDir);
        return moduleOutputDir;
    }

    protected String[] getToolCommandFlags(ITool tool, String targetName, IPath sourceLocation, IPath outputLocation, String relativePath, boolean needExplicitRuleForFile) {
        String[] flags = super.getToolCommandFlags(tool, targetName, sourceLocation, outputLocation, relativePath, needExplicitRuleForFile);
        if (flags.length > 0) {
            flags = this.argumentFileBuilder.convertFlags(relativePath, sourceLocation, tool, outputLocation, needExplicitRuleForFile, flags, targetName, this.getTopBuildDir());
        }
        return flags;
    }

    protected void enableCompactBuildCommands() {
        this.argumentFileBuilder.enable();
    }

    protected void disableCompactBuildCommands() {
        this.argumentFileBuilder.disable();
    }

    protected void addCleanTargetRule(ITool targetTool, StringBuffer buffer) {
        buffer.append("clean:").append(NEWLINE);
        buffer.append("\t").append("-$(RM)").append(" ");
        buffer.append("./*");
        buffer.append(NEWLINE);
        buffer.append("\t").append("-").append("@").append(ECHO_BLANK_LINE).append(NEWLINE);
    }

    public IProject getProject() {
        return this.project;
    }

    public IPath getBuildWorkingDirLocation() {
        return this.getBuildWorkingDirLocation(this.builder);
    }

    private IPath getBuildWorkingDirLocation(IBuilder builder) {
        if (this.topBuildDir != null) {
            return this.topBuildDir;
        }
        return MakefileGenerator.getBuildWorkingDirLocationStatic(builder);
    }

    private static IPath getBuildWorkingDirLocationStatic(IBuilder builder) {
        IConfiguration config = ((Builder)builder).getConfguration();
        IProject project = config.getOwner().getProject();
        String attribute = ((Builder)builder).getBuildPathAttribute();
        if (attribute != null) {
            IPath projectLocation;
            attribute = MakefileGenerator.resolveValueToMakefileFormat(attribute, builder.getParent().getParent());
            IPath buildLocation = Path.fromOSString((String)attribute);
            if (attribute.length() == 0) {
                buildLocation = project.getLocation().append(config.getName());
            }
            if (!(projectLocation = project.getLocation()).isPrefixOf(buildLocation)) {
                String folderName = "build-" + project.getName() + "-" + config.getName();
                buildLocation = buildLocation.append(folderName);
            }
            return buildLocation;
        }
        return null;
    }

    protected String resolveValueToMakefileFormat(String value) {
        return MakefileGenerator.resolveValueToMakefileFormat(value, 3, this.getConfig());
    }

    protected static String resolveValueToMakefileFormat(String value, IConfiguration configuration) {
        return MakefileGenerator.resolveValueToMakefileFormat(value, 3, configuration);
    }

    protected static String resolveValueToMakefileFormat(String value, int contextType, Object contextData) {
        try {
            value = ManagedBuildManager.getBuildMacroProvider().resolveValueToMakefileFormat(value, "", " ", contextType, contextData);
        }
        catch (BuildMacroException e) {
            Activator.log((Exception)((Object)e));
        }
        return value;
    }

    public String getRelativeOutputPath(IPath sourceLocation, boolean generatedSource) {
        String srcName;
        IPath projectLocation;
        IPath dirLocation = projectLocation = this.project.getLocation();
        if (generatedSource) {
            dirLocation = this.getBuildWorkingDirLocation();
        }
        if (dirLocation.isPrefixOf(sourceLocation)) {
            IPath srcPath = sourceLocation.removeFirstSegments(dirLocation.segmentCount()).setDevice(null);
            if (generatedSource) {
                srcName = "./" + srcPath.toString();
            } else {
                IPath buildLoc = this.getBuildWorkingDirLocation();
                if (dirLocation.isPrefixOf(buildLoc)) {
                    IPath diffPath = buildLoc.removeFirstSegments(dirLocation.segmentCount()).setDevice(null);
                    int count = diffPath.segmentCount();
                    srcName = srcPath.toString();
                    int i = 0;
                    while (i < count) {
                        srcName = "../" + srcName;
                        ++i;
                    }
                } else {
                    srcName = sourceLocation.toString();
                }
            }
        } else {
            srcName = sourceLocation.toString();
        }
        return srcName;
    }

    public Vector<IPath> getRelativeOutputLocations(IResource file, ITool tool) {
        return this.getRelativeOutputLocations(file, tool, true);
    }

    public Vector<IPath> getRelativeOutputLocations(IResource file, ITool tool, boolean resolveConflicts) {
        boolean containsConflictingOutputNames;
        Vector ruleOutputs = new Vector();
        IResource[] siblings = new IResource[]{};
        try {
            if (file.getParent().exists()) {
                siblings = file.getParent().members();
            }
        }
        catch (CoreException e) {
            Activator.log((Exception)((Object)e));
        }
        HashMap<String, String> sourceOutputMap = new HashMap<String, String>();
        if (resolveConflicts && (containsConflictingOutputNames = this.generateSourceOutputNameMap(siblings, sourceOutputMap))) {
            sourceOutputMap.get(file.getLocation().toString());
        }
        Vector<IPath> enumeratedPrimaryOutputs = new Vector<IPath>();
        Vector enumeratedSecondaryOutputs = new Vector();
        String relativePath = String.valueOf(file.getProjectRelativePath().removeLastSegments(1).toString()) + "/";
        this.calculateOutputsForSource(tool, relativePath, file, file.getLocation(), ruleOutputs, enumeratedPrimaryOutputs, enumeratedSecondaryOutputs);
        if (enumeratedPrimaryOutputs.size() > 0) {
            return enumeratedPrimaryOutputs;
        }
        IPath path = new Path(relativePath).append(Utils.getDefaultOutputName(tool, file.getLocation()));
        Vector<IPath> paths = new Vector<IPath>();
        paths.add(path);
        return paths;
    }

    protected boolean generateSourceOutputNameMap(IResource[] resources, HashMap<String, String> sourceOutputMap) {
        Hashtable<String, Integer> outputNamesMap = new Hashtable<String, Integer>();
        IPath[] sourceLocations = new IPath[resources.length];
        boolean[] shouldResolveConflicts = new boolean[resources.length];
        String[] fileNames = new String[resources.length];
        String[] optDotExts = new String[resources.length];
        boolean isConflicting = false;
        int i = 0;
        while (i < resources.length) {
            IPath rcProjRelPath;
            IResource resource = resources[i];
            if (resource.getType() == 1 && this.isSource(rcProjRelPath = resource.getProjectRelativePath())) {
                ITool tool;
                String inputExtension;
                sourceLocations[i] = resource.getLocation();
                IResourceInfo rcInfo = this.getConfig().getResourceInfo(resource.getProjectRelativePath(), false);
                if (sourceLocations[i] != null && (inputExtension = sourceLocations[i].getFileExtension()) != null && (tool = MakefileGenerator.getToolToInvoke(rcInfo, inputExtension)) != null) {
                    shouldResolveConflicts[i] = true;
                    Vector<IPath> relativeOutputLocations = this.getRelativeOutputLocations(resource, tool, false);
                    String outputExtension = relativeOutputLocations.get(0).getFileExtension();
                    fileNames[i] = relativeOutputLocations.get(0).removeFileExtension().lastSegment();
                    optDotExts[i] = "";
                    if (outputExtension != null && outputExtension.length() > 0) {
                        optDotExts[i] = "." + outputExtension;
                    }
                    MakefileGenerator.recordOutputNameOccurance(outputNamesMap, String.valueOf(fileNames[i]) + optDotExts[i]);
                }
            }
            ++i;
        }
        i = 0;
        while (i < resources.length) {
            if (shouldResolveConflicts[i]) {
                String outputName = fileNames[i];
                String key = String.valueOf(outputName) + optDotExts[i];
                Integer count = (Integer)outputNamesMap.get(key);
                if (count != null && count > 1) {
                    String qualifiedFileName;
                    outputName = qualifiedFileName = sourceLocations[i].lastSegment().replace(".", "_");
                    isConflicting = true;
                    int increment = 1;
                    while (outputNamesMap.contains(String.valueOf(outputName) + optDotExts[i])) {
                        outputName = String.valueOf(qualifiedFileName) + increment;
                        ++increment;
                    }
                }
                MakefileGenerator.recordOutputNameOccurance(outputNamesMap, String.valueOf(outputName) + optDotExts[i]);
                sourceOutputMap.put(sourceLocations[i].toString(), outputName);
            }
            ++i;
        }
        return isConflicting;
    }

    private static ITool getToolToInvoke(IResourceInfo rcInfo, String inputExtension) {
        ITool tool = null;
        if (rcInfo instanceof IFileInfo) {
            IFileInfo fi = (IFileInfo)rcInfo;
            ITool[] tools = fi.getToolsToInvoke();
            if (tools != null && tools.length > 0) {
                tool = tools[0];
            }
        } else {
            IFolderInfo foInfo = (IFolderInfo)rcInfo;
            tool = foInfo.getToolFromInputExtension(inputExtension);
        }
        return tool;
    }

    private static void recordOutputNameOccurance(Hashtable<String, Integer> outputNamesMap, String key) {
        Integer count = outputNamesMap.get(key);
        if (count != null) {
            outputNamesMap.put(key, count + 1);
        } else {
            outputNamesMap.put(key, 1);
        }
    }

    protected String geToolCommandFlagsString(ITool tool, String outputPrefix, String outflag, String primaryOutputs, String command, IManagedCommandLineInfo cmdLInfo, String targetName) {
        String buildCmd = super.geToolCommandFlagsString(tool, outputPrefix, outflag, primaryOutputs, command, cmdLInfo, targetName);
        buildCmd = this.argumentFileBuilder.convertBuildCmd(tool, targetName, buildCmd, this.getConfig(), this.getBuildTargetExt(), this);
        return buildCmd;
    }

    protected void addMacroAdditionFile(HashMap<String, String> map, String macroName, String filename) {
        super.addMacroAdditionFile(map, macroName, filename);
        List<String> aggregateValue = this.buildVarsAgregateValues.get(macroName);
        if (aggregateValue != null) {
            if (!aggregateValue.contains(filename)) {
                aggregateValue.add(filename);
            }
        } else {
            aggregateValue = new ArrayList<String>();
            aggregateValue.add(filename);
        }
        this.buildVarsAgregateValues.put(macroName, aggregateValue);
    }

    final HashMap<String, List<String>> getBuildVarsAgregateValues() {
        return this.buildVarsAgregateValues;
    }

    public static List<String> convertToWildCardFormat(List<String> strings) {
        ArrayList<String> genericValues = new ArrayList<String>();
        for (String str : strings) {
            String ext = str.substring(str.lastIndexOf("."));
            String[] segs = str.split("/");
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < segs.length - 1) {
                if (segs[i].equals(".") || segs[i].equals("\".")) {
                    sb.append(segs[i]).append("/");
                } else if (segs[i].startsWith("\"")) {
                    sb.append("\"").append("*").append("/");
                }
                ++i;
            }
            if (ext != null && ext.length() > 0) {
                sb.append("*").append(ext);
            } else {
                sb.append(segs[segs.length - 1]);
            }
            String result = sb.toString();
            if (result.length() <= 0 || genericValues.contains(result)) continue;
            genericValues.add(result);
        }
        return genericValues;
    }
}

