/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.makefilegenerator.linkorder;

import com.nxp.s32ds.ext.cdt.build.tools.extension.BuildToolExtensions;
import com.nxp.s32ds.ext.cdt.build.tools.extension.registry.BuildToolDescriptor;
import com.nxp.s32ds.ext.cdt.makefilegenerator.Activator;
import com.nxp.s32ds.ext.cdt.makefilegenerator.linkorder.SourceChainMap;
import com.nxp.s32ds.ext.rcp.jse.utils.FuncUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class LinkOrder {
    private final ITool linker;

    public LinkOrder(ITool linker) {
        this.linker = linker;
    }

    public boolean isEnabled() {
        return Option.ENABLED.get(this.linker).map(FuncUtils.loggingFunction(IOption::getBooleanValue, (Object)false)).orElse(false);
    }

    public void update(IConfiguration configuration) {
        Option.LIST.get(this.linker).ifPresent(LinkOrder.updateStringListOption(this.calculateUpdatedLinkOrder(configuration)));
    }

    private static Optional<IProject> getProject(IConfiguration configuration) {
        return Optional.ofNullable(configuration).map(IConfiguration::getOwner).filter(IProject.class::isInstance).map(IProject.class::cast).filter(IResource::isAccessible);
    }

    private static Consumer<IOption> updateStringListOption(Function<String[], String[]> updater) {
        return FuncUtils.loggingConsumer(option -> option.setValue((String[])updater.apply(option.getBasicStringListValue())));
    }

    public Optional<String[]> get() {
        return Option.LIST.get(this.linker).map(FuncUtils.loggingFunction(IOption::getBasicStringListValue, null));
    }

    private Function<String[], String[]> calculateUpdatedLinkOrder(IConfiguration configuration) {
        List inputs = Stream.concat(this.getLinkerSourceInputs(configuration), this.getUserSourceInputs()).collect(Collectors.toList());
        return baseline -> (String[])Stream.concat(Stream.of(baseline).filter(inputs::contains), inputs.stream().filter(FuncUtils.not(Arrays.asList(baseline)::contains))).toArray(String[]::new);
    }

    private Stream<String> getUserSourceInputs() {
        return Stream.of(this.linker.getOptions()).filter(FuncUtils.loggingPredicate(o -> o.getValueType() == 7, (boolean)false)).map(FuncUtils.loggingFunction(IOption::getBasicStringListValue, null)).filter(Objects::nonNull).flatMap(stringArray -> Stream.of(stringArray));
    }

    private static List<IResource> getResources(IContainer container) {
        return new ArrayList<IResource>(container){
            {
                try {
                    iContainer.accept(this::add);
                }
                catch (CoreException e) {
                    Activator.log((Exception)((Object)e));
                }
            }
        };
    }

    private Stream<String> getLinkerSourceInputs(IConfiguration configuration) {
        SourceChainMap chains = new SourceChainMap(this.linker);
        return LinkOrder.getProject(configuration).map(LinkOrder::getResources).orElseGet(Collections::emptyList).stream().filter(resource -> resource.getType() == 1).filter(resource -> !CDataUtil.isExcluded((IPath)resource.getProjectRelativePath(), (ICSourceEntry[])configuration.getSourceEntries())).filter(resource -> chains.containsKey(resource.getFileExtension())).map(IResource::getProjectRelativePath).map(IPath::toPortableString);
    }

    private static enum Option {
        ENABLED("linkOrderEnabled"),
        LIST("linkOrder");

        private final String suffix;

        private Option(String suffix) {
            this.suffix = suffix;
        }

        public Optional<IOption> get(ITool linker) {
            List options = BuildToolExtensions.getBuildToolOptionDescriptors().stream().filter(BuildToolDescriptor::isEnabled).map(BuildToolDescriptor::getToolOptionId).collect(Collectors.toList());
            return options.stream().map(prefix -> prefix.concat("." + this.suffix)).map(arg_0 -> ((ITool)linker).getOptionBySuperClassId(arg_0)).filter(Objects::nonNull).findAny();
        }
    }
}

