/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.resources.path;

import com.nxp.s32ds.ext.ide.internal.resources.ResourcesMessages;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class OverlappedWorkspacePathValidator
implements IValidator<String> {
    public static final String ID = "path.overlapped.workspace.validator";

    public IStatus validate(String path) {
        if (path == null) {
            return new Status(4, "com.nxp.s32ds.ext.ide.resources", ResourcesMessages.ProjectPathValidator_invalid_path);
        }
        Path fullPath = Paths.get(path, new String[0]);
        IStatus overlappingStatus = OverlappedWorkspacePathValidator.checkOverlappingWithWorkspace(fullPath);
        return overlappingStatus;
    }

    private static IStatus checkOverlappingWithWorkspace(Path pathToCheck) {
        Path workspacePath = Paths.get(ResourcesPlugin.getWorkspace().getRoot().getLocation().toString(), new String[0]);
        if (workspacePath.startsWith(pathToCheck)) {
            return new Status(4, "com.nxp.s32ds.ext.ide.resources", NLS.bind((String)ResourcesMessages.ProjectPathValidator_overlaps_workspace, (Object)pathToCheck.toString(), (Object)workspacePath.toString()));
        }
        return Status.OK_STATUS;
    }
}

