/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.actions.project.configuration;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdater;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdaters;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.UpdateOperation;
import com.nxp.s32ds.cle.runtime.migration.action.MigrationAction;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationEntityAnnotation;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationPropertyAnnotation;
import com.nxp.s32ds.cle.runtime.migration.core.MigrationsAssert;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

@MigrationEntityAnnotation(name="Replace the value of the option for CDT toolchains and tools", description="Replace option values for CDT toolchains and tools.It is shortcut for ModifyToolchainOption that performs the 'remove' operation for old values and 'add' operation for new ones.")
public class ReplaceToolchainOptionValueAction
implements MigrationAction {
    @MigrationPropertyAnnotation(description="The ID of option.")
    private String optionId;
    @MigrationPropertyAnnotation(name="oldOptionValue", description="The old value of option.")
    private List<String> oldOptionValues;
    @MigrationPropertyAnnotation(name="newOptionValue", description="The new value of option.")
    private List<String> newOptionValues;

    public void perform(IProject project, IProgressMonitor monitor) throws CoreException {
        ProjectSettingsUpdater optionUpdater = ProjectSettingsUpdaters.getOptionUpdater();
        MigrationsAssert.assertIsOk(ProjectConfigurationUtils.getProjectConfigurations((IProject)project).stream().flatMap(c -> Stream.of(optionUpdater.update(c, this.optionId, this.oldOptionValues, UpdateOperation.REMOVE), optionUpdater.update(c, this.optionId, this.newOptionValues, UpdateOperation.ADD))));
    }
}

