/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.conditions.launch;

import com.nxp.s32ds.cle.cdt.internal.migration.CdtMigrationActivator;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationEntityAnnotation;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationPropertyAnnotation;
import com.nxp.s32ds.cle.runtime.migration.condition.MigrationCondition;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;

@MigrationEntityAnnotation(name="Checks if launch configuration is used for project.", description="Checks if specific launch configuration is used for project.")
public class LaunchConfigurationIsUsedCondition
implements MigrationCondition {
    @MigrationPropertyAnnotation(description="Launch configuration type.")
    private String launchConfigurationType;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean match(IProject project) {
        try {
            ILaunchConfiguration[] launchConfigurations;
            ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            int n = launchConfigurations.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
                if (launchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "").equals(project.getName()) && launchConfiguration.getType().getIdentifier().equals(this.launchConfigurationType)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            CdtMigrationActivator.getInstance().logError("An error occurred while access to launch configuration.", e);
        }
        return false;
    }
}

