/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.conditions.toolchain;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationEntityAnnotation;
import com.nxp.s32ds.cle.runtime.migration.annotation.MigrationPropertyAnnotation;
import com.nxp.s32ds.cle.runtime.migration.condition.MigrationCondition;
import java.util.List;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;

@MigrationEntityAnnotation(name="Checks if specific toolchain is used in project.", description="Checks if specific toolchain is used in project.")
public class ToolchainIsUsedCondition
implements MigrationCondition {
    @MigrationPropertyAnnotation(name="toolchainIdPrefix", description="List of toolchain id prefix to be replaced.")
    private List<String> toolchainIdPrefixes;

    public boolean match(IProject project) {
        List configurations = ProjectConfigurationUtils.getProjectConfigurations((IProject)project);
        if (configurations.isEmpty()) {
            return false;
        }
        for (IConfiguration cfg : configurations) {
            IToolChain toolChain = cfg.getToolChain();
            String toolchainBaseId = toolChain.getBaseId();
            for (String toolchainIdPrefix : this.toolchainIdPrefixes) {
                if (!toolchainBaseId.startsWith(toolchainIdPrefix)) continue;
                return true;
            }
        }
        return false;
    }
}

