/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.entities.lc;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.cdt.migration.entities.lc.AbstractLaunchConfigurationMigrationEntity;
import com.nxp.s32ds.cle.ide.debugger.registry.core.DebuggerLaunchConfigurationDescriptors;
import com.nxp.s32ds.cle.ide.debugger.registry.descriptor.DebuggerLaunchConfigurationDescriptor;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class UpdateGdbClientPathMigrationEntity
extends AbstractLaunchConfigurationMigrationEntity {
    private static final String GDB_DEBUG_NAME_ATTR = "org.eclipse.cdt.dsf.gdb.DEBUG_NAME";
    private static final String CONFIG_ID_ATTR = "org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR";
    private static Map<String, String> oldGdbPathToNew = new HashMap<String, String>();

    static {
        oldGdbPathToNew.put("${S32DS_GDB_CLIENT_ARM32_EXECUTABLE_PATH}", "${S32DS_GDB_ARM32_PY}");
        oldGdbPathToNew.put("${S32DS_GDB_CLIENT_ARM64_EXECUTABLE_PATH}", "${S32DS_GDB_ARM64_PY}");
    }

    @Override
    protected IStatus migrateWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy, IProject project, String targetId) throws CoreException {
        String gdbClientValue = UpdateGdbClientPathMigrationEntity.resolveGdbPath(workingCopy, project);
        if (gdbClientValue.isEmpty()) {
            return Status.OK_STATUS;
        }
        workingCopy.setAttribute(GDB_DEBUG_NAME_ATTR, gdbClientValue);
        return Status.OK_STATUS;
    }

    @Override
    protected List<ILaunchConfiguration> getLaunchConfigurations(String projectName) throws CoreException {
        ILaunchConfiguration[] launchConfigurations;
        ArrayList<ILaunchConfiguration> configurations = new ArrayList<ILaunchConfiguration>();
        ILaunchConfiguration[] iLaunchConfigurationArray = launchConfigurations = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
        int n = launchConfigurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration launchConfiguration = iLaunchConfigurationArray[n2];
            if (launchConfiguration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "").equals(projectName)) {
                configurations.add(launchConfiguration);
            }
            ++n2;
        }
        return configurations;
    }

    private static String resolveGdbPath(ILaunchConfigurationWorkingCopy workingCopy, IProject project) throws CoreException {
        ProjectContextSettings projectContextSettings = new ProjectContextSettings(project);
        String deviceCoreId = projectContextSettings.getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        String configId = workingCopy.getAttribute(CONFIG_ID_ATTR, "");
        String toolchainId = UpdateGdbClientPathMigrationEntity.extractToolchainId(project, configId);
        String debuggerId = UpdateGdbClientPathMigrationEntity.extractDebuggerId(workingCopy.getType());
        if (deviceCoreId.isEmpty() || toolchainId.isEmpty() || debuggerId.isEmpty()) {
            return UpdateGdbClientPathMigrationEntity.resolveFromMap(workingCopy);
        }
        return LaunchConfigurationUtil.getGDBClientValue((String)deviceCoreId, (String)debuggerId, (String)toolchainId);
    }

    private static String extractToolchainId(IProject project, String configId) {
        IManagedBuildInfo buildInfo = ManagedBuildManager.getBuildInfo((IResource)project);
        IConfiguration[] configurations = buildInfo.getManagedProject().getConfigurations();
        return Arrays.stream(configurations).filter(cfg -> cfg.getId().equals(configId)).map(cfg -> cfg.getToolChain().getBaseId()).findFirst().orElse("");
    }

    private static String extractDebuggerId(ILaunchConfigurationType type) {
        String lcTypeId = type.getIdentifier();
        return DebuggerLaunchConfigurationDescriptors.getDebuggerLaunchConfigurationRegistry().getDebuggerLaunchConfigurationDescriptorsByLaunchId(lcTypeId).stream().map(DebuggerLaunchConfigurationDescriptor::getDebuggerId).findFirst().orElse("");
    }

    private static String resolveFromMap(ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        String gdbOldValue = workingCopy.getAttribute(GDB_DEBUG_NAME_ATTR, "");
        if (gdbOldValue.isEmpty()) {
            return gdbOldValue;
        }
        return oldGdbPathToNew.computeIfAbsent(gdbOldValue, k -> "");
    }

    @Override
    protected String getDebuggerId() {
        return "";
    }

    @Override
    protected String getConfigurationName() {
        return "";
    }
}

