/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.migration.entities.replace;

import com.nxp.s32ds.cle.cdt.internal.migration.CdtMigrationActivator;
import com.nxp.s32ds.cle.cdt.internal.migration.Messages;
import com.nxp.s32ds.cle.runtime.migration.entity.MigrationEntity;
import com.nxp.s32ds.ext.ide.refactoring.IdeSearchScope;
import com.nxp.s32ds.ext.ide.refactoring.text.IdeTextMatch;
import com.nxp.s32ds.ext.ide.refactoring.text.IdeTextRefactorings;
import com.nxp.s32ds.ext.ide.refactoring.text.IdeTextSearches;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;

public class IdeSearchReplaceMigrationEntity
implements MigrationEntity {
    private static final String PATHS_SEPARATOR = ";";

    public IStatus applicable(String sourceId, String targetId, Map<String, Object> attributes) {
        this.assertSourceId(sourceId);
        return Status.OK_STATUS;
    }

    public IStatus migrate(String sourceId, String targetId, Map<String, Object> attributes, IProgressMonitor monitor) {
        IProject project = (IProject)attributes.get("s32ds.migration.payload.attributes.project");
        try {
            URL url = new URL(sourceId);
            Properties properties = new Properties();
            Throwable throwable = null;
            Object var9_13 = null;
            try (InputStream stream = url.openStream();){
                properties.load(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return this.findAndReplace(project, properties.entrySet(), targetId, monitor);
        }
        catch (MalformedURLException e) {
            return CdtMigrationActivator.getInstance().createError(NLS.bind((String)Messages.CdtSearchReplaceMigrationEntity_malformed_source_url_0, (Object)sourceId), e);
        }
        catch (IOException e) {
            return CdtMigrationActivator.getInstance().createError(NLS.bind((String)Messages.CdtSearchReplaceMigrationEntity_cannot_read_source_url_content_0, (Object)sourceId), e);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    protected IStatus findAndReplace(IProject project, Set<Map.Entry<Object, Object>> entrySet, String targetId, IProgressMonitor monitor) throws CoreException {
        int size = entrySet.size();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)size).checkCanceled();
        String[] paths = targetId == null || targetId.isEmpty() ? new String[]{} : targetId.split(PATHS_SEPARATOR);
        ArrayList replacements = new ArrayList();
        for (Map.Entry<Object, Object> e : entrySet) {
            String searchString = (String)e.getKey();
            String replacementString = (String)e.getValue();
            List<IdeTextMatch> matches = this.find(project, searchString, paths, (IProgressMonitor)subMonitor.split(1));
            replacements.addAll(IdeTextRefactorings.toEdit(matches, m -> IdeTextRefactorings.toReplace((IdeTextMatch)m, (String)replacementString)));
        }
        subMonitor.done();
        return IdeTextRefactorings.performInteractive(replacements);
    }

    protected List<IdeTextMatch> find(IProject project, String searchString, String[] paths, IProgressMonitor monitor) throws CoreException {
        return IdeTextSearches.findWord((IProgressMonitor)monitor, (IProject)project, (IdeSearchScope)IdeSearchScope.singleProject(null, (String[])paths), (String)searchString);
    }
}

