/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.model.utils;

import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.TextSetting;
import com.nxp.swtools.common.uct.utils.CustomMap;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.time.TimeUnit;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.gtm.model.utils.GtmUtils;
import com.nxp.swtools.gtm.model.xml.settings.GtmTextSetting;
import com.nxp.swtools.utils.scripting.JavaScriptHelper;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class GtmExpressions {
    public static final Pattern GET_DEPENDENCY_EXPR_REGEX = Pattern.compile("(getValue|getValueOut)\\((.+?)\\)", 32);
    public static final Pattern GET_INPUT_RESOLUTION_EXPR_REGEX = Pattern.compile("(getInputResolution)\\((.*)\\)", 8);
    public static final Pattern NUMBER_REGEX = Pattern.compile(".*\\d.*");
    public static final Pattern GET_VALUE_EXPR_REGEX = Pattern.compile("((getValue)\\((.*)\\))(>>|<<|&|\\|)?(.*[0-9])?", 8);
    public static final Pattern GET_VALUE_SHORT_EXPR_REGEX = Pattern.compile("((getValue)\\(([^\\)]*)\\))", 8);
    public static final Pattern GET_CHANNEL_INFO = Pattern.compile("^([a-z]{1,4})(\\d{1,2})?.*?[^_0-9]*(\\d{1,2})");
    public static final String MATH_OPERATIONS_REGEX = "[-+*/\\[\\]]";
    public static final String GET_FUNCTION_PARTIAL_REGEX = "\\s*\\(\\s*([^)]+)\\s*\\)";
    private static final Logger LOGGER = LogManager.getLogger(GtmExpressions.class);
    private static ScriptEngine scriptEngine = JavaScriptHelper.createJavascriptEngine();

    public static long getLongValueFromExpression(IGtmMcu selectedMcu, String expression) {
        long value;
        block16: {
            ABaseUIComponentSetting componentSetting;
            block17: {
                String componentId;
                value = 0L;
                Matcher valueMatcher = GET_VALUE_EXPR_REGEX.matcher(expression);
                if (!valueMatcher.find() || valueMatcher.groupCount() != 5 || (componentId = valueMatcher.group(3)) == null || (componentSetting = GtmUtils.getUIComponentSettingById(selectedMcu, componentId)) == null) break block16;
                String operator = valueMatcher.group(4);
                String rightOperand = valueMatcher.group(5);
                if (operator == null || rightOperand == null) break block17;
                switch (operator) {
                    case ">>": {
                        value = componentSetting.getValueToWrite() >> (int)Long.decode(rightOperand).longValue();
                        break;
                    }
                    case "<<": {
                        value = componentSetting.getValueToWrite() << (int)Long.decode(rightOperand).longValue();
                        break;
                    }
                    case "&": {
                        value = componentSetting.getValueToWrite() & Long.decode(rightOperand);
                        break;
                    }
                    case "|": {
                        value = componentSetting.getValueToWrite() | Long.decode(rightOperand);
                        break;
                    }
                    default: {
                        value = componentSetting.getValueToWrite();
                        break;
                    }
                }
                break block16;
            }
            value = componentSetting.getValueToWrite();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getConstraintValueFromExpression(IGtmMcu selectedMcu, String valueExpr) {
        ScriptEngine scriptEngine = GtmExpressions.scriptEngine;
        synchronized (scriptEngine) {
            long value = 0L;
            Matcher valueMatcher = GET_VALUE_EXPR_REGEX.matcher(valueExpr);
            if (valueMatcher.find() && valueMatcher.groupCount() > 0) {
                return GtmExpressions.getLongValueFromExpression(selectedMcu, valueExpr);
            }
            try {
                String valueResult = String.valueOf(GtmExpressions.scriptEngine.eval(valueExpr));
                if (NumberFormatValidator.isValidDecimal((String)valueResult)) {
                    value = Long.parseLong(valueResult);
                }
            }
            catch (NumberFormatException | ScriptException e) {
                LOGGER.log(Level.SEVERE, e.getMessage());
            }
            return value;
        }
    }

    public static double getDoubleValueFromExpression(IGtmMcu selectedMcu, String expression) {
        String componentId;
        double value = 0.0;
        Matcher valueMatcher = GET_VALUE_EXPR_REGEX.matcher(expression);
        if (valueMatcher.find() && valueMatcher.groupCount() >= 3 && (componentId = valueMatcher.group(3)) != null) {
            ABaseUIComponentSetting componentSetting = GtmUtils.getUIComponentSettingById(selectedMcu, componentId);
            if (componentSetting instanceof TextSetting) {
                if (NumberFormatValidator.isValidHexadecimal((String)componentSetting.getCurrentValue())) {
                    value = Long.decode(componentSetting.getCurrentValue()).doubleValue();
                } else if (!componentSetting.getCurrentValue().isEmpty()) {
                    value = Double.parseDouble(componentSetting.getCurrentValue());
                }
            } else if (componentSetting != null) {
                value = Long.decode(String.valueOf(componentSetting.getValueToWrite())).doubleValue();
            }
        }
        return value;
    }

    @Deprecated
    public static String getStringValueFromExpression(IGtmMcu selectedMcu, ABaseUIComponentSetting componentSetting) {
        String valueInStringFormat = "0";
        String expression = componentSetting.getValueExpression();
        String[] expressionComponents = expression.split(MATH_OPERATIONS_REGEX);
        CustomMap expressionComponentsValues = new CustomMap();
        DecimalFormat numberFormat = new DecimalFormat("#.00");
        double currentValue = 0.0;
        int i = 0;
        while (i < expressionComponents.length) {
            block20: {
                String expressionComponent;
                block21: {
                    block22: {
                        expressionComponent = expressionComponents[i];
                        if (expressionComponent.isEmpty() || NumberFormatValidator.isValidNumerical((String)expressionComponent)) break block20;
                        Matcher valueMatcher = GET_INPUT_RESOLUTION_EXPR_REGEX.matcher(expressionComponent);
                        if (!valueMatcher.find() || valueMatcher.groupCount() != 2) break block21;
                        String parameterId = valueMatcher.group(2);
                        if (parameterId == null) break block22;
                        switch (parameterId) {
                            case "gtm_input_frequency": {
                                currentValue = GtmUtils.getGtmInputClockFreq();
                                break;
                            }
                            case "gtm_input_period": {
                                currentValue = UctUtils.getFreqToTimeConversion((double)GtmUtils.getGtmInputClockFreq(), (TimeUnit)TimeUnit.NANO_SECOND);
                                break;
                            }
                            default: {
                                currentValue = 0.0;
                            }
                        }
                    }
                    expressionComponentsValues.put((Object)expressionComponent, (Object)currentValue);
                    break block20;
                }
                currentValue = componentSetting.isDisabled() || !componentSetting.isVisible() ? 0.0 : GtmExpressions.getDoubleValueFromExpression(selectedMcu, expressionComponent);
                expressionComponentsValues.put((Object)expressionComponent, (Object)currentValue);
            }
            ++i;
        }
        if (expressionComponents.length > 1) {
            String numericalExpression = expression;
            for (Map.Entry expressionComponentVal : expressionComponentsValues.entrySet()) {
                numericalExpression = numericalExpression.replace((CharSequence)expressionComponentVal.getKey(), Double.toString((Double)expressionComponentVal.getValue()));
            }
            ScriptEngineManager mgr = new ScriptEngineManager();
            ScriptEngine engine = mgr.getEngineByName("JavaScript");
            if (engine != null) {
                try {
                    currentValue = Double.parseDouble(engine.eval(numericalExpression).toString());
                    if (currentValue == Double.POSITIVE_INFINITY || currentValue == Double.NEGATIVE_INFINITY) {
                        currentValue = 0.0;
                    }
                }
                catch (ArithmeticException | NumberFormatException | ScriptException e) {
                    currentValue = 0.0;
                    LOGGER.log(Level.SEVERE, e.getMessage());
                }
            }
        }
        componentSetting.setCurrentValue(UtilsText.safeString((String)numberFormat.format(currentValue)));
        if (componentSetting.getId().contains("frequency")) {
            valueInStringFormat = UctUtils.getFreqAutoScaleConversion((double)Double.parseDouble(componentSetting.getCurrentValue()));
        } else if (componentSetting.getId().contains("period")) {
            valueInStringFormat = UctUtils.getPeriodAutoScaleConversion((double)Double.parseDouble(componentSetting.getCurrentValue()));
        }
        return valueInStringFormat;
    }

    private static String resolveGetValueExpr(IGtmMcu selectedMcu, String componentId) {
        ABaseUIComponentSetting refComponentSetting = GtmUtils.getUIComponentSettingById(selectedMcu, componentId);
        if (refComponentSetting instanceof TextSetting) {
            if (NumberFormatValidator.isValidHexadecimal((String)refComponentSetting.getCurrentValue())) {
                return Long.decode(refComponentSetting.getCurrentValue()).toString();
            }
            if (!refComponentSetting.getCurrentValue().isEmpty()) {
                return refComponentSetting.getCurrentValue();
            }
        } else if (refComponentSetting != null) {
            return Long.decode(String.valueOf(refComponentSetting.getValueToWrite())).toString();
        }
        return "0";
    }

    private static String resolveGetValueOutExpr(IGtmMcu selectedMcu, String componentId) {
        ABaseUIComponentSetting refComponentSetting = GtmUtils.getUIComponentSettingById(selectedMcu, componentId);
        if (refComponentSetting instanceof GtmTextSetting) {
            GtmTextSetting refGtmComponentSetting = (GtmTextSetting)refComponentSetting;
            if (NumberFormatValidator.isValidHexadecimal((String)refGtmComponentSetting.getCurrentValueOut())) {
                return Long.decode(refGtmComponentSetting.getCurrentValueOut()).toString();
            }
            if (!refGtmComponentSetting.getCurrentValueOut().isEmpty()) {
                return refGtmComponentSetting.getCurrentValueOut();
            }
        }
        return "0";
    }

    private static String resolveGetInputResolutionExpr(String resolutionParamType) {
        String valueInStringFormat;
        double currentValue;
        block10: {
            currentValue = 0.0;
            if (resolutionParamType.isBlank()) break block10;
            switch (resolutionParamType) {
                case "gtm_input_frequency": {
                    currentValue = GtmUtils.getGtmInputClockFreq();
                    break;
                }
                case "gtm_input_period": {
                    currentValue = UctUtils.getFreqToTimeConversion((double)GtmUtils.getGtmInputClockFreq(), (TimeUnit)TimeUnit.NANO_SECOND);
                    break;
                }
                default: {
                    currentValue = 0.0;
                }
            }
        }
        return (valueInStringFormat = Double.toString(currentValue)) != null ? valueInStringFormat : "0";
    }

    public static String processFunctions(IGtmMcu selectedMcu, String expression) {
        HashMap<String, Object> parseExpressionFunctions = new HashMap<String, Object>();
        parseExpressionFunctions.put("getValue", GtmExpressions::resolveGetValueExpr);
        parseExpressionFunctions.put("getInputResolution", GtmExpressions::resolveGetInputResolutionExpr);
        parseExpressionFunctions.put("getValueOut", GtmExpressions::resolveGetValueOutExpr);
        for (Map.Entry expressionFunction : parseExpressionFunctions.entrySet()) {
            Pattern pattern = Pattern.compile(String.valueOf((String)expressionFunction.getKey()) + GET_FUNCTION_PARTIAL_REGEX);
            Matcher matcher = pattern.matcher(expression);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                String componentId = matcher.group(1);
                Object fn = expressionFunction.getValue();
                if (componentId == null) continue;
                if (fn instanceof UnaryOperator) {
                    UnaryOperator function = (UnaryOperator)fn;
                    matcher.appendReplacement(sb, (String)function.apply(componentId));
                    continue;
                }
                if (!(fn instanceof BiFunction)) continue;
                BiFunction biFunction = (BiFunction)fn;
                matcher.appendReplacement(sb, (String)biFunction.apply(selectedMcu, componentId));
            }
            matcher.appendTail(sb);
            expression = sb.toString();
        }
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getDoubleExpressionResult(IGtmMcu selectedMcu, String expression) {
        ScriptEngine scriptEngine = GtmExpressions.scriptEngine;
        synchronized (scriptEngine) {
            double expressionValue = 0.0;
            if (!expression.isBlank()) {
                String numericalExpression = GtmExpressions.processFunctions(selectedMcu, expression);
                try {
                    Object resultObject = GtmExpressions.scriptEngine.eval(numericalExpression);
                    if (resultObject != null && ((expressionValue = Double.parseDouble(resultObject.toString())) == Double.POSITIVE_INFINITY || expressionValue == Double.NEGATIVE_INFINITY || Double.isNaN(expressionValue))) {
                        expressionValue = 0.0;
                    }
                }
                catch (ArithmeticException | NumberFormatException | ScriptException e) {
                    expressionValue = 0.0;
                    LOGGER.log(Level.SEVERE, e.getMessage());
                }
            }
            return expressionValue;
        }
    }

    public static String evaluateValueExpr(IGtmMcu selectedMcu, GtmTextSetting componentSetting) {
        String valueInStringFormat = "0";
        double currentValue = 0.0;
        DecimalFormat numberFormat = new DecimalFormat("#.00");
        String expression = componentSetting.getValueExpression();
        if (!componentSetting.isDisabled() && componentSetting.isVisible()) {
            currentValue = GtmExpressions.getDoubleExpressionResult(selectedMcu, expression);
        }
        componentSetting.setCurrentValue(UtilsText.safeString((String)numberFormat.format(currentValue)));
        if (componentSetting.getId().contains("frequency")) {
            valueInStringFormat = UctUtils.getFreqAutoScaleConversion((double)currentValue);
        } else if (componentSetting.getId().contains("period")) {
            valueInStringFormat = UctUtils.getPeriodAutoScaleConversion((double)currentValue);
        }
        return valueInStringFormat;
    }

    public static String evaluateValueExprOut(IGtmMcu selectedMcu, GtmTextSetting componentSetting) {
        String valueInStringFormat = "0";
        double currentValue = 0.0;
        DecimalFormat numberFormat = new DecimalFormat("#.00");
        String expression = componentSetting.getValueExpressionOut();
        if (!componentSetting.isDisabled() && componentSetting.isVisible()) {
            currentValue = GtmExpressions.getDoubleExpressionResult(selectedMcu, expression);
        }
        componentSetting.setCurrentValueOut(UtilsText.safeString((String)numberFormat.format(currentValue)));
        if (componentSetting.getId().contains("frequency")) {
            valueInStringFormat = UctUtils.getFreqAutoScaleConversion((double)currentValue);
        } else if (componentSetting.getId().contains("period")) {
            valueInStringFormat = UctUtils.getPeriodAutoScaleConversion((double)currentValue);
        }
        return valueInStringFormat;
    }

    public static boolean hasGtmInputResolutionInExpression(IGtmMcu selectedMcu, ABaseUIComponentSetting componentSetting) {
        String expression = componentSetting.getValueExpression();
        String[] expressionComponents = expression.split(MATH_OPERATIONS_REGEX);
        int i = 0;
        while (i < expressionComponents.length) {
            String parameterId;
            Matcher valueMatcher;
            String expressionComponent = expressionComponents[i];
            if (!expressionComponent.isEmpty() && !NumberFormatValidator.isValidNumerical((String)expressionComponent) && (valueMatcher = GET_INPUT_RESOLUTION_EXPR_REGEX.matcher(expressionComponent)).find() && valueMatcher.groupCount() == 2 && (parameterId = valueMatcher.group(2)) != null && (parameterId.equals("gtm_input_frequency") || parameterId.equals("gtm_input_period"))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static ArrayList<String> getDependenciesFromExpression(String expression) {
        ArrayList<String> dependencyTags = new ArrayList<String>();
        Matcher matcher = GET_DEPENDENCY_EXPR_REGEX.matcher(expression);
        while (matcher.find()) {
            String matchedDependency = matcher.group(2);
            if (matchedDependency == null) continue;
            dependencyTags.add(matchedDependency);
        }
        return dependencyTags;
    }
}

