/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.lang.internal.registry;

import com.nxp.s32ds.cle.runtime.lang.registry.HardwareLangDescriptor;
import com.nxp.s32ds.cle.runtime.lang.registry.LangDescriptor;
import com.nxp.s32ds.cle.runtime.lang.registry.LangRegistry;
import com.nxp.s32ds.ext.rcp.registry.BaseRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;

@Component
public class LangRegistryImplementation
extends BaseRegistry
implements LangRegistry {
    private final Map<String, LangDescriptor> langDescriptors = new HashMap<String, LangDescriptor>();
    private final Map<String, HardwareLangDescriptor> hardwareLangDescriptors = new HashMap<String, HardwareLangDescriptor>();

    @Override
    public List<LangDescriptor> getLangDescriptors() {
        return new ArrayList<LangDescriptor>(this.langDescriptors.values());
    }

    @Override
    public LangDescriptor getLangDescriptor(String id) {
        return this.langDescriptors.get(id);
    }

    @Override
    public void addLangDescriptor(LangDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        this.addEntityDescriptor(descriptor, this.langDescriptors, LangDescriptor.class);
    }

    @Override
    public void removeLangDescriptor(LangDescriptor descriptor) {
        this.removeEntityDescriptor(descriptor, this.langDescriptors, LangDescriptor.class);
    }

    @Override
    public List<HardwareLangDescriptor> getHardwareLangDescriptors() {
        return new ArrayList<HardwareLangDescriptor>(this.hardwareLangDescriptors.values());
    }

    @Override
    public HardwareLangDescriptor getHardwareLangDescriptorByLangId(String langId) {
        return this.hardwareLangDescriptors.values().stream().filter(descriptor -> descriptor.getLangId().equals(langId)).findFirst().orElse(null);
    }

    @Override
    public void addHardwareLangDescriptor(HardwareLangDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        this.addEntityDescriptor(descriptor, this.hardwareLangDescriptors, HardwareLangDescriptor.class);
    }

    @Override
    public void removeHardwareLangDescriptor(HardwareLangDescriptor descriptor) {
        this.removeEntityDescriptor(descriptor, this.hardwareLangDescriptors, HardwareLangDescriptor.class);
    }
}

