/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.internal.ui.wizards.examples;

import com.nxp.s32ds.cle.ide.example.core.ExampleProjectFacade;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.ExamplesActivator;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.ExamplesViewer;
import com.nxp.s32ds.cle.ide.internal.ui.wizards.examples.Messages;
import com.nxp.s32ds.ext.ide.core.refactoring.ProjectSet;
import com.nxp.s32ds.ext.ide.examples.core.IExampleComponent;
import com.nxp.s32ds.ext.ide.examples.core.ValidationExampleUtil;
import com.nxp.s32ds.ext.rcp.databinding.ValidationDescriptors;
import com.nxp.s32ds.ext.rcp.databinding.validation.CompositeValidator;
import java.io.File;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

public class ExamplesSelectionPage
extends WizardPage {
    private static final String HELP_CONTEXT_ID = ".import_example_project_context";
    private final ExampleProjectFacade projectFacade;
    private ExamplesViewer exmViewer;
    private ProjectSet projectSet = null;
    private String name = "";
    private Object pathToValidate;
    private boolean isFolder = false;
    private final CompositeValidator compositeNameValidator = new CompositeValidator(ValidationDescriptors.getValidatorDescriptorByGroupId((String)"project.name.validators"));
    private final CompositeValidator compositePathValidatior = new CompositeValidator(ValidationDescriptors.getValidatorDescriptorByGroupId((String)"project.path.validators"));

    public boolean isFolder() {
        return this.isFolder;
    }

    protected ExamplesSelectionPage(ExampleProjectFacade projectFacade) {
        super("Select project");
        this.projectFacade = projectFacade;
    }

    public void createControl(Composite parent) {
        this.setTitle(Messages.Wizard_page_title);
        this.exmViewer = new ExamplesViewer(parent, this.projectFacade){

            @Override
            protected void projectSelected(ProjectSet project) {
                ExamplesSelectionPage.this.projectSet = project;
                this.updateStatus();
            }

            private boolean updateStatus() {
                ExamplesSelectionPage.this.isFolder = ExamplesSelectionPage.this.exmViewer.isFolderSelected();
                IStatus status = ExamplesSelectionPage.this.validate();
                ExamplesSelectionPage.this.setPageComplete(status.isOK());
                ExamplesSelectionPage.this.setErrorMessage(status.isOK() || status.getSeverity() == 8 ? null : status.getMessage());
                return status.isOK();
            }

            @Override
            protected void nameChanged(String name) {
                ExamplesSelectionPage.this.name = name;
                if (ExamplesSelectionPage.this.projectSet != null) {
                    if (ExamplesSelectionPage.this.projectSet.getProjects().count() == 1L) {
                        ExamplesSelectionPage.this.pathToValidate = name;
                        this.updateStatus();
                    } else {
                        for (IProjectDescription description : ExamplesSelectionPage.this.projectSet.getProjects().collect(Collectors.toList())) {
                            ExamplesSelectionPage.this.pathToValidate = ValidationExampleUtil.calculateExamplePath((IPath)new Path(String.valueOf(ExamplesSelectionPage.this.projectSet.getName()) + File.separator + description.getName()), (String)ExamplesSelectionPage.this.projectSet.getName(), (String)name);
                            if (!this.updateStatus()) break;
                        }
                    }
                }
            }

            @Override
            protected void folderSelected() {
                this.updateStatus();
            }
        };
        this.setControl(this.exmViewer.getControl());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.exmViewer.getControl(), String.valueOf(ExamplesActivator.getInstance().getBundleId()) + HELP_CONTEXT_ID);
        this.setPageComplete(false);
    }

    public void dispose() {
        this.getControl().dispose();
        super.dispose();
    }

    public ProjectSet getProjectSet() {
        return this.projectSet;
    }

    public String getName() {
        return this.name;
    }

    public IStatus validate() {
        if (this.isFolder()) {
            return ExamplesActivator.getInstance().createError(Messages.Folder_selection_message);
        }
        if (this.getProjectSet() == null) {
            return ValidationStatus.ok();
        }
        IStatus nameStatus = this.compositeNameValidator.validate(this.getName());
        if (!nameStatus.isOK()) {
            return nameStatus;
        }
        java.nio.file.Path resolvedPath = Paths.get(ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString(), new String[0]).resolve(this.getName());
        IStatus status = this.compositePathValidatior.validate(resolvedPath.toString());
        if (!status.isOK()) {
            return status;
        }
        if (this.getProjectSet().getProjects().count() > 1L) {
            for (IProjectDescription project : this.getProjectSet().getProjects().collect(Collectors.toList())) {
                String nameToCheck = project.getName().startsWith(this.getProjectSet().getName()) ? project.getName().replaceFirst(this.getProjectSet().getName(), this.getName()) : project.getName();
                status = this.compositeNameValidator.validate(nameToCheck);
                if (status.isOK()) {
                    status = this.compositePathValidatior.validate(resolvedPath.resolve(nameToCheck).toString());
                }
                if (status.isOK()) continue;
                return status;
            }
        }
        return Status.OK_STATUS;
    }

    public Object getPathToValidate() {
        return this.pathToValidate;
    }

    public IExampleComponent getExampleComponent() {
        return this.exmViewer.getExampleComponent();
    }
}

