/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.ui.navigator;

import com.nxp.s32ds.cle.cdt.sdk.ui.internal.navigator.SdkUiNavigatorActivator;
import com.nxp.s32ds.cle.cdt.sdk.ui.navigator.SdkExplorerContentSorter;
import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeEvent;
import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeListener;
import com.nxp.s32ds.cle.ide.core.listener.ComponentListenerManager;
import com.nxp.s32ds.ext.ide.ui.navigator.FilteredNavigator;
import com.nxp.s32ds.ext.ide.ui.selection.SelectionUtils;
import java.io.File;
import java.net.URI;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IEnumeration;
import org.eclipse.cdt.core.model.IEnumerator;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.IMacro;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.IStructureDeclaration;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;

public class SdkExplorer
extends FilteredNavigator
implements ComponentChangeListener {
    private String projectName;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        ComponentListenerManager.INSTANCE.addListener((ComponentChangeListener)this);
        this.getCommonViewer().setComparator((ViewerComparator)new SdkExplorerContentSorter());
        this.getCommonViewer().addDoubleClickListener((IDoubleClickListener)new SDKExplorerDoubleClickListener());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getCommonViewer());
    }

    public void dispose() {
        ComponentListenerManager.INSTANCE.removeListener((ComponentChangeListener)this);
        super.dispose();
    }

    protected void initListeners(TreeViewer viewer) {
        super.initListeners(viewer);
        ISelectionService service = this.getSite().getWorkbenchWindow().getSelectionService();
        service.addSelectionListener((wbPart, selection) -> {
            if (wbPart.getClass() != ((Object)((Object)this)).getClass()) {
                IProject selectedProject;
                if (viewer.getControl() == null || viewer.getControl().isDisposed()) {
                    return;
                }
                if (selection == null || selection.isEmpty()) {
                    this.cleanupExplorerData(viewer);
                    return;
                }
                if (this.projectName != null) {
                    this.addExpandedElements("_" + this.projectName + "_");
                }
                if ((selectedProject = SdkExplorer.resolveProjectSelection(selection)) == null || !selectedProject.isAccessible()) {
                    this.cleanupExplorerData(viewer);
                    return;
                }
                if (selectedProject.getName().equals(this.projectName)) {
                    return;
                }
                this.projectName = selectedProject.getName();
                viewer.setInput((Object)CoreModel.getDefault().create(selectedProject));
                this.setExpandedElements("_" + this.projectName + "_");
            }
        });
    }

    public static IProject resolveProjectSelection(ISelection selection) {
        IProject project = null;
        Object selectedObject = SelectionUtils.getObjectFromSelection((ISelection)selection);
        if (selectedObject instanceof IAdaptable) {
            Object obj = ((IAdaptable)selectedObject).getAdapter(selectedObject.getClass());
            if (obj instanceof ICElement) {
                project = ((ICElement)obj).getCProject().getProject();
            } else if (obj instanceof IResource) {
                project = ((IResource)obj).getProject();
            } else {
                obj = ((IAdaptable)selectedObject).getAdapter(ICProject.class);
                if (obj instanceof ICProject) {
                    project = ((ICProject)obj).getProject();
                }
            }
        }
        return project;
    }

    public void onComponentChange(ComponentChangeEvent event) {
        this.getCommonViewer().refresh();
    }

    private void cleanupExplorerData(TreeViewer viewer) {
        this.projectName = null;
        viewer.setInput(null);
    }

    class SDKExplorerDoubleClickListener
    implements IDoubleClickListener {
        SDKExplorerDoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            Object data = ((IStructuredSelection)SdkExplorer.this.getCommonViewer().getSelection()).getFirstElement();
            try {
                int offset = 0;
                String fname = null;
                ITextEditor textEditor = null;
                if (data instanceof ITranslationUnit) {
                    ITranslationUnit translationUnit = ((ISourceReference)data).getTranslationUnit();
                    fname = translationUnit.getElementName();
                    textEditor = this.getTextEditor(translationUnit);
                } else {
                    ISourceReference sRef = null;
                    if (data instanceof ISourceReference) {
                        sRef = (ISourceReference)data;
                        if (data instanceof IFunctionDeclaration) {
                            fname = ((IFunctionDeclaration)data).getElementName();
                        } else if (data instanceof IMacro) {
                            fname = ((IMacro)data).getElementName();
                        } else if (data instanceof IStructureDeclaration) {
                            fname = ((IStructureDeclaration)data).getElementName();
                        } else if (data instanceof IEnumeration) {
                            fname = ((IEnumeration)data).getElementName();
                        } else if (data instanceof IEnumerator) {
                            fname = ((IEnumerator)data).getElementName();
                        } else if (data instanceof INamespace) {
                            fname = ((INamespace)data).getElementName();
                        }
                        if (fname != null) {
                            String source = sRef.getSource();
                            ISourceRange sr = sRef.getSourceRange();
                            offset = source != null ? sr.getStartPos() + source.indexOf(fname) : 0;
                            textEditor = this.getTextEditor(sRef.getTranslationUnit());
                        }
                    }
                }
                if (textEditor != null) {
                    textEditor.selectAndReveal(offset, fname.length());
                }
            }
            catch (Exception e) {
                SdkUiNavigatorActivator.getInstance().logError("", e);
            }
        }

        protected ITextEditor getTextEditor(ITranslationUnit tu) throws PartInitException {
            URI uri = URI.create(tu.getElementName());
            if (!new File(uri).exists()) {
                Display display = Display.getDefault();
                Shell activeShell = display.getActiveShell();
                display.syncExec(() -> MessageDialog.openError((Shell)activeShell, (String)"File not found", (String)String.format("File %s not found", new Path(uri.getPath()).toOSString())));
                return null;
            }
            IFileStore fileStore = EFS.getLocalFileSystem().getStore(tu.getLocationURI());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            return (ITextEditor)IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
        }
    }
}

