/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.version.VersionUtils;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.core.service.scriptapi.db.IRegParentPeripheralAPI;
import com.nxp.swtools.core.service.scriptapi.db.IRegistersDatabaseAPI;
import com.nxp.swtools.expert.processordb.IConfigComponentInfo;
import com.nxp.swtools.expert.processordb.IProcessorMasterToolInfo;
import com.nxp.swtools.expert.processordb.ISupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.SupportedDerivativesForSwTools;
import com.nxp.swtools.expert.processordb.sdkcomponents.SdkComponentsTable;
import com.nxp.swtools.expert.processordb.sdkcomponents.SupportedSdkComponent;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.periphs.model.data.AvailableComponentsRefResolver;
import com.nxp.swtools.periphs.model.data.ComponentKey;
import com.nxp.swtools.periphs.model.data.Components;
import com.nxp.swtools.periphs.model.data.ComponentsProvider;
import com.nxp.swtools.periphs.model.data.ComputeScoreWrapper;
import com.nxp.swtools.periphs.model.data.ProcessorRestrictions;
import com.nxp.swtools.periphs.model.resources.AProcessorFilterForPeripherals;
import com.nxp.swtools.periphs.model.templates.component.ComponentTemplate;
import com.nxp.swtools.periphs.model.templates.component.ComponentTemplateProperties;
import com.nxp.swtools.provider.configuration.storage.periphs.StoragePeriphsComponent;
import com.nxp.swtools.resourcetables.model.data.Category;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.IActiveContextRefResolver;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.MasterPeripheral;
import com.nxp.swtools.resourcetables.model.data.MigrationComponent;
import com.nxp.swtools.resourcetables.model.data.Migrations;
import com.nxp.swtools.resourcetables.model.data.SWComponent;
import com.nxp.swtools.utils.profiler.Profiler;
import java.io.File;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.osgi.framework.Version;

public class AvailableComponents
extends Components {
    private static final Logger LOGGER = LogManager.getLogger(AvailableComponents.class);
    private IMcuIdentification mcu;
    private Map<String, Map<String, ComponentTemplateProperties>> componentTemplateProperties;
    private static final String COMMON_COMPONENTS_FOLDER_NAME = "common";

    public AvailableComponents(IMcuIdentification mcu, @Nullable IRegistersDatabaseAPI registersDb, AProcessorFilterForPeripherals toolFilter) {
        this(mcu, registersDb, null, null, toolFilter);
    }

    public AvailableComponents(IMcuIdentification mcu, @Nullable IRegistersDatabaseAPI registersDb, @Nullable IActiveContextRefResolver refResolver, @Nullable String componentDirectory, AProcessorFilterForPeripherals toolFilter) {
        super(new ArrayList<ConfigurationComponentTypeId>());
        this.mcu = mcu;
        Collection<ConfigurationComponentTypeId> collection = this.confCompTypeIds = UtilsText.isEmpty((String)componentDirectory) ? this.loadConfigComps(registersDb, toolFilter) : AvailableComponents.loadConfigComps(mcu, UtilsText.safeString((String)componentDirectory), registersDb);
        if (SWToolsProperties.isPropertyTrue((String)"com.nxp.swtools.periph.components.loading.new")) {
            this.componentTypeIdsMap = UtilsText.isEmpty((String)componentDirectory) ? this.loadConfigCompsNewMechanism(registersDb, toolFilter) : AvailableComponents.loadConfigCompsNewMechanism(mcu, UtilsText.safeString((String)componentDirectory), registersDb);
        }
        this.componentTemplateProperties = this.loadTemplateProperties(ComponentTemplate.getComponentTemplatesFolder());
        if (refResolver == null) {
            BigInteger index = Profiler.getInstance((Object)"Peripherals").start(AvailableComponents.class, (Object)"Resolving references in components");
            new AvailableComponentsRefResolver(this).resolve();
            Profiler.getInstance((Object)"Peripherals").stop(index, AvailableComponents.class, null);
        } else {
            refResolver.setCaller((Object)this);
            refResolver.resolve();
        }
    }

    public static Collection<ConfigurationComponentTypeId> loadConfigComps(IMcuIdentification mcu, String componentsDir, @Nullable IRegistersDatabaseAPI registersDb) {
        Profiler profilerInstance = Profiler.getInstance((Object)"Peripherals");
        BigInteger index = profilerInstance.start(AvailableComponents.class, (Object)"Load component info files");
        Collection<IConfigComponentInfo> componentsInfo = ComponentsProvider.getComponentsInfo(componentsDir, mcu.getSdkVersion());
        profilerInstance.stop(index, AvailableComponents.class, null);
        Map<String, Set<ComputeScoreWrapper>> sdkComponentsVersionWrappers = AvailableComponents.prepareMapOfSupportedSDKComponents(mcu, componentsInfo);
        index = profilerInstance.start(AvailableComponents.class, (Object)"Filter component infos");
        AvailableComponents.filterComponentsInfo(componentsInfo, mcu);
        profilerInstance.stop(index, AvailableComponents.class, null);
        index = profilerInstance.start(AvailableComponents.class, (Object)"Load component files");
        Collection<ConfigurationComponentTypeId> result = ComponentsProvider.getComponents(componentsInfo);
        profilerInstance.stop(index, AvailableComponents.class, null);
        if (SWToolsProperties.isVerificationOn()) {
            AvailableComponents.checkAndLogUnusablePeripherals(result, registersDb);
            AvailableComponents.logPeripheralsWithoutAlias(registersDb);
        }
        index = profilerInstance.start(AvailableComponents.class, (Object)"Filter components");
        AvailableComponents.filterComponents(result, registersDb, mcu);
        Set<Supplier<@Nullable String>> unsupportedSDKComponentsMessages = AvailableComponents.getMessagesForUnsupportedSDKComponents(sdkComponentsVersionWrappers, result);
        AvailableComponents.printUnsupportedSDKComponents(unsupportedSDKComponentsMessages);
        profilerInstance.stop(index, AvailableComponents.class, null);
        return result;
    }

    public static CollectionMap<ComponentKey, ConfigurationComponentTypeId> loadConfigCompsNewMechanism(IMcuIdentification mcu, String componentsDir, @Nullable IRegistersDatabaseAPI registersDb) {
        Profiler profilerInstance = Profiler.getInstance((Object)"Peripherals");
        BigInteger index = profilerInstance.start(AvailableComponents.class, (Object)"Load component info files");
        Collection<IConfigComponentInfo> componentsInfo = ComponentsProvider.getComponentsInfo(componentsDir, mcu.getSdkVersion());
        profilerInstance.stop(index, AvailableComponents.class, null);
        Map<String, Set<ComputeScoreWrapper>> sdkComponentsVersionWrappers = AvailableComponents.prepareMapOfSupportedSDKComponents(mcu, componentsInfo);
        index = profilerInstance.start(AvailableComponents.class, (Object)"Filter component infos");
        AvailableComponents.filterComponentsInfo(componentsInfo, mcu);
        profilerInstance.stop(index, AvailableComponents.class, null);
        index = profilerInstance.start(AvailableComponents.class, (Object)"Load component files");
        CollectionMap<ComponentKey, ConfigurationComponentTypeId> result = ComponentsProvider.getComponentsNewMechanism(componentsInfo);
        profilerInstance.stop(index, AvailableComponents.class, null);
        if (SWToolsProperties.isVerificationOn()) {
            AvailableComponents.logPeripheralsWithoutAlias(registersDb);
        }
        index = profilerInstance.start(AvailableComponents.class, (Object)"Filter components");
        AvailableComponents.filterComponentsNewMechanism(result, registersDb, mcu);
        Set<Supplier<@Nullable String>> unsupportedSDKComponentsMessages = AvailableComponents.getMessagesForUnsupportedSDKComponentsNewMechanism(sdkComponentsVersionWrappers, result);
        AvailableComponents.printUnsupportedSDKComponents(unsupportedSDKComponentsMessages);
        profilerInstance.stop(index, AvailableComponents.class, null);
        return result;
    }

    private static void printUnsupportedSDKComponents(Set<Supplier<@Nullable String>> messages) {
        messages.forEach(m -> LOGGER.log(Level.WARNING, (Supplier<String>)m));
    }

    protected static Set<Supplier<@Nullable String>> getMessagesForUnsupportedSDKComponents(Map<String, Set<ComputeScoreWrapper>> supportedSDKComponentsVersionWrappers, Collection<ConfigurationComponentTypeId> components) {
        if (!AvailableComponents.shouldCheckPresenceOfNewerSDKComponents()) {
            return Collections.emptySet();
        }
        Map<String, Version> lowestConfiguredVersions = AvailableComponents.getLowestConfiguredSdkComponentVersion(components);
        AvailableComponents.removeConfiguredVersionOfSdkComponent(supportedSDKComponentsVersionWrappers, components);
        AvailableComponents.skipSdkComponentsLowerThanLowestConfigured(supportedSDKComponentsVersionWrappers, lowestConfiguredVersions);
        return AvailableComponents.getNotConfiguredSdkComponentMessagesToBeLogged(supportedSDKComponentsVersionWrappers);
    }

    protected static Set<Supplier<@Nullable String>> getMessagesForUnsupportedSDKComponentsNewMechanism(Map<String, Set<ComputeScoreWrapper>> supportedSDKComponentsVersionWrappers, CollectionMap<ComponentKey, ConfigurationComponentTypeId> components) {
        if (!AvailableComponents.shouldCheckPresenceOfNewerSDKComponents()) {
            return Collections.emptySet();
        }
        Map<String, Version> lowestConfiguredVersions = AvailableComponents.getLowestConfiguredSdkComponentVersionNewMechanism(components);
        AvailableComponents.removeConfiguredVersionOfSdkComponentNewMechanism(supportedSDKComponentsVersionWrappers, components);
        AvailableComponents.skipSdkComponentsLowerThanLowestConfigured(supportedSDKComponentsVersionWrappers, lowestConfiguredVersions);
        return AvailableComponents.getNotConfiguredSdkComponentMessagesToBeLogged(supportedSDKComponentsVersionWrappers);
    }

    private static void removeConfiguredVersionOfSdkComponent(Map<String, Set<ComputeScoreWrapper>> supportedSDKComponentsVersionWrappers, Collection<ConfigurationComponentTypeId> components) {
        for (ConfigurationComponentTypeId component : components) {
            for (SWComponent swComponent : component.getComponentReferences()) {
                Set<ComputeScoreWrapper> supportedVersionWrappers = supportedSDKComponentsVersionWrappers.get(swComponent.getName());
                if (supportedVersionWrappers == null || supportedVersionWrappers.isEmpty()) continue;
                Iterator<ComputeScoreWrapper> supportedVersionsIterator = supportedVersionWrappers.iterator();
                while (supportedVersionsIterator.hasNext()) {
                    BigInteger score = AvailableComponents.computeMatchScore(ComputeScoreWrapper.from(swComponent), supportedVersionsIterator.next(), swComponent.getMatchString(), swComponent.getUntilVersion());
                    if (score == null) continue;
                    supportedVersionsIterator.remove();
                }
            }
        }
    }

    private static void removeConfiguredVersionOfSdkComponentNewMechanism(Map<String, Set<ComputeScoreWrapper>> supportedSDKComponentsVersionWrappers, CollectionMap<ComponentKey, ConfigurationComponentTypeId> components) {
        for (ConfigurationComponentTypeId component : (List)components.values().stream().flatMap(x -> x.stream()).collect(CollectorsUtils.toList())) {
            for (SWComponent swComponent : component.getComponentReferences()) {
                Set<ComputeScoreWrapper> supportedVersionWrappers = supportedSDKComponentsVersionWrappers.get(swComponent.getName());
                if (supportedVersionWrappers == null || supportedVersionWrappers.isEmpty()) continue;
                Iterator<ComputeScoreWrapper> supportedVersionsIterator = supportedVersionWrappers.iterator();
                while (supportedVersionsIterator.hasNext()) {
                    BigInteger score = AvailableComponents.computeMatchScore(ComputeScoreWrapper.from(swComponent), supportedVersionsIterator.next(), swComponent.getMatchString(), swComponent.getUntilVersion());
                    if (score == null) continue;
                    supportedVersionsIterator.remove();
                }
            }
        }
    }

    private static Set<Supplier<@Nullable String>> getNotConfiguredSdkComponentMessagesToBeLogged(Map<String, Set<ComputeScoreWrapper>> supportedSDKComponentsVersionWrappers) {
        HashSet<Supplier<@Nullable String>> messages = new HashSet<Supplier<String>>();
        for (Map.Entry<String, Set<ComputeScoreWrapper>> entry : supportedSDKComponentsVersionWrappers.entrySet()) {
            Set<ComputeScoreWrapper> unsupportedVersions = entry.getValue();
            if (unsupportedVersions.isEmpty()) continue;
            messages.add(() -> MessageFormat.format("[DATA] SDK component {0} is supported, but versions {1} are not configured by any Peripherals tool component", entry.getKey(), "[" + UtilsText.join((Collection)unsupportedVersions, (String)", ") + "]"));
        }
        return messages;
    }

    private static void skipSdkComponentsLowerThanLowestConfigured(Map<String, Set<ComputeScoreWrapper>> supportedSDKComponentsVersionWrappers, Map<String, Version> lowestConfiguredVersions) {
        for (Map.Entry<String, Version> entry : lowestConfiguredVersions.entrySet()) {
            String sdkComponentName = entry.getKey();
            Version lowestVersion = entry.getValue();
            Set<ComputeScoreWrapper> wrappers = supportedSDKComponentsVersionWrappers.get(sdkComponentName);
            if (wrappers == null || wrappers.isEmpty()) continue;
            Iterator<ComputeScoreWrapper> wrappersIterator = wrappers.iterator();
            while (wrappersIterator.hasNext()) {
                boolean shouldSkip;
                ComputeScoreWrapper wrapper = wrappersIterator.next();
                boolean bl = shouldSkip = VersionUtils.compare((Version)lowestVersion, (Version)wrapper.getVersion()) > 0;
                if (!shouldSkip) continue;
                wrappersIterator.remove();
            }
        }
    }

    private static Map<String, Version> getLowestConfiguredSdkComponentVersion(Collection<ConfigurationComponentTypeId> components) {
        HashMap<String, Version> lowestConfiguredVersions = new HashMap<String, Version>();
        for (ConfigurationComponentTypeId component : components) {
            Map<String, List<SWComponent>> sdkComponentsWithVersions = component.getComponentReferences().stream().collect(Collectors.groupingBy(x -> x.getName()));
            for (Map.Entry<String, List<SWComponent>> entry : sdkComponentsWithVersions.entrySet()) {
                Version version = (Version)CollectionsUtils.nullableOptionalGet(entry.getValue().stream().sorted((ref1, ref2) -> VersionUtils.compare((Version)ref1.getVersion(), (Version)ref2.getVersion())).map(ref -> ref.getVersion()).findFirst());
                if (version == null) continue;
                lowestConfiguredVersions.put(entry.getKey(), version);
            }
        }
        return lowestConfiguredVersions;
    }

    private static Map<String, Version> getLowestConfiguredSdkComponentVersionNewMechanism(CollectionMap<ComponentKey, ConfigurationComponentTypeId> components) {
        HashMap<String, Version> lowestConfiguredVersions = new HashMap<String, Version>();
        for (ConfigurationComponentTypeId component : (List)components.values().stream().flatMap(x -> x.stream()).collect(CollectorsUtils.toList())) {
            Map<String, List<SWComponent>> sdkComponentsWithVersions = component.getComponentReferences().stream().collect(Collectors.groupingBy(x -> x.getName()));
            for (Map.Entry<String, List<SWComponent>> entry : sdkComponentsWithVersions.entrySet()) {
                Version version = (Version)CollectionsUtils.nullableOptionalGet(entry.getValue().stream().sorted((ref1, ref2) -> VersionUtils.compare((Version)ref1.getVersion(), (Version)ref2.getVersion())).map(ref -> ref.getVersion()).findFirst());
                if (version == null) continue;
                lowestConfiguredVersions.put(entry.getKey(), version);
            }
        }
        return lowestConfiguredVersions;
    }

    protected static Map<String, Set<ComputeScoreWrapper>> prepareMapOfSupportedSDKComponents(IMcuIdentification mcu, Collection<IConfigComponentInfo> componentInfos) {
        if (!AvailableComponents.shouldCheckPresenceOfNewerSDKComponents()) {
            return Collections.emptyMap();
        }
        SdkComponentsTable supportedComps = AvailableComponents.getSdkComponentsTable(mcu);
        if (supportedComps == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<ComputeScoreWrapper>> unsupportedSDKComponentsVersionWrappers = new HashMap<String, Set<ComputeScoreWrapper>>();
        componentInfos.stream().flatMap(info -> info.getReferences().stream()).map(ref -> ref.getDriverName()).forEach(sdkDriverName -> {
            HashSet hashSet = unsupportedSDKComponentsVersionWrappers.put((String)sdkDriverName, new HashSet());
        });
        Iterator unsupportedSDKComponentsVersionWrappersIterator = unsupportedSDKComponentsVersionWrappers.entrySet().iterator();
        while (unsupportedSDKComponentsVersionWrappersIterator.hasNext()) {
            Map.Entry entry = unsupportedSDKComponentsVersionWrappersIterator.next();
            String sdkComponentId = (String)entry.getKey();
            Set versionWrappersSet = (Set)entry.getValue();
            Set versionWrappers = (Set)supportedComps.findById(sdkComponentId).map(sdk -> ComputeScoreWrapper.from(sdk)).collect(CollectorsUtils.toSet());
            if (versionWrappers.isEmpty()) {
                unsupportedSDKComponentsVersionWrappersIterator.remove();
                continue;
            }
            versionWrappersSet.addAll(versionWrappers);
        }
        return unsupportedSDKComponentsVersionWrappers;
    }

    private static boolean shouldCheckPresenceOfNewerSDKComponents() {
        return SWToolsProperties.isVerificationOn();
    }

    protected Collection<ConfigurationComponentTypeId> loadConfigComps(@Nullable IRegistersDatabaseAPI registersDb, AProcessorFilterForPeripherals toolFilter) {
        if (!toolFilter.isPeripheralsComponentsDirDefined(this.mcu)) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe(MessageFormat.format("[DATA] Configuration components directory is not specified for selected part {0} and SDK {1}", this.mcu.getPackage(), this.mcu.getSdkVersion()));
            }
            return CollectionsUtils.emptyList();
        }
        String componentsDir = toolFilter.getPeripheralsComponentsDir(this.mcu);
        Collection<ConfigurationComponentTypeId> components = AvailableComponents.loadConfigComps(this.mcu, componentsDir, registersDb);
        String commonComponentsDir = AvailableComponents.getCommonComponentsFolder(componentsDir);
        if (commonComponentsDir != null) {
            components.addAll(AvailableComponents.loadConfigComps(this.mcu, commonComponentsDir, registersDb));
        }
        return components;
    }

    protected CollectionMap<ComponentKey, ConfigurationComponentTypeId> loadConfigCompsNewMechanism(@Nullable IRegistersDatabaseAPI registersDb, AProcessorFilterForPeripherals toolFilter) {
        if (!toolFilter.isPeripheralsComponentsDirDefined(this.mcu)) {
            if (SWToolsProperties.isVerificationOn()) {
                LOGGER.severe(MessageFormat.format("[DATA] Configuration components directory is not specified for selected part {0} and SDK {1}", this.mcu.getPackage(), this.mcu.getSdkVersion()));
            }
            return new CollectionMap();
        }
        String componentsDir = toolFilter.getPeripheralsComponentsDir(this.mcu);
        return AvailableComponents.loadConfigCompsNewMechanism(this.mcu, componentsDir, registersDb);
    }

    private static boolean isPeripheralSupported(String peripheralType, IRegistersDatabaseAPI registersDb) {
        IRegParentPeripheralAPI[] peripherals;
        IRegParentPeripheralAPI[] iRegParentPeripheralAPIArray = peripherals = registersDb.getPeripherals();
        int n = peripherals.length;
        int n2 = 0;
        while (n2 < n) {
            IRegParentPeripheralAPI peripheral = iRegParentPeripheralAPIArray[n2];
            if (peripheralType.equals(peripheral.getAlias("type"))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public @Nullable ConfigurationComponentTypeId getBestMatchingConfigCompTypeId(StoragePeriphsComponent storage) {
        List<ConfigurationComponentTypeId> configComps = this.getConfigCompTypeIds(storage);
        if (configComps == null || configComps.isEmpty()) {
            return null;
        }
        if (configComps.size() == 1) {
            return configComps.get(0);
        }
        return this.getBestMatchingConfigCompType(configComps);
    }

    public @Nullable ConfigurationComponentTypeId getBestMatchingConfigCompType(List<ConfigurationComponentTypeId> configComps) {
        SdkComponentsTable supportedComps = AvailableComponents.getSdkComponentsTable(this.mcu);
        if (supportedComps == null) {
            return null;
        }
        if (!configComps.isEmpty()) {
            BigInteger bestMatchScore = null;
            ConfigurationComponentTypeId bestMatch = null;
            for (ConfigurationComponentTypeId comp : configComps) {
                BigInteger matchScore = AvailableComponents.computeMatchScore(comp, supportedComps);
                if (matchScore == null || bestMatchScore != null && matchScore.compareTo(bestMatchScore) <= 0) continue;
                bestMatch = comp;
                bestMatchScore = matchScore;
            }
            if (bestMatch != null) {
                return bestMatch;
            }
        }
        return null;
    }

    public static void filterComponentsInfo(Collection<IConfigComponentInfo> componentsInfo, IMcuIdentification mcu) {
        componentsInfo.removeIf(c -> {
            ProcessorRestrictions processorRestrictions = AvailableComponents.loadProcessorRestrictions(c);
            if (processorRestrictions != null) {
                return !processorRestrictions.isAllowed(mcu.getPackage());
            }
            return false;
        });
        SdkComponentsTable supportedComps = AvailableComponents.getSdkComponentsTable(mcu);
        if (supportedComps == null) {
            return;
        }
        componentsInfo.retainAll(componentsInfo.stream().filter(x -> x.getReferences().stream().allMatch(r -> supportedComps.getSupportedSdkComponents().stream().anyMatch(c -> {
            SWComponent swComp;
            if (!r.isDriverRequired()) {
                return true;
            }
            String requiredDriverId = r.getDriverName();
            if (!c.getId().equals(requiredDriverId)) {
                return false;
            }
            SWComponent.Match matchByName = SWComponent.Match.getMatchByName((String)r.getDriverMatch());
            if (matchByName == null) {
                matchByName = SWComponent.Match.EQUIVALENT;
            }
            return AvailableComponents.computeMatchScore(swComp = new SWComponent(requiredDriverId, new Version(r.getDriverVersion()), matchByName, null, r.isDriverRequired(), UtilsText.join((Collection)r.getRevisions(), (String)",")), c) != null;
        }))).collect(Collectors.toList()));
    }

    private static void filterComponents(Collection<ConfigurationComponentTypeId> configComps, @Nullable IRegistersDatabaseAPI registersDb, IMcuIdentification mcu) {
        configComps.retainAll(configComps.stream().filter(x -> x.getConfigurationComponent().isGlobalOnly() || x.getConfigurationComponent().getScenarios().stream().map(y -> y.getMasterPeripheral()).filter(mp -> mp == null || mp.getPeripherals().stream().filter(z -> z.equals("*") || registersDb != null && AvailableComponents.isPeripheralSupported(z, Objects.requireNonNull(registersDb, "Registers DB should exist when definition of peripheral " + z + " is found in component file (master_peripheral element): " + x.getFileLocation().toString()))).count() > 0L).count() > 0L).collect(Collectors.toSet()));
        HashSet<ConfigurationComponentTypeId> componentsToRetain = new HashSet<ConfigurationComponentTypeId>();
        HashSet<ConfigurationComponentTypeId> componentsToDiscard = new HashSet<ConfigurationComponentTypeId>();
        SdkComponentsTable supportedComps = AvailableComponents.getSdkComponentsTable(mcu);
        Map<String, List<ConfigurationComponentTypeId>> componentsByType = configComps.stream().collect(Collectors.groupingBy(c -> c.getConfigurationComponent().getId()));
        for (Map.Entry<String, List<ConfigurationComponentTypeId>> entry : componentsByType.entrySet()) {
            List<ConfigurationComponentTypeId> comps = entry.getValue();
            if (comps.isEmpty()) continue;
            if (supportedComps == null) {
                for (ConfigurationComponentTypeId comp : comps) {
                    if (!comp.getComponentReferences().isEmpty()) {
                        componentsToDiscard.add(comp);
                        continue;
                    }
                    componentsToRetain.add(comp);
                }
                continue;
            }
            for (ConfigurationComponentTypeId comp : comps) {
                BigInteger matchScore = AvailableComponents.computeMatchScore(comp, supportedComps);
                if (matchScore != null) {
                    componentsToRetain.add(comp);
                    continue;
                }
                componentsToDiscard.add(comp);
            }
        }
        if (!componentsToDiscard.isEmpty() && SWToolsProperties.isVerificationOn() && supportedComps != null) {
            AvailableComponents.checkAndLogUnsupportedDriverVersions(componentsToDiscard, supportedComps);
        }
        configComps.retainAll(componentsToRetain);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static void filterComponentsNewMechanism(CollectionMap<ComponentKey, ConfigurationComponentTypeId> map, @Nullable IRegistersDatabaseAPI registersDb, IMcuIdentification mcu) {
        CollectionMap toBeRemoved = new CollectionMap();
        for (Map.Entry entry : map.entrySet()) {
            for (ConfigurationComponentTypeId componentTypeId : (Collection)entry.getValue()) {
                IConfigurationComponent configurationComponent = componentTypeId.getConfigurationComponent();
                if (configurationComponent.isGlobalOnly()) continue;
                @Nullable List masterPeripherals = (List)configurationComponent.getScenarios().stream().map(x -> x.getMasterPeripheral()).collect(CollectorsUtils.toList());
                boolean anyPeripheralSupported = false;
                boolean hasAnyMasterPeripheral = false;
                for (MasterPeripheral masterPeripheral : masterPeripherals) {
                    if (masterPeripheral == null) continue;
                    hasAnyMasterPeripheral = true;
                    Predicate<String> isUniversalPeripheral = peripheral -> peripheral.equals("*");
                    Predicate<String> isPeripheralSupported = peripheral -> AvailableComponents.isPeripheralSupported(peripheral, Objects.requireNonNull(registersDb, "Registers DB should exist when definition of peripheral " + peripheral + " is found in component file (master_peripheral element): " + componentTypeId.getFileLocation().toString()));
                    anyPeripheralSupported |= masterPeripheral.getPeripherals().stream().anyMatch(isUniversalPeripheral.or(isPeripheralSupported));
                }
                if (!hasAnyMasterPeripheral || anyPeripheralSupported) continue;
                toBeRemoved.addAll(ComponentsProvider.getAllComponentEntries(componentTypeId));
            }
        }
        map.removeAllItems(toBeRemoved);
        toBeRemoved.clear();
        SdkComponentsTable supportedComps = AvailableComponents.getSdkComponentsTable(mcu);
        List typeKeys = (List)map.keySet().stream().filter(x -> x.getType() == ComponentKey.KeyType.TYPE).collect(CollectorsUtils.toList());
        for (Map.Entry entry : map.entrySet()) {
            Collection comps;
            if (!typeKeys.contains(entry.getKey()) || (comps = (Collection)entry.getValue()).isEmpty()) continue;
            for (ConfigurationComponentTypeId comp : comps) {
                if (supportedComps == null) {
                    if (comp.getComponentReferences().isEmpty()) continue;
                    toBeRemoved.addAll(ComponentsProvider.getAllComponentEntries(comp));
                    continue;
                }
                BigInteger matchScore = AvailableComponents.computeMatchScore(comp, supportedComps);
                if (matchScore != null) continue;
                toBeRemoved.addAll(ComponentsProvider.getAllComponentEntries(comp));
            }
        }
        map.removeAllItems(toBeRemoved);
    }

    private static void checkAndLogUnusablePeripherals(Collection<ConfigurationComponentTypeId> comps, @Nullable IRegistersDatabaseAPI registersDb) {
        Set usablePeripherals = comps.stream().flatMap(x -> x.getConfigurationComponent().getScenarios().stream()).map(x -> x.getMasterPeripheral()).filter(Objects::nonNull).flatMap(x -> {
            assert (x != null);
            return x.getPeripherals().stream();
        }).collect(Collectors.toSet());
        HashSet<@Nullable String> unusablePeripherals = new HashSet<String>();
        if (registersDb != null) {
            IRegParentPeripheralAPI[] iRegParentPeripheralAPIArray = registersDb.getPeripherals();
            int n = iRegParentPeripheralAPIArray.length;
            int n2 = 0;
            while (n2 < n) {
                IRegParentPeripheralAPI peripheral = iRegParentPeripheralAPIArray[n2];
                String peripheralType = peripheral.getAlias("type");
                if (!usablePeripherals.contains(peripheralType)) {
                    unusablePeripherals.add(peripheralType);
                }
                ++n2;
            }
        }
    }

    private static void checkAndLogUnsupportedDriverVersions(Collection<ConfigurationComponentTypeId> comps, SdkComponentsTable sdkComponents) {
        for (ConfigurationComponentTypeId comp : comps) {
            boolean allDriversFound = true;
            for (SWComponent swComponent : comp.getConfigurationComponent().getComponents()) {
                boolean bl = allDriversFound = allDriversFound && sdkComponents.findById(swComponent.getName()).count() > 0L;
            }
            if (!allDriversFound) continue;
            LOGGER.log(Level.WARNING, "[DATA] Configuration component \"{0}\" cannot be used due to driver version(s) mismatch", comp.getTypeId());
            break;
        }
    }

    private static void logPeripheralsWithoutAlias(@Nullable IRegistersDatabaseAPI registersDb) {
        if (registersDb != null) {
            Arrays.stream(registersDb.getPeripherals()).filter(p -> p.getAlias("type") == null).forEach(p -> LOGGER.log(Level.SEVERE, MessageFormat.format("[DATA] Peripheral \"{0}\" has no alias of type \"{1}\" in register db", p.getName(), "type")));
        }
    }

    public List<IConfigurationComponent> getConfigCompsByType(String type) {
        if (SWToolsProperties.isPropertyTrue((String)"com.nxp.swtools.periph.components.loading.new")) {
            List<ConfigurationComponentTypeId> list = this.getComponentsFromNewMap(ComponentKey.type(type));
            if (list.isEmpty()) {
                return Collections.emptyList();
            }
            return (List)list.stream().map(x -> x.getConfigurationComponent()).collect(CollectorsUtils.toList());
        }
        return this.confCompTypeIds.stream().map(y -> y.getConfigurationComponent()).filter(x -> x.getId().equals(type)).collect(Collectors.toList());
    }

    public List<ConfigurationComponentTypeId> getConfigCompsTypeIdsForCategory(String categoryId) {
        if (SWToolsProperties.isPropertyTrue((String)"com.nxp.swtools.periph.components.loading.new")) {
            return this.getComponentsFromNewMap(ComponentKey.category(categoryId));
        }
        return (List)this.getConfigCompTypeIds().stream().filter(componentTypeId -> categoryId.equals(componentTypeId.getConfigurationComponent().getCategory())).collect(CollectorsUtils.toList());
    }

    public List<ConfigurationComponentTypeId> getConfigCompsTypeIdsWithoutMatchingCategory(Collection<Category> categories) {
        if (SWToolsProperties.isPropertyTrue((String)"com.nxp.swtools.periph.components.loading.new")) {
            return this.getComponentsFromNewMap(ComponentKey.category(""));
        }
        return (List)this.getConfigCompTypeIds().stream().filter(configCompTypeId -> categories.stream().noneMatch(cat -> cat.getId().equals(configCompTypeId.getConfigurationComponent().getCategory()))).filter(configCompTypeId -> !configCompTypeId.getConfigurationComponent().isAutoAdding()).filter(configCompTypeId -> !configCompTypeId.isHidden()).filter(configCompTypeId -> !configCompTypeId.getConfigurationComponent().isGlobalOnly()).collect(CollectorsUtils.toList());
    }

    public @Nullable List<ConfigurationComponentTypeId> getConfigCompTypeIds(StoragePeriphsComponent storage) {
        ArrayList<ConfigurationComponentTypeId> result = new ArrayList<ConfigurationComponentTypeId>();
        ConfigurationComponentTypeId configCompTypeId = this.getConfigCompTypeId(storage.getTypeId());
        if (configCompTypeId == null) {
            List<ConfigurationComponentTypeId> matchingComponents = this.getComponentTypeIdsByType(storage.getName());
            if (matchingComponents != null) {
                result.addAll(matchingComponents);
                LOGGER.log(Level.INFO, () -> MessageFormat.format("[DATA] Component with type_id \"{0}\" is not available. Using components with type \"{1}\"", storage.getTypeId(), storage.getName()));
            } else {
                LOGGER.log(Level.SEVERE, () -> MessageFormat.format("[DATA] Component \"{0}\" not found.", storage.getName()));
            }
        } else {
            result.add(configCompTypeId);
        }
        return result;
    }

    public @Nullable List<ConfigurationComponentTypeId> getComponentTypeIdsByType(String type) {
        if (SWToolsProperties.isPropertyTrue((String)"com.nxp.swtools.periph.components.loading.new")) {
            Collection collection = this.componentTypeIdsMap.get((Object)ComponentKey.type(type));
            if (collection == null) {
                return null;
            }
            return new ArrayList<ConfigurationComponentTypeId>(collection);
        }
        List<ConfigurationComponentTypeId> matchingComponents = this.confCompTypeIds.stream().filter(x -> x.getType().equals(type)).collect(Collectors.toList());
        if (matchingComponents.isEmpty()) {
            return null;
        }
        return matchingComponents;
    }

    private List<ConfigurationComponentTypeId> getComponentsFromNewMap(ComponentKey key) {
        Collection collection = this.componentTypeIdsMap.get((Object)key);
        if (collection == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ConfigurationComponentTypeId>(collection);
    }

    public String getSdkComponentName(String sdkId) {
        ISupportedDerivativesForSwTools derivatives = SupportedDerivativesForSwTools.getSupportedDerivativesForSwTools();
        IProcessorMasterToolInfo info = derivatives.getProcessorMasterToolInfo(this.mcu.getMcu(), this.mcu.getSdkVersion());
        if (info == null) {
            return sdkId;
        }
        SdkComponentsTable supportedComps = derivatives.getSdkComponentsTable(info);
        if (supportedComps == null) {
            return sdkId;
        }
        for (SupportedSdkComponent comp : supportedComps.getSupportedSdkComponents()) {
            if (!comp.getId().equals(sdkId)) continue;
            return comp.getName();
        }
        return sdkId;
    }

    public String getSdkVersion() {
        return this.mcu.getSdkVersion();
    }

    public IMcuIdentification getMcu() {
        return this.mcu;
    }

    private static @Nullable ProcessorRestrictions loadProcessorRestrictions(IConfigComponentInfo componentInfo) {
        File @Nullable [] files = componentInfo.getComponentDir().listFiles((dir, name) -> name != null && name.endsWith(".restrictions"));
        if (files == null || files.length == 0) {
            return null;
        }
        File source = files[0];
        if (files.length > 1) {
            LOGGER.warning(() -> MessageFormat.format("[DATA] There are more restriction files in the \"{0}\" component folder, using the \"{1}\"", componentInfo.getName(), source.getAbsolutePath()));
        }
        return ProcessorRestrictions.loadFromFile(source);
    }

    public List<ConfigurationComponentTypeId> getReplacementsForTypeId(String typeId) {
        ConfigurationComponentTypeId originalComponent = this.getConfigCompTypeId(typeId);
        if (originalComponent == null) {
            LOGGER.log(Level.WARNING, "[DATA] Component with typeId \"{0}\" cannot be found", typeId);
            return new ArrayList<ConfigurationComponentTypeId>();
        }
        ArrayList<ConfigurationComponentTypeId> components = new ArrayList<ConfigurationComponentTypeId>(this.getConfigCompTypeIds());
        ArrayList<ConfigurationComponentTypeId> componentsToRemove = new ArrayList<ConfigurationComponentTypeId>();
        ConfigurationComponentTypeId self = (ConfigurationComponentTypeId)CollectionsUtils.nullableOptionalGet(components.stream().filter(comp -> comp.getTypeId().equals(typeId)).findAny());
        if (self != null) {
            components.remove(self);
        }
        for (ConfigurationComponentTypeId comp2 : components) {
            Migrations migrations = comp2.getConfigurationComponent().getMigrations();
            if (migrations == null) {
                componentsToRemove.add(comp2);
                continue;
            }
            Predicate<MigrationComponent> componentTypeMatchesPredicate = migrationComponent -> migrationComponent.getComponentType().equals(originalComponent.getType());
            Predicate<MigrationComponent> componentVariantMatches = migrationComponent -> migrationComponent.getVariant().equals(originalComponent.getConfigurationComponent().getVariant());
            List migrationComponents = (List)migrations.getMigrationComponents().stream().filter(componentTypeMatchesPredicate.and(componentVariantMatches)).collect(CollectorsUtils.toList());
            if (migrationComponents.isEmpty()) {
                componentsToRemove.add(comp2);
            }
            AvailableComponents.checkForCompatibleDrivers(componentsToRemove, comp2, originalComponent, migrationComponents);
        }
        components.removeAll(componentsToRemove);
        return components;
    }

    private static void checkForCompatibleDrivers(ArrayList<ConfigurationComponentTypeId> componentsToRemove, ConfigurationComponentTypeId componentToCheck, ConfigurationComponentTypeId currentComponent, List<MigrationComponent> migrationComponents) {
        ArrayList<ConfigurationComponentTypeId> usableComponents = new ArrayList<ConfigurationComponentTypeId>();
        List originalComponentSwCompRefs = currentComponent.getComponentReferences();
        for (MigrationComponent migrationComponent : migrationComponents) {
            List migrationSwCompRefs = migrationComponent.getSwCompRefs();
            for (SWComponent originalComponentSwComp : originalComponentSwCompRefs) {
                Version currentReferenceVersion = originalComponentSwComp.getVersion();
                if (currentReferenceVersion == null) continue;
                for (SWComponent migrationSwComp : migrationSwCompRefs) {
                    Version requiredVersion = migrationSwComp.getVersion();
                    BigInteger matchScore = AvailableComponents.computeMatchScore(requiredVersion, currentReferenceVersion, migrationSwComp.getMatchString(), null);
                    if (matchScore == null) {
                        componentsToRemove.add(componentToCheck);
                        continue;
                    }
                    usableComponents.add(componentToCheck);
                }
                if (!componentToCheck.getType().equals(currentComponent.getType())) continue;
                AvailableComponents.checkForDowngrade(componentsToRemove, componentToCheck, originalComponentSwComp);
            }
        }
        componentsToRemove.removeAll(usableComponents);
    }

    private static void checkForDowngrade(ArrayList<ConfigurationComponentTypeId> componentsToRemove, ConfigurationComponentTypeId componentToCheck, SWComponent currentVersionSwCompRef) {
        Version currentReferenceVersion = currentVersionSwCompRef.getVersion();
        List componentToCheckComponentReferences = componentToCheck.getComponentReferences();
        for (SWComponent componentToCheckRef : componentToCheckComponentReferences) {
            boolean isSameVesrion;
            BigInteger difference;
            Version componentToCheckDriverVersion;
            if (!componentToCheckRef.getName().equals(currentVersionSwCompRef.getName()) || (componentToCheckDriverVersion = componentToCheckRef.getVersion()) == null || (difference = AvailableComponents.computeMatchScore(currentReferenceVersion, componentToCheckDriverVersion, SWComponent.Match.COMPATIBLE.toString(), null)) == null) continue;
            boolean isDowngrade = difference.compareTo(MULTIPLY_FACTOR_VERSION_HIGHER_THAN_REQUIRED.negate()) <= 0;
            boolean bl = isSameVesrion = difference.intValue() == 0;
            if (!isDowngrade && !isSameVesrion) continue;
            componentsToRemove.add(componentToCheck);
        }
    }

    public Map<String, Map<String, ComponentTemplateProperties>> getComponentTemplatesProperties() {
        return CollectionsUtils.unmodifiableMap(this.componentTemplateProperties);
    }

    public Map<String, ComponentTemplateProperties> getComponentTemplatesPropertiesByTypeId(String typeId) {
        Map mapOfTypeId = this.componentTemplateProperties.computeIfAbsent(typeId, key -> new HashMap());
        assert (mapOfTypeId != null);
        return mapOfTypeId;
    }

    public boolean componentHasTemplates(ConfigurationComponentTypeId component) {
        return !this.getComponentTemplatesPropertiesByTypeId(component.getTypeId()).isEmpty();
    }

    public void addTemplateProperties(ComponentTemplateProperties properties) {
        Map mapOfType = this.componentTemplateProperties.computeIfAbsent(properties.getTypeId(), x -> new HashMap());
        assert (mapOfType != null);
        mapOfType.put(properties.getName(), properties);
    }

    public void removeTemplateProperties(ComponentTemplateProperties properties) {
        Map mapOfType = this.componentTemplateProperties.computeIfAbsent(properties.getTypeId(), x -> new HashMap());
        assert (mapOfType != null);
        mapOfType.remove(properties.getName(), properties);
        if (mapOfType.isEmpty()) {
            this.componentTemplateProperties.remove(properties.getTypeId(), mapOfType);
        }
    }

    public boolean templateExists(String nameWithTypeId) {
        return this.componentTemplateProperties.containsKey(nameWithTypeId);
    }

    private Map<String, Map<String, ComponentTemplateProperties>> loadTemplateProperties(String templatesFolderPath) {
        Map<String, Map<String, ComponentTemplateProperties>> allProperties = AvailableComponents.loadAllTemplateProperties(templatesFolderPath);
        HashSet<String> typeIdsToRemove = new HashSet<String>();
        for (Map.Entry<String, Map<String, ComponentTemplateProperties>> entry : allProperties.entrySet()) {
            String typeId = entry.getKey();
            boolean componentIsAvailable = this.confCompTypeIds.stream().anyMatch(x -> x.getTypeId().equals(typeId));
            if (componentIsAvailable) continue;
            typeIdsToRemove.add(entry.getKey());
        }
        allProperties.keySet().removeAll(typeIdsToRemove);
        return allProperties;
    }

    public static Map<String, Map<String, ComponentTemplateProperties>> loadAllTemplateProperties(String templatesFolderPath) {
        HashMap<String, Map<String, ComponentTemplateProperties>> propertiesMap = new HashMap<String, Map<String, ComponentTemplateProperties>>();
        File templatesFolder = new File(templatesFolderPath);
        if (!templatesFolder.exists()) {
            return propertiesMap;
        }
        if (templatesFolder.isFile()) {
            return propertiesMap;
        }
        File[] templateFoldersArray = templatesFolder.listFiles();
        if (templateFoldersArray == null) {
            return propertiesMap;
        }
        File[] fileArray = templateFoldersArray;
        int n = templateFoldersArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentTemplateProperties properties;
            File propertiesFile;
            File templateFolder = fileArray[n2];
            if (!templateFolder.isFile() && (propertiesFile = new File(templateFolder, "usecase.properties")).exists() && (properties = ComponentTemplateProperties.loadFromFile(propertiesFile)) != null) {
                Map mapOfSameTypeId = propertiesMap.computeIfAbsent(properties.getTypeId(), key -> new HashMap());
                assert (mapOfSameTypeId != null);
                mapOfSameTypeId.put(properties.getName(), properties);
            }
            ++n2;
        }
        return propertiesMap;
    }

    private static @Nullable String getCommonComponentsFolder(String componentsDir) {
        File f = new File(componentsDir);
        if (f.exists()) {
            File commonCompsFile = new File(String.valueOf(f.getParent()) + File.separator + COMMON_COMPONENTS_FOLDER_NAME);
            if (commonCompsFile.exists()) {
                return commonCompsFile.getAbsolutePath();
            }
            return null;
        }
        return null;
    }

    @Override
    public void dispose() {
        this.componentTemplateProperties.clear();
        super.dispose();
    }
}

