/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.model.data;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionMap;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.expert.processordb.ComponentInfo;
import com.nxp.swtools.expert.processordb.IConfigComponentInfo;
import com.nxp.swtools.periphs.model.data.ComponentKey;
import com.nxp.swtools.periphs.model.data.ConfigurationComponent;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.IConfigurationComponent;
import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ComponentsProvider {
    public static final String CATEGORY_ID_NO_CATEGORY = "";
    public static final String COMPONENT_EXTENSION = "component";
    private static final Logger LOGGER = LogManager.getLogger(ComponentsProvider.class);

    private ComponentsProvider() {
    }

    public static Collection<IConfigComponentInfo> getComponentsInfo(String componentsDir, String sdkVersion) {
        ArrayList<ComponentInfo> configurationComponentTypeIds = new ArrayList<ComponentInfo>();
        List components = UtilsFile.findFilesByExtension((String)componentsDir, (String)COMPONENT_EXTENSION, (int)2);
        for (String file : components) {
            File componentFile = new File(file);
            File fullNameFolder = new File(file).getParentFile();
            if (fullNameFolder == null) {
                LOGGER.severe(() -> MessageFormat.format("[TOOL] Can't find full folder name for component: {0}", componentFile.getAbsolutePath()));
                continue;
            }
            ComponentInfo info = new ComponentInfo(UtilsText.safeString((String)fullNameFolder.getName()), sdkVersion, sdkVersion, fullNameFolder);
            Path path = componentFile.toPath();
            assert (path != null);
            configurationComponentTypeIds.add(info);
        }
        return new ArrayList<IConfigComponentInfo>(configurationComponentTypeIds);
    }

    public static Collection<ConfigurationComponentTypeId> getComponents(Collection<IConfigComponentInfo> componentsInfo) {
        ArrayList<ConfigurationComponentTypeId> result = new ArrayList<ConfigurationComponentTypeId>();
        for (IConfigComponentInfo info : componentsInfo) {
            try {
                ConfigurationComponentTypeId component = ComponentsProvider.loadComponent(info);
                if (component == null) continue;
                result.add(component);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, MessageFormat.format("[TOOL] [{0}] Coomponent cannot be loaded due to following exception: {1}", info.getComponentDir(), e.getLocalizedMessage()));
            }
        }
        return result;
    }

    public static CollectionMap<ComponentKey, ConfigurationComponentTypeId> getComponentsNewMechanism(Collection<IConfigComponentInfo> componentsInfo) {
        CollectionMap result = new CollectionMap();
        for (IConfigComponentInfo info : componentsInfo) {
            try {
                result.addAll(ComponentsProvider.loadComponentNewMechanism(info));
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, MessageFormat.format("[TOOL] [{0}] Coomponent cannot be loaded due to following exception: {1}", info.getComponentDir(), e.getLocalizedMessage()));
            }
        }
        return result;
    }

    private static @Nullable ConfigurationComponentTypeId loadComponent(IConfigComponentInfo info) {
        ConfigurationComponentTypeId result = null;
        Collection componentFiles = UtilsFile.getAllFilesInDir((File)info.getComponentDir(), (boolean)false, (String)COMPONENT_EXTENSION);
        if (componentFiles.isEmpty()) {
            LOGGER.severe(() -> MessageFormat.format("[DATA] No component file found in folder: {0}", info.getComponentDir()));
        } else {
            File componentFile;
            ConfigurationComponent component;
            if (componentFiles.size() > 1) {
                LOGGER.warning(() -> MessageFormat.format("[DATA] More component files found in folder \"{0}\", loading only first of them", info.getComponentDir()));
            }
            if ((component = ConfigurationComponent.loadComponentFromFile(componentFile = (File)componentFiles.iterator().next(), ConfigurationComponent.LoadMode.STANDARD, null)) == null) {
                LOGGER.severe(() -> MessageFormat.format("[DATA] Component could not be loaded: {0}", componentFile));
            } else {
                result = ConfigurationComponentTypeId.createFromComponentInfo((IConfigComponentInfo)info, (IConfigurationComponent)component);
            }
        }
        boolean skipCheck = Boolean.parseBoolean(SWToolsProperties.getProperty((String)"com.nxp.swtools.periph.verify.ignore_typeid_type_match_check.disable", (String)"false"));
        if (result != null && SWToolsProperties.isVerificationOn() && !skipCheck) {
            if (result.isHidden()) {
                return result;
            }
            String componentDirName = info.getComponentDir().getName();
            if (result.getType().equals(componentDirName)) {
                return result;
            }
            int underscoreIndex = componentDirName.lastIndexOf("_");
            if (underscoreIndex == -1) {
                LOGGER.log(Level.SEVERE, "[DATA] Component with type_id \"{0}\" does not contain undescore separator and does not match just the type either", result.getTypeId());
                return result;
            }
            String typeFromFolderName = componentDirName.substring(0, underscoreIndex);
            if (typeFromFolderName.equals(result.getType())) {
                return result;
            }
            String message = "[DATA] Component with type_id: \"{0}\" contains component with id \"{1}\" and id of component does not match with folder name";
            LOGGER.log(Level.SEVERE, MessageFormat.format(message, result.getTypeId(), result.getType()));
        }
        return result;
    }

    private static CollectionMap<ComponentKey, ConfigurationComponentTypeId> loadComponentNewMechanism(IConfigComponentInfo info) {
        Collection componentFiles = UtilsFile.getAllFilesInDir((File)info.getComponentDir(), (boolean)false, (String)COMPONENT_EXTENSION);
        if (componentFiles.isEmpty()) {
            LOGGER.severe(() -> MessageFormat.format("[DATA] No component file found in folder: {0}", info.getComponentDir()));
        } else {
            File componentFile;
            ConfigurationComponent component;
            if (componentFiles.size() > 1) {
                LOGGER.warning(() -> MessageFormat.format("[DATA] More component files found in folder \"{0}\", loading only first of them", info.getComponentDir()));
            }
            if ((component = ConfigurationComponent.loadComponentFromFile(componentFile = (File)CollectionsUtils.get((Iterable)componentFiles, (int)0), ConfigurationComponent.LoadMode.STANDARD, null)) == null) {
                LOGGER.severe(() -> MessageFormat.format("[DATA] Component could not be loaded: {0}", componentFile));
            } else {
                ConfigurationComponentTypeId configurationComponentTypeId = ConfigurationComponentTypeId.create((String)ComponentsProvider.getIdentification(info), (String)info.getSdkVersion(), (File)info.getComponentDir(), (IConfigurationComponent)component);
                return ComponentsProvider.getAllComponentEntries(info, configurationComponentTypeId);
            }
        }
        return new CollectionMap();
    }

    private static CollectionMap<ComponentKey, ConfigurationComponentTypeId> getAllComponentEntries(IConfigComponentInfo info, ConfigurationComponentTypeId configurationComponentTypeId) {
        CollectionMap result = new CollectionMap();
        String alias = info.getAlias();
        if (alias != null) {
            result.add((Object)ComponentKey.folder(alias), (Object)configurationComponentTypeId);
        }
        result.add((Object)ComponentKey.folder(ComponentsProvider.getIdentification(info)), (Object)configurationComponentTypeId);
        result.add((Object)ComponentKey.type(configurationComponentTypeId.getConfigurationComponent().getId()), (Object)configurationComponentTypeId);
        result.add((Object)ComponentKey.category(ComponentsProvider.getCategory(configurationComponentTypeId.getConfigurationComponent())), (Object)configurationComponentTypeId);
        return result;
    }

    public static CollectionMap<ComponentKey, ConfigurationComponentTypeId> getAllComponentEntries(ConfigurationComponentTypeId configurationComponentTypeId) {
        CollectionMap result = new CollectionMap();
        result.add((Object)ComponentKey.folder(configurationComponentTypeId.getTypeId()), (Object)configurationComponentTypeId);
        IConfigurationComponent configurationComponent = configurationComponentTypeId.getConfigurationComponent();
        result.add((Object)ComponentKey.type(configurationComponent.getId()), (Object)configurationComponentTypeId);
        result.add((Object)ComponentKey.category(ComponentsProvider.getCategory(configurationComponentTypeId.getConfigurationComponent())), (Object)configurationComponentTypeId);
        return result;
    }

    private static String getIdentification(IConfigComponentInfo info) {
        String uniqueId = info.getUniqueId();
        String identification = info.getName();
        if (uniqueId != null) {
            identification = uniqueId;
        }
        return identification;
    }

    public static String getCategory(IConfigurationComponent component) {
        String category = component.getCategory();
        if (category == null) {
            return CATEGORY_ID_NO_CATEGORY;
        }
        return category;
    }
}

