/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.gui;

import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.expert.processordb.ExternalMcuDataHelper;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.gui.handler.HttpGetDiagramHandler;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.storage.ProcessorCore;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.concurrent.Worker;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class GtmDiagramSceneCreator {
    private static final Logger LOGGER = LogManager.getLogger(GtmDiagramSceneCreator.class);
    private Scene rootScene;
    private StackPane mainPane = new StackPane();
    private WebView wView;
    protected boolean modificationInProgress = false;
    protected boolean isDiagramLoaded = false;
    protected String jsZoomInCommand = "if (typeof zoomIn !== \"undefined\") zoomIn();";
    protected String jsZoomOutCommand = "if (typeof zoomIn !== \"undefined\") zoomOut();";
    protected String jsShowMenuCommand = "if (typeof showContextMenuAt !== \"undefined\") showContextMenuAt(%s, %s);";
    protected String jsHideMenuCommand = "if (typeof hideContextMenu !== \"undefined\") hideContextMenu();";
    protected String mainDiagramHtmlFile = "gtm-diagram.html";
    private static final String DIAGRAM_REPO = "diagram";
    private static final String RESOURCES_DIR = "resources";
    private static final String DEFAULT_DIAGRAM = "gtm-no-diagram.html";

    public GtmDiagramSceneCreator() {
        this.rootScene = new Scene(this.start());
        this.rootScene.getStylesheets().add((Object)"resources/gtm-default-skin.css");
        this.wView = new WebView();
        this.wView.setContextMenuEnabled(true);
        this.wView.getEngine().setJavaScriptEnabled(true);
        this.wView.addEventFilter(ScrollEvent.SCROLL, evScroll -> {
            double deltaY = evScroll.getDeltaY();
            if (evScroll.isControlDown() && deltaY > 0.0) {
                this.wView.getEngine().executeScript(this.jsZoomInCommand);
                evScroll.consume();
            } else if (evScroll.isControlDown() && deltaY < 0.0) {
                this.wView.getEngine().executeScript(this.jsZoomOutCommand);
                evScroll.consume();
            }
        });
        this.wView.getEngine().getLoadWorker().stateProperty().addListener((obs, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED) {
                this.updateDiagramSettings();
            }
        });
        this.wView.addEventFilter(MouseEvent.MOUSE_CLICKED, evClick -> {
            if (evClick.getButton() == MouseButton.SECONDARY) {
                double newX = evClick.getX() / this.wView.getZoom();
                double newY = evClick.getY() / this.wView.getZoom();
                String menuCommand = String.format(this.jsShowMenuCommand, Double.toString(newX), Double.toString(newY));
                this.wView.getEngine().executeScript(menuCommand);
            } else {
                this.wView.getEngine().executeScript(this.jsHideMenuCommand);
            }
        });
        this.wView.getEngine().setOnError(eventError -> LOGGER.log(Level.SEVERE, String.format("WebEngine error in %s: %s", GtmDiagramSceneCreator.class, eventError.getMessage())));
        this.wView.getEngine().setOnAlert(event -> {
            Alert alert = new Alert(Alert.AlertType.INFORMATION);
            alert.setTitle("Diagram View Alert");
            alert.setHeaderText(null);
            alert.setContentText((String)event.getData());
            alert.showAndWait();
        });
    }

    public Parent start() {
        return this.mainPane;
    }

    public Scene getRootScene() {
        return this.rootScene;
    }

    public void createLayout() {
        this.dispose();
        this.isDiagramLoaded = false;
        String docFullPath = this.getDiagram();
        WebEngine webEngine = this.wView.getEngine();
        this.mainPane.getChildren().add((Object)this.wView);
        webEngine.load(docFullPath);
    }

    private void updateDiagramSettings() {
        if (!this.isDiagramLoaded) {
            return;
        }
        if (this.modificationInProgress) {
            return;
        }
        this.modificationInProgress = true;
        ISharedConfiguration configuration = SharedConfigurationFactory.getSharedConfigurationSingleton();
        ICommonConfig commonConfig = configuration.getCommonConfig();
        JSONObject commonConfigJson = new JSONObject();
        try {
            commonConfigJson.put("mcu", (Object)commonConfig.getMcu());
            ProcessorCore selectedCore = commonConfig.getSelectedCore();
            if (selectedCore != null) {
                JSONObject jsonCore = new JSONObject();
                jsonCore.put("id", (Object)selectedCore.getID());
                jsonCore.put("name", (Object)selectedCore.getName());
                jsonCore.put("description", (Object)selectedCore.getDescription());
                jsonCore.put("is_master", selectedCore.isMaster());
                commonConfigJson.put("selected_core", (Object)jsonCore);
            }
        }
        catch (JSONException e) {
            String message = MessageFormat.format("[TOOL] Problem with serializing shared configuration to JSON object in {0}: {1}", GtmDiagramSceneCreator.class, e.getLocalizedMessage());
            LOGGER.log(Level.SEVERE, message);
        }
        IGtmMcu gtmMcu = GtmController.getInstance().getGtmMcu();
        JSONObject res = new JSONObject();
        try {
            for (ABaseUIComponentSetting componentSetting : gtmMcu.getAllGuiComponentSettings()) {
                res.put(componentSetting.getId(), (Object)componentSetting.getCurrentValue());
            }
        }
        catch (JSONException e) {
            String message = MessageFormat.format("[TOOL] Problem with serializing shared configuration to JSON object in {0}: {1}", GtmDiagramSceneCreator.class, e.getLocalizedMessage());
            LOGGER.log(Level.SEVERE, message);
        }
        String scriptPart = "commonConfiguration=" + commonConfigJson + " ;gtmSettings=" + res.toString() + ";if (typeof gtmDiagramManager !== \"undefined\"){ gtmDiagramManager.processGtmSettings();gtmDiagramManager.processCommonConfiguration()}";
        UctUtils.runNowOrRunLater(() -> {
            try {
                this.wView.getEngine().executeScript(scriptPart);
            }
            catch (Exception e) {
                String message = MessageFormat.format("[TOOL] Problem with updating shared configuration to JSON object in {0}: {1}", GtmDiagramSceneCreator.class, e.getLocalizedMessage());
                LOGGER.log(Level.WARNING, message);
            }
            this.modificationInProgress = false;
        });
    }

    public void updateUI() {
        if (GtmController.getInstance().getShouldUpdateConfiguration().get()) {
            this.updateDiagramSettings();
        }
    }

    private @Nullable String getDiagram() {
        IGtmMcu mcu = GtmController.getInstance().getGtmMcu();
        String dataDir = ExternalMcuDataHelper.getInstance().getExternalMcuDataDir(mcu.getMcu(), mcu.getSdkVersion(), "GTM");
        String gtmModelFolder = DataDirectoryUtils.getDbFile((IMcuIdentification)mcu, (String)"gtm_model");
        String gtmDiagramsPath = String.valueOf(dataDir) + File.separator + gtmModelFolder + File.separator + DIAGRAM_REPO;
        String diagramFullPath = String.valueOf(gtmDiagramsPath) + File.separator + this.mainDiagramHtmlFile;
        File file = new File(diagramFullPath);
        if (file.exists() && file.isFile()) {
            this.isDiagramLoaded = true;
            return file.toURI().toString();
        }
        Path resourcesPath = new Path(RESOURCES_DIR);
        Bundle bundle = FrameworkUtil.getBundle(HttpGetDiagramHandler.class);
        if (bundle != null) {
            URL resourcesUrl = FileLocator.find((Bundle)bundle, (IPath)resourcesPath, null);
            try {
                java.nio.file.Path resourcesDirPath = Paths.get(FileLocator.toFileURL((URL)resourcesUrl).toURI());
                LOGGER.log(Level.INFO, "[TOOL] No diagram available in {0}", diagramFullPath);
                String defaultDiagramFullPath = resourcesDirPath.toAbsolutePath() + File.separator + DEFAULT_DIAGRAM;
                File diagramFile = new File(defaultDiagramFullPath);
                if (diagramFile.exists() && diagramFile.isFile()) {
                    return diagramFile.toURI().toString();
                }
            }
            catch (IOException | IllegalArgumentException | URISyntaxException e) {
                LOGGER.severe(MessageFormat.format("[TOOL] Could not read from folder \"{0}\" in {1}: {2}", RESOURCES_DIR, GtmDiagramSceneCreator.class, e.getMessage()));
            }
        } else {
            LOGGER.log(Level.INFO, "Cannot found default diagram file {0}", DEFAULT_DIAGRAM);
        }
        return null;
    }

    public void dispose() {
        this.mainPane.getChildren().clear();
    }
}

