/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.gui;

import com.nxp.swtools.codemanager.ICodeGenerator;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.model.mcu.ProcessorFilterForGTM;
import com.nxp.swtools.provider.configuration.ICommonConfig;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.provider.configuration.storage.StorageTools;
import com.nxp.swtools.provider.configuration.storage.gtm.StorageGtmTool;
import com.nxp.swtools.utils.tools.ITool;

public class GtmTool
implements ITool {
    public @NonNull String getToolId() {
        return "GTM";
    }

    public boolean isProcessorSupported(@NonNull ISharedConfiguration sharedConfig) {
        return ProcessorFilterForGTM.isSupported((ICommonConfig)sharedConfig.getCommonConfig());
    }

    public boolean isUpdated(@NonNull ISharedConfiguration sharedConfig) {
        return !GtmController.getInstance().isCodeDirty();
    }

    public boolean waitUntilUpdated(@NonNull ISharedConfiguration sharedConfig) {
        GtmController controller = GtmController.getInstance();
        if (sharedConfig.getPreferences().isCodePreviewEnabled()) {
            return controller.waitUntilRegenerated();
        }
        return true;
    }

    public @NonNull StorageTool createStorageTool(@NonNull ISharedConfiguration sharedConfig) {
        StorageTools stTools = sharedConfig.getTools();
        assert (stTools.getGtmTool() == null);
        return new StorageGtmTool();
    }

    public boolean isFunctionalGroupSupported() {
        return false;
    }

    public @Nullable ICodeGenerator getCodeGenerator() {
        return GtmController.getInstance();
    }
}

