/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.gui.handler;

import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.expert.processordb.ExternalMcuDataHelper;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.gui.handler.AHttpGtmHandler;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.kex.selector.IMcuIdentification;
import com.nxp.swtools.utils.httpserver.HttpRequest;
import com.nxp.swtools.utils.httpserver.Response;
import com.nxp.swtools.utils.resources.DataDirectoryUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class HttpGetDiagramHandler
extends AHttpGtmHandler {
    private static final Logger LOGGER = LogManager.getLogger(HttpGetDiagramHandler.class);
    private static final String REGEX_DIAGRAM_GROUP_ID = "diagram";
    public static final String PREFIX = "/gtm/diagram";
    private static final Pattern pattern = Pattern.compile("/gtm/diagram/(?<diagram>[^\\/]+)");
    private static final String DIAGRAM_REPO = "diagram";
    private static final String RESOURCES_DIR = "resources";
    private static final String DEFAULT_DIAGRAM = "gtm-no-diagram.html";

    public boolean canHandle(HttpRequest query) {
        return query.getLocation().startsWith(PREFIX);
    }

    public void handle(HttpRequest query) {
        Matcher matcher = pattern.matcher(query.getLocation());
        String diagramFile = null;
        String responseContent = "";
        if (matcher.matches()) {
            diagramFile = matcher.group("diagram");
        }
        if (diagramFile != null) {
            IGtmMcu mcu = GtmController.getInstance().getGtmMcu();
            String dataDir = ExternalMcuDataHelper.getInstance().getExternalMcuDataDir(mcu.getMcu(), mcu.getSdkVersion(), "GTM");
            String gtmModelFolder = DataDirectoryUtils.getDbFile((IMcuIdentification)mcu, (String)"gtm_model");
            String diagramFullPath = String.valueOf(dataDir) + File.separator + gtmModelFolder + File.separator + "diagram" + File.separator + diagramFile;
            File file = new File(diagramFullPath);
            if (file.exists() && file.isFile()) {
                responseContent = UtilsFile.readFileToString((String)diagramFullPath, (Charset)StandardCharsets.UTF_8);
                responseContent = responseContent != null ? responseContent : "";
            } else {
                Path resourcesPath = new Path(RESOURCES_DIR);
                Bundle bundle = FrameworkUtil.getBundle(HttpGetDiagramHandler.class);
                String noDiagramFullPath = "";
                if (bundle != null) {
                    URL resourcesUrl = FileLocator.find((Bundle)bundle, (IPath)resourcesPath, null);
                    try {
                        java.nio.file.Path resourcesDirPath = Paths.get(FileLocator.toFileURL((URL)resourcesUrl).toURI());
                        noDiagramFullPath = resourcesDirPath.toAbsolutePath() + File.separator + DEFAULT_DIAGRAM;
                        LOGGER.log(Level.INFO, MessageFormat.format("[TOOL] No diagram available in {0}", String.valueOf(dataDir) + File.separator + gtmModelFolder + File.separator + "diagram"));
                    }
                    catch (IOException | IllegalArgumentException | URISyntaxException e) {
                        LOGGER.severe(MessageFormat.format("[TOOL] Could not read from folder \"{0}\": {1}", RESOURCES_DIR, e.getMessage()));
                    }
                    responseContent = UtilsFile.readFileToString((String)noDiagramFullPath, (Charset)StandardCharsets.UTF_8);
                    responseContent = responseContent != null ? responseContent : "";
                } else {
                    LOGGER.log(Level.INFO, "Cannot found default diagram file {0}", DEFAULT_DIAGRAM);
                }
            }
        }
        query.setResponse(new Response(200, responseContent));
    }
}

