/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.gui.utils;

import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.EnumSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.ItemSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.SelectionSetting;
import com.nxp.swtools.common.uct.utils.UctLayoutUtils;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controls.EnumSettingControl;
import com.nxp.swtools.gtm.controls.SplitPaneStructNode;
import com.nxp.swtools.gtm.controls.TitledPaneStructNode;
import com.nxp.swtools.gtm.gui.GtmSceneCreator;
import com.nxp.swtools.gtm.gui.utils.GtmToolActions;
import com.nxp.swtools.gtm.model.xml.settings.GtmBoolSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmIntegerSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import java.util.ArrayList;
import java.util.Iterator;
import javafx.animation.PauseTransition;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.util.Duration;

public class GtmLayoutUtils {
    public static void refreshUI(Scene scene) {
        if (scene.getRoot() instanceof SplitPane) {
            SplitPane mainPane = (SplitPane)scene.getRoot();
            for (Node node : mainPane.getItems()) {
                if (!(node instanceof SplitPaneStructNode)) continue;
                ((SplitPaneStructNode)node).refresh();
            }
        }
    }

    public static void updateEnumComboBoxesItems() {
        for (Node node : GtmSceneCreator.getNodes()) {
            EnumSetting enumSetting;
            if (!(node instanceof EnumSettingControl)) continue;
            EnumSettingControl enumSettingControl = (EnumSettingControl)node;
            ComboBox<String> enumCmb = enumSettingControl.getEnumCmb();
            ObservableList<String> enumCmbItems = enumSettingControl.getEnumCmbItems();
            ABaseUIComponentSetting component = UctUtils.getUIComponentSettingById((IMcu)GtmController.getInstance().getGtmMcu(), (String)enumCmb.getId());
            ArrayList<String> itemsToAdd = new ArrayList<String>();
            ArrayList<String> itemsToRemove = new ArrayList<String>();
            if (!(component instanceof EnumSetting) || !GtmLayoutUtils.shouldUpdateCmbItems(enumSetting = (EnumSetting)component, enumCmb)) continue;
            for (ItemSetting item : enumSetting.getItems()) {
                if (item.isVisible() && !enumCmbItems.contains(item.getLabel())) {
                    itemsToAdd.add(item.getLabel());
                    continue;
                }
                if (item.isVisible() || !enumCmbItems.contains(item.getLabel())) continue;
                itemsToRemove.add(item.getLabel());
            }
            enumSettingControl.getEnumCmbItems().removeAll(itemsToRemove);
            enumSettingControl.getEnumCmbItems().addAll(itemsToAdd);
        }
    }

    private static boolean shouldUpdateCmbItems(EnumSetting enumSetting, ComboBox<String> enumCmb) {
        if (enumSetting.getVisibleItems().size() != enumCmb.getItems().size()) {
            return true;
        }
        for (ItemSetting item : enumSetting.getVisibleItems()) {
            if (enumCmb.getItems().contains((Object)item.getLabel())) continue;
            return true;
        }
        return false;
    }

    public static @Nullable Tab getTabWithId(TabPane tabPane, String id) {
        for (Tab tab : tabPane.getTabs()) {
            if (!id.equals(tab.getId())) continue;
            return tab;
        }
        return null;
    }

    public static void resetAllStructSettingsState() {
        for (ABaseUIComponentSetting componentSetting : GtmController.getInstance().getGtmMcu().getAllGuiComponentSettings()) {
            if (!(componentSetting instanceof GtmStructSetting) || componentSetting.getVisibleAttribute().isEmpty()) continue;
            componentSetting.setVisibleState(componentSetting.getInitVisibleState());
            Node node = GtmSceneCreator.getNodeById(componentSetting.getId());
            if (node == null) continue;
            UctLayoutUtils.updateNodeState((Node)node, (ABaseUIComponentSetting)componentSetting);
        }
    }

    public static double ensureVisible(@Nullable Node currentPane, @Nullable Node node) {
        ScrollPane scrollPane = null;
        double parrentYOffset = 0.0;
        double dellayScrollSeconds = 0.0;
        if (currentPane == null || node == null || currentPane instanceof ScrollPane && currentPane == node) {
            return parrentYOffset;
        }
        Node n = currentPane;
        boolean isDirdtyScroll = false;
        if (!(currentPane instanceof ScrollPane)) {
            while (n != null && !(n instanceof ScrollPane)) {
                n = n.getParent();
            }
            if (n != null) {
                scrollPane = (ScrollPane)n;
            }
        } else {
            scrollPane = (ScrollPane)currentPane;
        }
        if (scrollPane == null) {
            return parrentYOffset;
        }
        if (node instanceof TitledPaneStructNode) {
            isDirdtyScroll = ((TitledPaneStructNode)node).setExpandedNoAnimation(true);
        }
        parrentYOffset += GtmLayoutUtils.ensureVisible((Node)scrollPane, (Node)node.getParent());
        if (isDirdtyScroll) {
            dellayScrollSeconds = 0.1;
        }
        PauseTransition delay = new PauseTransition(Duration.seconds((double)dellayScrollSeconds));
        ScrollPane fscrollPane = scrollPane;
        double fparrentYOffset = parrentYOffset += node.getBoundsInParent().getMinY();
        delay.setOnFinished(event -> {
            if (fscrollPane.getContent() != null) {
                double h = fscrollPane.getContent().getBoundsInLocal().getHeight();
                double y = (node.getBoundsInParent().getMaxY() + node.getBoundsInParent().getMinY()) / 2.0 + fparrentYOffset;
                double v = fscrollPane.getViewportBounds().getHeight();
                double scrollPosition = fscrollPane.getVmax() * ((y - 0.5 * v) / (h - v));
                fscrollPane.setVvalue(scrollPosition);
            }
        });
        delay.play();
        return parrentYOffset;
    }

    public static void ensureVisible(Node currentNode, double scrollPosition) {
        ScrollPane pane = null;
        Parent n = currentNode.getParent();
        while (n != null && !(n instanceof ScrollPane)) {
            n = n.getParent();
        }
        if (n != null) {
            pane = (ScrollPane)n;
            pane.setVvalue(scrollPosition);
        }
    }

    public static void runActions(GtmStructSetting structSetting) {
        Iterator iterator = structSetting.getBoolSettings().iterator();
        while (iterator.hasNext()) {
            GtmBoolSetting boolSetting;
            SelectionSetting currentSelectionSetting = boolSetting.getSelectionSettingBasedOnValue((boolSetting = (GtmBoolSetting)iterator.next()).isVisible() && Boolean.parseBoolean(boolSetting.getCurrentValue()));
            if (currentSelectionSetting == null) continue;
            GtmToolActions.executeAction(currentSelectionSetting.getAction());
        }
        for (GtmStructSetting childStructSetting : structSetting.getStructSettings()) {
            GtmLayoutUtils.runActions(childStructSetting);
        }
    }

    public static void setAllNestedIntegerDisableState(GtmStructSetting gtmStructSetting, boolean disableState) {
        for (GtmIntegerSetting componentSetting : gtmStructSetting.getIntegerSettings()) {
            componentSetting.setDisableState(disableState);
            if (componentSetting.isDisabled()) continue;
            componentSetting.checkConstraints(GtmController.getInstance().getGtmMcu(), GtmController.getInstance().getGtmXmlConfig().getConstraints());
        }
        for (GtmStructSetting structSetting : gtmStructSetting.getStructSettings()) {
            GtmLayoutUtils.setAllNestedIntegerDisableState(structSetting, disableState);
        }
    }
}

