/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.orbit.c.enums;

import com.nxp.s32ds.ext.orbit.c.CParseException;
import com.nxp.s32ds.ext.orbit.internal.c.Messages;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;

public class CEnums {
    private static final Pattern ENUM_PATTERN = Pattern.compile("\\s+(\\w+)");

    private CEnums() {
    }

    public static List<String> scanNames(Path pathToHeader, String enumName) throws CParseException {
        if (!Files.exists(pathToHeader, new LinkOption[0])) {
            throw new CParseException(NLS.bind((String)Messages.file_not_found_0, (Object)pathToHeader.toString()));
        }
        if (!Files.isRegularFile(pathToHeader, new LinkOption[0])) {
            throw new CParseException(NLS.bind((String)Messages.is_not_a_file_0, (Object)pathToHeader.toString()));
        }
        Pattern typedefPattern = Pattern.compile("typedef\\s+enum\\s+" + enumName);
        ArrayList<String> result = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader br = Files.newBufferedReader(pathToHeader);){
                String line;
                while ((line = br.readLine()) != null) {
                    if (!typedefPattern.matcher(line).find()) continue;
                    while ((line = br.readLine()) != null) {
                        if (line.contains("}")) {
                            return result;
                        }
                        Matcher constantMatcher = ENUM_PATTERN.matcher(line);
                        if (!constantMatcher.find()) continue;
                        String type = constantMatcher.group(0).trim();
                        result.add(type);
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CParseException(NLS.bind((String)Messages.enums_error_reading_file_0, (Object)pathToHeader.toString()), e);
        }
        throw new CParseException(NLS.bind((String)Messages.enum_enum_0_not_found_in_file_1, (Object)enumName, (Object)pathToHeader.toString()));
    }
}

