/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.dsf.memory;

import com.nxp.s32ds.cdt.internal.svd.dsf.cmd.SvdDsfCmdRequestor;
import com.nxp.s32ds.cdt.internal.svd.dsf.memory.SvdDsfMemoryRange;
import com.nxp.s32ds.cdt.svd.dsf.SvdDsfUtil;
import com.nxp.s32ds.cdt.svd.utils.SvdNumberToStrings;
import com.nxp.s32ds.cdt.svd.utils.SvdTrace;
import com.nxp.s32ds.ext.cdt.dsf.DsfConversions;
import com.nxp.s32ds.ext.cdt.dsf.DsfRequest;
import com.nxp.s32ds.ext.cdt.dsf.DsfRequestor;
import com.nxp.s32ds.ext.cdt.dsf.DsfResponse;
import java.math.BigInteger;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.debug.core.model.MemoryByte;

public class SvdDsfCmdMemoryRequestor
extends SvdDsfCmdRequestor<SvdDsfMemoryRange, BigInteger, MemoryByte[]> {
    private static final String MEMORY_SPACE = "physical";
    private static final String MEM_READ_CMD = "mem_read soc %s %d %s %d";
    private static final String MEM_WRITE_CMD = "mem_write soc %s %d %s %s";
    private static SvdDsfCmdMemoryRequestor INSTANCE = new SvdDsfCmdMemoryRequestor();

    private SvdDsfCmdMemoryRequestor() {
    }

    public static DsfRequestor<SvdDsfMemoryRange, BigInteger, MemoryByte[]> getInstance() {
        return INSTANCE;
    }

    protected String getReadCommand(DsfRequest<SvdDsfMemoryRange, ?> request) {
        int accessSize = ((SvdDsfMemoryRange)request.base).getAlignment();
        String command = String.format(MEM_READ_CMD, SvdNumberToStrings.toHexString(((SvdDsfMemoryRange)request.base).getAddress(), 32), accessSize, MEMORY_SPACE, ((SvdDsfMemoryRange)request.base).getSize() / accessSize);
        SvdTrace.trace("getReadCommand()=[{}]", command);
        return command;
    }

    protected String getWriteCommand(DsfRequest<SvdDsfMemoryRange, BigInteger> request) {
        SvdDsfMemoryRange range = (SvdDsfMemoryRange)request.base;
        BigInteger value = (BigInteger)request.value;
        int size = ((SvdDsfMemoryRange)request.base).getSize();
        byte[] byteBuffer = DsfConversions.toBytes((BigInteger)value, (int)size);
        boolean bigEndian = SvdDsfUtil.isBigEndian(request.session, request.idmContext);
        int alignment = range.getAlignment();
        String command = String.format(MEM_WRITE_CMD, SvdNumberToStrings.toHexString(range.getAddress(), 32), alignment, MEMORY_SPACE, DsfConversions.toHexString((byte[])byteBuffer, (boolean)bigEndian, (int)alignment));
        SvdTrace.trace("getWriteCommand()=[{}]", command);
        return command;
    }

    protected DsfResponse<SvdDsfMemoryRange, MemoryByte[]> createResponse(DsfRequest<SvdDsfMemoryRange, ?> request, MIConsoleStreamOutput output) {
        boolean bigEndian = SvdDsfUtil.isBigEndian(request.session, request.idmContext);
        String response = DsfConversions.cleanUp((String)output.getString());
        SvdTrace.trace("createResponse()=[{}]", response);
        Byte[] byteArray = DsfConversions.toByteArray((String)response, (boolean)true, (int)((SvdDsfMemoryRange)request.base).getAlignment());
        return new DsfResponse(request, (Object)DsfConversions.toMemoryBytes((Byte[])byteArray, (byte)((byte)(0x22 | (bigEndian ? 16 : 0)))));
    }
}

