/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.dsf.memory;

import com.nxp.s32ds.cdt.internal.svd.dsf.SvdDsfRegistersReadAlwaysCache;
import com.nxp.s32ds.cdt.internal.svd.dsf.SvdDsfRegistersReadAlwaysListenerSupport;
import com.nxp.s32ds.cdt.internal.svd.dsf.memory.SvdDsfMemoryRange;
import com.nxp.s32ds.cdt.internal.svd.dsf.memory.SvdDsfMemoryRangeChain;
import com.nxp.s32ds.cdt.internal.svd.dsf.memory.SvdDsfMemoryRangeChainCache;
import com.nxp.s32ds.cdt.internal.svd.dsf.memory.SvdDsfMemoryRanges;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.ext.cdt.dsf.DsfRequestor;
import java.math.BigInteger;
import java.util.Collection;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.model.MemoryByte;

public class SvdDsfMemoryRegistersReadAlwaysCache
implements SvdDsfRegistersReadAlwaysCache {
    private final Object updateLock = new Object();
    private final Object chainLock = new Object();
    private DsfSession session;
    private DsfRequestor<SvdDsfMemoryRange, BigInteger, MemoryByte[]> requestor;
    private SvdDsfMemoryRangeChain chain;
    private SvdDsfMemoryRangeChain.ChainChangeListener chainChangeListener;
    private SvdDsfMemoryRangeChainCache memoryChainCache;
    private SvdDsfMemoryRangeChainCache prevMemoryChainCache;
    private boolean alignRange;
    private final SvdDsfRegistersReadAlwaysListenerSupport listenerSupport = new SvdDsfRegistersReadAlwaysListenerSupport();
    private IDMContext idmContext;

    public static Builder builder() {
        return new Builder();
    }

    public static SvdDsfMemoryRegistersReadAlwaysCache build(DsfSession session, DsfRequestor<SvdDsfMemoryRange, BigInteger, MemoryByte[]> requestor, boolean alignRange) {
        return SvdDsfMemoryRegistersReadAlwaysCache.builder().session(session).requestor(requestor).alignRange(alignRange).build();
    }

    @Override
    public final void addListener(SvdDsfRegistersReadAlwaysCache.RegistersCacheListener listener) {
        this.listenerSupport.addListener(listener);
    }

    @Override
    public final void removeListener(SvdDsfRegistersReadAlwaysCache.RegistersCacheListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    @Override
    public final void initialize(IDMContext idmContext) {
        this.idmContext = idmContext;
    }

    public SvdDsfMemoryRangeChain getMemoryChain() {
        return this.chain;
    }

    public SvdDsfMemoryRangeChainCache getMemoryCache() {
        return this.memoryChainCache;
    }

    public SvdDsfMemoryRangeChainCache getPrevMemoryCache() {
        return this.prevMemoryChainCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BigInteger getValue(SvdRegister r) {
        SvdDsfMemoryRange range = SvdDsfMemoryRanges.toRange(r, this.alignRange);
        Object object = this.chainLock;
        synchronized (object) {
            if (!this.chain.contains(range)) {
                this.chain.add(range);
                return null;
            }
        }
        object = this.updateLock;
        synchronized (object) {
            return this.memoryChainCache.getValue(range);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigInteger getPrevValue(SvdRegister r) {
        Object object = this.updateLock;
        synchronized (object) {
            return this.prevMemoryChainCache.getValue(SvdDsfMemoryRanges.toRange(r, this.alignRange));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegisters(Collection<SvdRegister> registers) {
        Object object = this.chainLock;
        synchronized (object) {
            for (SvdRegister r : registers) {
                SvdDsfMemoryRange range = SvdDsfMemoryRanges.toRange(r, this.alignRange);
                if (this.chain.contains(range)) continue;
                this.chain.add(range);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRegisters(Collection<SvdRegister> registers) {
        Object object = this.chainLock;
        synchronized (object) {
            for (SvdRegister r : registers) {
                SvdDsfMemoryRange range = SvdDsfMemoryRanges.toRange(r, this.alignRange);
                if (!this.chain.contains(range)) continue;
                this.chain.remove(range);
            }
        }
    }

    @Override
    public void dispose() {
        this.chain.removeListener(this.chainChangeListener);
    }

    public void chainChanged(SvdDsfMemoryRangeChain.ChainChangeType t) {
        if (t == SvdDsfMemoryRangeChain.ChainChangeType.ADD) {
            this.listenerSupport.fireCacheInvalidated();
        }
    }

    protected void installListeners() {
        this.chain.addListener(this.chainChangeListener);
    }

    protected SvdDsfMemoryRangeChain.ChainChangeListener createChainChangeListener() {
        return t -> this.chainChanged(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        Object object = this.chainLock;
        synchronized (object) {
            Object object2 = this.updateLock;
            synchronized (object2) {
                if (this.memoryChainCache.isUpdate()) {
                    this.memoryChainCache.cancelUpdate();
                }
                this.prevMemoryChainCache = this.memoryChainCache;
                this.memoryChainCache = new SvdDsfMemoryRangeChainCache(this.session, this.requestor, this.chain.clone());
            }
        }
        this.memoryChainCache.update(this.idmContext);
    }

    public static class Builder {
        private final SvdDsfMemoryRegistersReadAlwaysCache instance = new SvdDsfMemoryRegistersReadAlwaysCache();

        private Builder() {
        }

        public Builder alignRange(boolean alignRange) {
            this.instance.alignRange = alignRange;
            return this;
        }

        public Builder session(DsfSession session) {
            this.instance.session = session;
            return this;
        }

        public Builder requestor(DsfRequestor<SvdDsfMemoryRange, BigInteger, MemoryByte[]> requestor) {
            this.instance.requestor = requestor;
            return this;
        }

        public Builder chain(SvdDsfMemoryRangeChain chain) {
            this.instance.chain = chain;
            return this;
        }

        public Builder memoryChainCache(SvdDsfMemoryRangeChainCache memoryChainCache) {
            this.instance.memoryChainCache = memoryChainCache;
            return this;
        }

        public Builder prevMemoryChainCache(SvdDsfMemoryRangeChainCache prevMemoryChainCache) {
            this.instance.prevMemoryChainCache = prevMemoryChainCache;
            return this;
        }

        public Builder chainChangeListener(SvdDsfMemoryRangeChain.ChainChangeListener chainChangeListener) {
            this.instance.chainChangeListener = chainChangeListener;
            return this;
        }

        public SvdDsfMemoryRegistersReadAlwaysCache build() {
            SvdDsfMemoryRegistersReadAlwaysCache cache = new SvdDsfMemoryRegistersReadAlwaysCache();
            if (this.instance.session == null) {
                throw new IllegalStateException("session is null");
            }
            cache.alignRange = this.instance.alignRange;
            cache.session = this.instance.session;
            if (this.instance.requestor == null) {
                throw new IllegalStateException("requestor is null");
            }
            cache.requestor = this.instance.requestor;
            cache.chain = this.instance.chain == null ? new SvdDsfMemoryRangeChain() : this.instance.chain;
            cache.memoryChainCache = this.instance.memoryChainCache == null ? new SvdDsfMemoryRangeChainCache(cache.session, cache.requestor, cache.chain.clone()) : this.instance.memoryChainCache;
            cache.prevMemoryChainCache = this.instance.prevMemoryChainCache == null ? new SvdDsfMemoryRangeChainCache(cache.session, cache.requestor, cache.chain.clone()) : this.instance.prevMemoryChainCache;
            cache.chainChangeListener = this.instance.chainChangeListener == null ? cache.createChainChangeListener() : this.instance.chainChangeListener;
            cache.installListeners();
            return cache;
        }
    }
}

