/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.dsf.system;

import com.nxp.s32ds.cdt.internal.svd.dsf.cmd.SvdDsfCmdRequestor;
import com.nxp.s32ds.cdt.svd.model.SvdPeripheral;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.utils.SvdNumberToStrings;
import com.nxp.s32ds.cdt.svd.utils.SvdTrace;
import com.nxp.s32ds.ext.cdt.dsf.DsfConversions;
import com.nxp.s32ds.ext.cdt.dsf.DsfRequest;
import com.nxp.s32ds.ext.cdt.dsf.DsfResponse;
import java.math.BigInteger;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;

public class SvdDsfSystemRegistersRequestor
extends SvdDsfCmdRequestor<SvdRegister, BigInteger, BigInteger> {
    private static final String READ_CMD = "reg_read %s %d";
    private static final String WRITE_CMD = "reg_write %s %s";
    private static final String MON_MEMLIST = "monitor memlist %s 4";
    private static final String MON_SETMEM = "monitor setmem %s %s";
    private static SvdDsfSystemRegistersRequestor INSTANCE = new SvdDsfSystemRegistersRequestor();

    private SvdDsfSystemRegistersRequestor() {
    }

    public static SvdDsfSystemRegistersRequestor getInstance() {
        return INSTANCE;
    }

    protected String getReadCommand(DsfRequest<SvdRegister, ?> request) {
        String command = String.format(READ_CMD, SvdNumberToStrings.toHexString(((SvdRegister)request.base).getAddress(), 32), ((SvdRegister)request.base).getBitLength() / 8);
        SvdPeripheral svdPeripheral = (SvdPeripheral)((SvdRegister)request.base).getParent();
        if (svdPeripheral.getReadCommand() != null) {
            command = svdPeripheral.getReadCommand().equals(MON_MEMLIST) ? String.format(svdPeripheral.getReadCommand(), SvdNumberToStrings.toHexString(((SvdRegister)request.base).getAddress(), 32)) : String.format(svdPeripheral.getReadCommand(), ((SvdRegister)request.base).getName());
        }
        SvdTrace.trace("getReadCommand()=[{}]", command);
        return command;
    }

    protected String getWriteCommand(DsfRequest<SvdRegister, BigInteger> request) {
        String command = String.format(WRITE_CMD, SvdNumberToStrings.toHexString(((SvdRegister)request.base).getAddress(), 32), request.value);
        SvdPeripheral svdPeripheral = (SvdPeripheral)((SvdRegister)request.base).getParent();
        if (svdPeripheral.getWriteCommand() != null) {
            command = svdPeripheral.getWriteCommand().equals(MON_SETMEM) ? String.format(svdPeripheral.getWriteCommand(), SvdNumberToStrings.toHexString(((SvdRegister)request.base).getAddress(), 32), request.value) : String.format(svdPeripheral.getWriteCommand(), ((SvdRegister)request.base).getName(), request.value);
        }
        SvdTrace.trace("getWriteCommand()=[{}({})]", command, SvdNumberToStrings.toHexString((BigInteger)request.value, ((SvdRegister)request.base).getBitLength()));
        return command;
    }

    protected DsfResponse<SvdRegister, BigInteger> createResponse(DsfRequest<SvdRegister, ?> request, MIConsoleStreamOutput output) {
        String response = DsfConversions.cleanUp((String)output.getString());
        SvdTrace.trace("createResponse()=[{}({})]", response, SvdTrace.lazy(() -> SvdNumberToStrings.toHexString(new BigInteger(response), ((SvdRegister)dsfRequest.base).getBitLength())));
        BigInteger result = this.getBigIntegerFromString(response);
        if (result == null) {
            throw new IllegalArgumentException("Failed to parse BigInteger from response string: " + response);
        }
        return new DsfResponse(request, (Object)result);
    }

    private BigInteger getBigIntegerFromString(String response) {
        try {
            int number = Integer.parseInt(response);
            return new BigInteger(String.valueOf(number));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                if (response.startsWith("0x")) {
                    return new BigInteger(response.substring(2), 16);
                }
                return new BigInteger(response);
            }
            catch (NumberFormatException numberFormatException2) {
                return null;
            }
        }
    }
}

