/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.parser;

import com.nxp.s32ds.cdt.internal.svd.Messages;
import com.nxp.s32ds.cdt.internal.svd.SvdActivator;
import com.nxp.s32ds.cdt.internal.svd.parser.ClusterDimGroup;
import com.nxp.s32ds.cdt.internal.svd.parser.DimGroup;
import com.nxp.s32ds.cdt.internal.svd.parser.RegistersDimGroup;
import com.nxp.s32ds.cdt.svd.model.SvdAdresableContainer;
import com.nxp.s32ds.cdt.svd.model.SvdCluster;
import com.nxp.s32ds.cdt.svd.model.SvdField;
import com.nxp.s32ds.cdt.svd.model.SvdPeripheral;
import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.parser.SvdDeviceDescriptor;
import com.nxp.s32ds.cdt.svd.parser.SvdTreeBuilder;
import com.nxp.s32ds.cdt.svd.parser.model.BitRangeType;
import com.nxp.s32ds.cdt.svd.parser.model.ClusterType;
import com.nxp.s32ds.cdt.svd.parser.model.EnumUsageType;
import com.nxp.s32ds.cdt.svd.parser.model.EnumeratedValueType;
import com.nxp.s32ds.cdt.svd.parser.model.EnumerationType;
import com.nxp.s32ds.cdt.svd.parser.model.FieldType;
import com.nxp.s32ds.cdt.svd.parser.model.FieldsType;
import com.nxp.s32ds.cdt.svd.parser.model.ParseRuntimeException;
import com.nxp.s32ds.cdt.svd.parser.model.PeripheralType;
import com.nxp.s32ds.cdt.svd.parser.model.RegisterType;
import com.nxp.s32ds.cdt.svd.parser.model.RegistersType;
import com.nxp.s32ds.cdt.svd.parser.model.ScaledNonNegativeInteger;
import java.math.BigInteger;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public class SvdWalker {
    public static void walk(SvdDeviceDescriptor deviceDescriptor, SvdTreeBuilder builder) throws CoreException {
        List<PeripheralType> types = deviceDescriptor.getDevice().getPeripherals().getPeripheral();
        for (PeripheralType peripheral : types) {
            PeripheralType derivedFrom = SvdWalker.find(types, peripheral.getDerivedFrom());
            SvdWalker.walkPeripheral(builder, peripheral, derivedFrom);
        }
    }

    private static void walkPeripheral(SvdTreeBuilder builder, PeripheralType peripheralType, PeripheralType derivedFrom) {
        SvdPeripheral peripheral = builder.peripheral(peripheralType, derivedFrom);
        SvdWalker.walkClustersOrRegisters(builder, peripheral, SvdWalker.getClustersOrRegisters(peripheralType, derivedFrom));
    }

    private static void walkCluster(SvdTreeBuilder builder, SvdAdresableContainer parent, ClusterType clusterType, String name, BigInteger offset) {
        SvdCluster cluster = builder.cluster(parent, clusterType, name, offset);
        SvdWalker.walkClustersOrRegisters(builder, cluster, clusterType.getRegisterOrCluster());
    }

    private static void walkClustersOrRegisters(SvdTreeBuilder builder, SvdAdresableContainer parent, List<Object> clustersOrRegisters) {
        for (Object clusterOrRegister : clustersOrRegisters) {
            if (clusterOrRegister instanceof RegisterType) {
                RegisterType register = (RegisterType)clusterOrRegister;
                if (register.getDim() == null) {
                    SvdWalker.walkRegister(builder, parent, register, register.getName(), BigInteger.ZERO);
                    continue;
                }
                DimGroup.walkDimGroup(builder, new RegistersDimGroup(register), (name, offset) -> SvdWalker.walkRegister(builder, parent, register, name, offset));
                continue;
            }
            ClusterType cluster = (ClusterType)clusterOrRegister;
            DimGroup.walkDimGroup(builder, new ClusterDimGroup(cluster), (name, offset) -> SvdWalker.walkCluster(builder, parent, cluster, name, offset));
        }
    }

    private static void walkRegister(SvdTreeBuilder builder, SvdAdresableContainer parent, RegisterType registerType, String name, BigInteger offset) {
        SvdRegister register = builder.register(parent, registerType, name, offset);
        FieldsType fieldsType = registerType.getFields();
        if (fieldsType != null) {
            for (FieldType field : fieldsType.getField()) {
                SvdWalker.walkField(builder, register, field);
            }
        }
    }

    private static void walkField(SvdTreeBuilder builder, SvdRegister parent, FieldType fieldType) {
        FieldData fieldData = SvdWalker.getFieldData(fieldType);
        SvdField field = builder.field(parent, fieldType, fieldData.offset, fieldData.length);
        for (EnumerationType enumerationType : fieldType.getEnumeratedValues()) {
            for (EnumeratedValueType enumeratedValueType : enumerationType.getEnumeratedValue()) {
                SvdWalker.walkEnumeratedValueType(builder, field, enumeratedValueType, enumerationType.getUsage());
            }
        }
    }

    private static void walkEnumeratedValueType(SvdTreeBuilder builder, SvdField fieldt, EnumeratedValueType enumeratedValueType, EnumUsageType enumUsageType) {
        if (enumeratedValueType.getValue() == null) {
            throw new ParseRuntimeException(NLS.bind((String)Messages.SvdWalker_field_0_enumeratedvalue_1_requires_value, (Object)fieldt.getName(), (Object)enumeratedValueType.getName()));
        }
        builder.enumeratedValue(fieldt, enumeratedValueType, enumUsageType);
    }

    private static FieldData getFieldData(FieldType field) {
        String name = field.getName();
        ScaledNonNegativeInteger bitOffset = field.getBitOffset();
        if (bitOffset != null) {
            ScaledNonNegativeInteger bitWidth = field.getBitWidth();
            if (bitWidth == null) {
                throw new ParseRuntimeException(NLS.bind((String)Messages.SvdWalker_field_0_with_bitoffset_should_have_bitwidth, (Object)name));
            }
            return new FieldData(bitOffset.getValue().intValue(), bitWidth.getValue().intValue());
        }
        BitRangeType bitRange = field.getBitRange();
        if (bitRange != null) {
            return new FieldData(bitRange.getOffset(), bitRange.getWidth());
        }
        ScaledNonNegativeInteger lsb = field.getLsb();
        if (lsb != null) {
            ScaledNonNegativeInteger msb = field.getMsb();
            if (msb == null) {
                throw new ParseRuntimeException(NLS.bind((String)Messages.SvdWalker_field_0_with_lsb_should_have_msb, (Object)name));
            }
            int fbitoffset = lsb.getValue().intValue();
            return new FieldData(fbitoffset, msb.getValue().byteValue() - fbitoffset + 1);
        }
        throw new ParseRuntimeException(NLS.bind((String)Messages.SvdWalker_field_0_requires_some_description_of_the_bit_range, (Object)name));
    }

    private static List<Object> getClustersOrRegisters(PeripheralType peripheral, PeripheralType derivedFrom) {
        RegistersType registersType = derivedFrom == null ? peripheral.getRegisters() : derivedFrom.getRegisters();
        return registersType.getClusterOrRegister();
    }

    private static PeripheralType find(List<PeripheralType> types, String derivedFrom) throws CoreException {
        if (derivedFrom == null) {
            return null;
        }
        for (PeripheralType peripheralType : types) {
            if (!peripheralType.getName().equals(derivedFrom)) continue;
            return peripheralType;
        }
        throw new CoreException(SvdActivator.getInstance().createError(NLS.bind((String)Messages.SvdWalker_cannot_find_referenced_peripheral_with_name_0, (Object)derivedFrom)));
    }

    private static class FieldData {
        public final int offset;
        public final int length;

        FieldData(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }
}

