/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.model;

import com.nxp.s32ds.cdt.svd.model.SvdAccesible;
import com.nxp.s32ds.cdt.svd.model.SvdAdresableContainer;
import com.nxp.s32ds.cdt.svd.model.SvdContainer;
import com.nxp.s32ds.cdt.svd.model.SvdField;
import com.nxp.s32ds.cdt.svd.parser.model.AccessType;
import java.math.BigInteger;
import java.util.List;
import org.eclipse.cdt.core.IAddress;

public class SvdRegister
extends SvdAdresableContainer
implements SvdAccesible {
    private final int bitLength;
    private final BigInteger resetValue;
    private final AccessType accessType;
    private final boolean readOnDemand;

    public SvdRegister(SvdAdresableContainer parent, String name, String description, IAddress address, BigInteger resetValue, AccessType accessType, int bitLength, boolean readOnDemand) {
        super((SvdContainer)parent, name, description, address, SvdField.class);
        this.resetValue = resetValue;
        this.accessType = accessType;
        this.bitLength = bitLength;
        this.readOnDemand = readOnDemand;
    }

    public SvdRegister(SvdAdresableContainer parent, SvdRegister register) {
        this(parent, register.getName(), register.getDescription(), register.getAddress(), register.resetValue, register.accessType, register.bitLength, register.readOnDemand);
    }

    @Override
    public SvdAdresableContainer getParent() {
        return (SvdAdresableContainer)super.getParent();
    }

    public int getBitLength() {
        return this.bitLength;
    }

    public BigInteger getResetValue() {
        return this.resetValue;
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    public List<SvdField> getFields() {
        return this.getElements(SvdField.class);
    }

    public boolean isReadOnDemand() {
        return this.readOnDemand | this.getFields().stream().anyMatch(SvdField::isReadOnDemand);
    }

    @Override
    public StringBuilder toString(StringBuilder builder) {
        return super.toString(builder).append(", size=").append(this.bitLength).append(", resetvalue=").append(this.resetValue).append(", accessType=").append((Object)this.accessType).append(", readOnDemand=").append(this.readOnDemand);
    }

    @Override
    protected String getChildrenName() {
        return "fields";
    }

    public void fillFrom(SvdRegister register) {
        for (SvdField parentField : register.getFields()) {
            SvdField field = new SvdField(this, parentField);
            field.fillFrom(parentField);
            super.add(field);
        }
    }
}

