/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.model.watch;

import com.nxp.s32ds.cdt.svd.model.SvdRegister;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchContext;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchContextChangeEvent;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchContextManager;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModel;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModelCacheManager;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchModelChangeEvent;
import com.nxp.s32ds.cdt.svd.model.watch.SvdWatchReadPolicyType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.cdt.dsf.service.DsfSession;

public class SvdWatchModelContextManager
extends SvdWatchContextManager {
    private final Map<SvdRegister, SvdWatchContext> contexts = new HashMap<SvdRegister, SvdWatchContext>();
    private final SvdWatchModelCacheManager cacheManager;
    private final SvdWatchModel model;

    public SvdWatchModelContextManager(SvdWatchModel model, SvdWatchModelCacheManager cacheManager) {
        this.model = model;
        this.cacheManager = cacheManager;
    }

    @Override
    public SvdWatchContext getContext(SvdRegister register) {
        if (this.model != register.getModel()) {
            throw new IllegalStateException("Register belongs to another model");
        }
        return this.contexts.computeIfAbsent(register, r -> SvdWatchContext.builder().build(register));
    }

    @Override
    public void sendReadRequest(DsfSession session, Collection<SvdRegister> registers) {
        registers = registers.stream().filter(r -> this.getContext((SvdRegister)r).getReadPolicy().getType() == SvdWatchReadPolicyType.READ_ON_DEMAND).collect(Collectors.toList());
        this.fireContextChanged(new SvdWatchContextChangeEvent(session, this.model, SvdWatchContextChangeEvent.ContextChangeType.READ_REQUEST, registers));
    }

    @Override
    public void setReadPolicyType(DsfSession session, SvdWatchReadPolicyType policyType, Collection<SvdRegister> registers) {
        if ((registers = (Collection)registers.stream().filter(r -> this.getContext((SvdRegister)r).getReadPolicy().isAllowedToChangeReadPolicy()).filter(r -> this.getContext((SvdRegister)r).getReadPolicy().getType() != policyType).collect(Collectors.toList())).size() == 0) {
            return;
        }
        registers.stream().forEach(r -> this.getContext((SvdRegister)r).getReadPolicy().setType(policyType));
        SvdWatchContextChangeEvent.ContextChangeType type = policyType == SvdWatchReadPolicyType.READ_ALWAYS ? SvdWatchContextChangeEvent.ContextChangeType.SET_READ_ALWAYS : SvdWatchContextChangeEvent.ContextChangeType.SET_READ_ON_DEMAND;
        this.fireContextChanged(new SvdWatchContextChangeEvent(session, this.model, type, registers));
        this.cacheManager.fireModelChanged(new SvdWatchModelChangeEvent(this.model, 4, registers));
    }

    @Override
    public void setContext(SvdRegister register, SvdWatchContext context) {
        SvdWatchContext defaultContext = SvdWatchContext.builder().build(register);
        SvdWatchContext.Builder builder = SvdWatchContext.builder();
        if (defaultContext.getReadPolicy().isAllowedToChangeReadPolicy()) {
            builder.readPolicy(context.getReadPolicy());
        } else {
            builder.readPolicy(defaultContext.getReadPolicy());
        }
        this.contexts.put(register, builder.build());
    }
}

