/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.parser.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.nxp.s32ds.cdt.internal.svd.SvdActivator;
import com.nxp.s32ds.cdt.internal.svd.dsf.memory.Messages;
import com.nxp.s32ds.cdt.svd.model.SvdDeviceModel;
import com.nxp.s32ds.cdt.svd.parser.cache.SvdLoadSourceJob;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdPathSource;
import com.nxp.s32ds.cle.ide.debugger.svd.SvdSource;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public class SvdCache {
    private static SvdCache INSTANCE = new SvdCache();
    private final Cache<String, CacheHolder> cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).maximumSize(10L).build();

    private SvdCache() {
    }

    public static SvdCache getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<SvdDeviceModel> getModel(SvdSource source) {
        if (source == null) {
            throw new IllegalArgumentException("Argument source is null");
        }
        if (source instanceof SvdPathSource) {
            return SvdCache.scheduleFeatureWithJob(source);
        }
        Cache<String, CacheHolder> cache = this.cache;
        synchronized (cache) {
            CacheHolder cacheHolder;
            try {
                cacheHolder = (CacheHolder)this.cache.get((Object)source.getUID(), () -> new CacheHolder(SvdCache.scheduleFeatureWithJob(source)));
            }
            catch (ExecutionException e) {
                SvdActivator.getInstance().logError("Error during cache access", e);
                CompletableFuture<SvdDeviceModel> future = new CompletableFuture<SvdDeviceModel>();
                future.completeExceptionally(e);
                return future;
            }
            CompletableFuture<SvdDeviceModel> future = cacheHolder.getFuture();
            if (!future.isDone() || !future.isCancelled() && !future.isCompletedExceptionally() && future.getNow(null) != null) {
                return future;
            }
            cacheHolder.setFuture(SvdCache.scheduleFeatureWithJob(source));
            return cacheHolder.getFuture();
        }
    }

    private static CompletableFuture<SvdDeviceModel> scheduleFeatureWithJob(SvdSource source) {
        CompletionStage completableFuture = new CompletableFuture().exceptionally(e -> {
            SvdActivator.getInstance().logError("Error during loading of SVD file", (Throwable)e);
            return null;
        });
        SvdLoadSourceJob job = new SvdLoadSourceJob(Messages.SvdDsfParseRegistrySources, source);
        job.setUser(true);
        job.setPriority(30);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter((CompletableFuture)completableFuture, job){
            private final /* synthetic */ CompletableFuture val$completableFuture;
            private final /* synthetic */ SvdLoadSourceJob val$job;
            {
                this.val$completableFuture = completableFuture;
                this.val$job = svdLoadSourceJob;
            }

            public void done(IJobChangeEvent event) {
                if (event.getResult().isOK()) {
                    this.val$completableFuture.complete(this.val$job.getModel());
                } else {
                    this.val$completableFuture.complete(null);
                }
            }
        });
        job.schedule();
        return completableFuture;
    }

    private static class CacheHolder {
        private CompletableFuture<SvdDeviceModel> future;

        public CacheHolder(CompletableFuture<SvdDeviceModel> future) {
            this.future = future;
        }

        public CompletableFuture<SvdDeviceModel> getFuture() {
            return this.future;
        }

        public void setFuture(CompletableFuture<SvdDeviceModel> future) {
            this.future = future;
        }
    }
}

