/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.utils;

import com.nxp.s32ds.cdt.internal.svd.SvdActivator;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SvdPostponedTaskExecutor {
    private final Object lock = new Object();
    private final ScheduledExecutorService refreshExecutor;
    private final long delay;
    private final TimeUnit unit;
    private final Runnable runnable;
    private boolean scheduled;
    private boolean changedAfterScheduled;

    public SvdPostponedTaskExecutor(int corePoolSize, Runnable runnable, long delay, TimeUnit unit) {
        this.runnable = runnable;
        this.delay = delay;
        this.unit = unit;
        this.refreshExecutor = Executors.newScheduledThreadPool(corePoolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleWork() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.scheduled) {
                this.scheduled = true;
                this.scheduleTask();
            } else {
                this.changedAfterScheduled = true;
            }
        }
    }

    private void scheduleTask() {
        this.refreshExecutor.schedule(new ScheduledTask(), this.delay, this.unit);
    }

    public void shutdown() {
        this.refreshExecutor.shutdown();
    }

    private final class ScheduledTask
    implements Runnable {
        private ScheduledTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = SvdPostponedTaskExecutor.this.lock;
            synchronized (object) {
                if (SvdPostponedTaskExecutor.this.changedAfterScheduled) {
                    SvdPostponedTaskExecutor.this.changedAfterScheduled = false;
                    SvdPostponedTaskExecutor.this.scheduleTask();
                    return;
                }
                SvdPostponedTaskExecutor.this.scheduled = false;
            }
            try {
                SvdPostponedTaskExecutor.this.runnable.run();
            }
            catch (Exception e) {
                SvdActivator.getInstance().logError("Error occurred during execution:", e);
            }
        }
    }
}

