/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.utils;

import com.nxp.s32ds.cdt.internal.svd.SvdActivator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class SvdTrace {
    private static SvdTrace INSTANCE = new SvdTrace();
    private static boolean isTraceEnabled = false;
    private final List<Matcher> traceMatchers = new ArrayList<Matcher>();

    private SvdTrace() {
    }

    public static SvdTrace getInstance() {
        return INSTANCE;
    }

    public static <T> LazyToString<T> lazy(Supplier<T> supplier) {
        return new LazyToString<T>(supplier);
    }

    public static boolean isTraceEnabled() {
        return isTraceEnabled;
    }

    public static void trace(String message, Object ... objects) {
        if (!isTraceEnabled) {
            return;
        }
        StackTraceElement trace = SvdTrace.getTrace(3);
        String traceMessage = MessageFormatter.arrayFormat((String)message, (Object[])objects).getMessage();
        String className = trace.getClassName();
        for (Matcher matcher : SvdTrace.INSTANCE.traceMatchers) {
            if (!matcher.reset(className).find()) continue;
            FormattingTuple tuple = MessageFormatter.arrayFormat((String)"{}.{} - {}", (Object[])new Object[]{className, trace.getMethodName(), traceMessage});
            SvdActivator.getInstance().log(SvdActivator.getInstance().createStatus(1, tuple.getMessage(), null));
            return;
        }
    }

    public static void addTraceClass(Class<?> _class) {
        SvdTrace.addTracePattern(_class.getName());
    }

    public static void addTracePattern(String pattern) {
        SvdTrace.INSTANCE.traceMatchers.add(Pattern.compile(Pattern.quote(pattern)).matcher(""));
    }

    private static StackTraceElement getTrace(int deep) {
        if (deep < 0) {
            throw new IllegalArgumentException("Deep argument should be greater than or equals to 0");
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if (deep >= stackTrace.length) {
            throw new IllegalStateException("Deep argument greater than stack size");
        }
        return stackTrace[deep];
    }

    private static class LazyToString<T> {
        private final Supplier<T> supplier;

        public LazyToString(Supplier<T> supplier) {
            this.supplier = supplier;
        }

        public String toString() {
            return String.valueOf(this.supplier.get());
        }
    }
}

