/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.dsf;

import java.math.BigInteger;
import org.eclipse.debug.core.model.MemoryByte;

public class DsfConversions {
    public static final String _0X = "0x";

    public static String cleanUp(String string) {
        return string.replaceAll("(\\r|\\n)", "").trim();
    }

    public static String toHexString(byte[] bytes, boolean bigEndian, int accessSize) {
        if (!bigEndian) {
            bytes = DsfConversions.reorderToLittleEndian(bytes, accessSize);
        }
        return DsfConversions.toHexString(bytes);
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument bytes is null");
        }
        StringBuilder builder = new StringBuilder(_0X);
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            DsfConversions.toString(builder, b);
            ++n2;
        }
        return builder.toString();
    }

    public static String toHexString(Byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument bytes is null");
        }
        StringBuilder builder = new StringBuilder(_0X);
        Byte[] byteArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            Byte b = byteArray[n2];
            if (b == null) {
                builder.append("??");
            } else {
                DsfConversions.toString(builder, b);
            }
            ++n2;
        }
        return builder.toString();
    }

    private static void toString(StringBuilder builder, byte b) {
        builder.append(Character.forDigit(b >> 4 & 0xF, 16));
        builder.append(Character.forDigit(b & 0xF, 16));
    }

    public static byte[] toBytes(BigInteger value, int bytes) {
        if (value == null) {
            throw new IllegalArgumentException("Argument value is null");
        }
        if (bytes < 0) {
            throw new IllegalArgumentException("Argument bytes must be >= 0");
        }
        byte[] byteArray = value.toByteArray();
        int missingLen = bytes - byteArray.length;
        if (missingLen == 0) {
            return byteArray;
        }
        byte[] result = new byte[bytes];
        if (missingLen < 0) {
            System.arraycopy(byteArray, -missingLen, result, 0, bytes);
            return result;
        }
        System.arraycopy(byteArray, 0, result, missingLen, bytes - missingLen);
        return result;
    }

    public static MemoryByte[] toMemoryBytes(Byte[] bytes, byte flags) {
        return DsfConversions.toMemoryBytes(bytes, flags, null);
    }

    public static MemoryByte[] toMemoryBytes(Byte[] bytes, byte flags, MemoryByte defaultValue) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument bytes is null");
        }
        int length = bytes.length;
        MemoryByte[] memoryBytes = new MemoryByte[length];
        int i = 0;
        while (i < length) {
            memoryBytes[i] = bytes[i] != null ? new MemoryByte(bytes[i].byteValue(), flags) : defaultValue;
            ++i;
        }
        return memoryBytes;
    }

    public static Byte[] toByteArray(String string) {
        return DsfConversions.toByteArray(string, true, 1);
    }

    public static byte[] toBytes(Byte[] bytes) {
        byte[] result = new byte[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            result[i] = bytes[i] == null ? (byte)0 : bytes[i];
            ++i;
        }
        return result;
    }

    public static Byte[] toByteArray(String string, boolean bigEndian, int accessSize) {
        int length;
        if (string == null) {
            throw new IllegalArgumentException("Argument string is null");
        }
        if (string.startsWith(_0X)) {
            string = string.substring(2);
        }
        if ((length = string.length()) % 2 != 0) {
            throw new IllegalArgumentException("String length must be even");
        }
        int size = length / 2;
        Byte[] bytes = new Byte[size];
        int i = 0;
        while (i < size) {
            int offset = i * 2;
            String sub = string.substring(offset, offset + 2);
            try {
                bytes[i] = (byte)Integer.parseInt(sub, 16);
            }
            catch (NumberFormatException numberFormatException) {}
            ++i;
        }
        if (bigEndian || accessSize == 1) {
            return bytes;
        }
        return DsfConversions.reorderToLittleEndian(bytes, accessSize);
    }

    public static Byte[] reorderToLittleEndian(Byte[] bytes, int accessSize) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument bytes is null");
        }
        if (bytes.length % accessSize != 0) {
            throw new IllegalArgumentException("Array length must be multiple of accessSize");
        }
        Byte[] result = new Byte[bytes.length];
        int i = 0;
        while (i < bytes.length / accessSize) {
            int j = 0;
            while (j < accessSize) {
                result[accessSize * i + (accessSize - 1 - j)] = bytes[accessSize * i + j];
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static byte[] reorderToLittleEndian(byte[] bytes, int accessSize) {
        if (bytes == null) {
            throw new IllegalArgumentException("Argument bytes is null");
        }
        if (bytes.length % accessSize != 0) {
            throw new IllegalArgumentException("Array length must be multiple of accessSize");
        }
        byte[] result = new byte[bytes.length];
        int i = 0;
        while (i < bytes.length / accessSize) {
            int j = 0;
            while (j < accessSize) {
                result[accessSize * i + (accessSize - 1 - j)] = bytes[accessSize * i + j];
                ++j;
            }
            ++i;
        }
        return result;
    }
}

