/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.cdt.dsf;

import com.nxp.s32ds.ext.cdt.dsf.DsfRequest;
import com.nxp.s32ds.ext.cdt.dsf.DsfRequestType;
import com.nxp.s32ds.ext.cdt.dsf.DsfResponse;
import com.nxp.s32ds.ext.cdt.dsf.DsfSessionInactiveException;
import com.nxp.s32ds.ext.cdt.internal.dsf.CdtDsfActivator;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public abstract class DsfRequestor<B, V, R> {
    public CompletableFuture<DsfResponse<B, R>> requestRead(DsfRequest<B, ?> request) {
        CompletableFuture<DsfResponse<B, R>> result;
        if (request.type != DsfRequestType.READ) {
            throw new IllegalArgumentException("requestRead requires READ requst type");
        }
        try {
            result = this.performRead(request);
        }
        catch (DsfSessionInactiveException dsfSessionInactiveException) {
            result = this.canceledFuture();
        }
        return this.decorateLogError(request, result);
    }

    public CompletableFuture<DsfResponse<B, R>> requestWrite(DsfRequest<B, V> request) {
        CompletableFuture<DsfResponse<B, R>> result;
        if (request.type != DsfRequestType.WRITE) {
            throw new IllegalArgumentException("requestWrite requires WRITE requst type.");
        }
        if (request.value == null) {
            throw new IllegalArgumentException("requestWrite requires non null value.");
        }
        try {
            result = this.performWrite(request);
        }
        catch (DsfSessionInactiveException dsfSessionInactiveException) {
            result = this.canceledFuture();
        }
        return this.decorateLogError(request, result);
    }

    protected abstract CompletableFuture<DsfResponse<B, R>> performRead(DsfRequest<B, ?> var1) throws DsfSessionInactiveException;

    protected abstract CompletableFuture<DsfResponse<B, R>> performWrite(DsfRequest<B, V> var1) throws DsfSessionInactiveException;

    private CompletableFuture<DsfResponse<B, R>> canceledFuture() {
        CompletableFuture<DsfResponse<B, R>> future = new CompletableFuture<DsfResponse<B, R>>();
        future.cancel(false);
        return future;
    }

    private CompletableFuture<DsfResponse<B, R>> decorateLogError(DsfRequest<B, ?> request, CompletableFuture<DsfResponse<B, R>> future) {
        return ((CompletableFuture)future.exceptionally(e -> new DsfResponse(request, (Throwable)e))).thenApply(response -> {
            Throwable throwable = response.throwable;
            if (throwable == null) {
                return response;
            }
            if (throwable instanceof CompletionException) {
                throwable = ((CompletionException)throwable).getCause();
            }
            if (!(throwable instanceof CancellationException)) {
                if (throwable instanceof CoreException) {
                    IStatus status = ((CoreException)throwable).getStatus();
                    CdtDsfActivator.getInstance().log(status);
                    this.handleError(request, status);
                } else {
                    CdtDsfActivator.getInstance().logError(NLS.bind((String)"DSF request error: {0} {1}", response.request.base, (Object)response.request.type.typeName), throwable);
                }
            }
            return response;
        });
    }

    protected void handleError(DsfRequest<B, ?> request, IStatus status) {
    }
}

