/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.efuse.controller.utils;

import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.ItemSetting;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.uct.utils.UctXmlSettingsUtils;
import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.common.uct.xml.settings.ConstraintsTable;
import com.nxp.swtools.common.uct.xml.settings.DisableState;
import com.nxp.swtools.common.uct.xml.settings.LimitValues;
import com.nxp.swtools.common.uct.xml.settings.VisibleState;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.number.NumberFormatValidator;
import com.nxp.swtools.common.utils.number.NumberFormatter;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.efuse.controller.EfuseController;
import com.nxp.swtools.efuse.controller.utils.EfuseExpressions;
import com.nxp.swtools.efuse.controller.utils.StorageEfuseUtils;
import com.nxp.swtools.efuse.model.EfuseEntity;
import com.nxp.swtools.efuse.model.FuseField;
import com.nxp.swtools.efuse.model.FuseWord;
import com.nxp.swtools.efuse.model.mcu.IEfuseMcu;
import com.nxp.swtools.efuse.model.utils.EfuseUtils;
import com.nxp.swtools.efuse.ui.xml.settings.ArraySetting;
import com.nxp.swtools.efuse.ui.xml.settings.ComponentTypes;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseBoolSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseEnumSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseIntegerSetting;
import com.nxp.swtools.efuse.ui.xml.settings.EfuseStructSetting;
import com.nxp.swtools.efuse.xml.settings.AdvancedFuseSetting;
import com.nxp.swtools.efuse.xml.settings.FuseStructSetting;
import com.nxp.swtools.efuse.xml.settings.HeaderSetting;
import com.nxp.swtools.efuse.xml.settings.MemberFuseStructSetting;
import com.nxp.swtools.provider.configuration.storage.efuse.StorageEfuseConfiguration;
import com.nxp.swtools.provider.configuration.storage.efuse.StorageFuseField;
import com.nxp.swtools.provider.configuration.storage.efuse.StorageFuseWord;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EfuseControllerUtils {
    public static void initAllComponentsState(IEfuseMcu selectedMcu) {
        ConstraintsTable constraints = selectedMcu.getEfuseXmlConfig().getConstraints();
        for (EfuseEntity efuseEntity : selectedMcu.getAllEfuseEntities()) {
            EfuseControllerUtils.initComponentState(efuseEntity.getUIComponentSetting(), constraints);
            if (!(efuseEntity.getUIComponentSetting() instanceof EfuseEnumSetting)) continue;
            EfuseEnumSetting enumSetting = (EfuseEnumSetting)efuseEntity.getUIComponentSetting();
            for (ItemSetting item : enumSetting.getItems()) {
                EfuseControllerUtils.initComponentState((ABaseUIComponentSetting)item, constraints);
            }
        }
    }

    public static void initAllComponentsValues(IEfuseMcu selectedMcu) {
        for (EfuseEntity efuseEntity : selectedMcu.getAllEfuseEntities()) {
            ItemSetting defaultItem;
            ABaseUIComponentSetting component = efuseEntity.getUIComponentSetting();
            if (component instanceof ArraySetting) {
                ((ArraySetting)component).getSettings().clear();
            }
            component.setCurrentValue(component.getInitValue());
            if (component instanceof EfuseEnumSetting && (defaultItem = (ItemSetting)((EfuseEnumSetting)component).getItems().stream().filter(x -> x.getId().equals(component.getInitValue())).findFirst().orElse(null)) != null) {
                ((EfuseEnumSetting)component).setCurrentSelection(defaultItem.getLabel());
            }
            long defaultValue = UctUtils.getUIComponentDefaultValue((ABaseUIComponentSetting)component);
            FuseField associatedFuseField = efuseEntity.getFuseField();
            if (associatedFuseField != null) {
                associatedFuseField.setValueToWrite(defaultValue);
                continue;
            }
            FuseWord associatedFuseWord = efuseEntity.getParentFuseWord();
            if (associatedFuseWord == null) continue;
            associatedFuseWord.setValueToWrite(defaultValue);
        }
    }

    public static void resetStructSetting(EfuseStructSetting structSetting) {
        for (ABaseUIComponentSetting childSetting : structSetting.getChildrenComponents()) {
            childSetting.setCurrentValue(childSetting.getInitValue());
            EfuseEntity associatedEfuseEntity = EfuseControllerUtils.getEfuseEntity(childSetting);
            if (associatedEfuseEntity != null) {
                FuseField associatedFuseField = associatedEfuseEntity.getFuseField();
                if (associatedFuseField != null) {
                    associatedFuseField.setValueToWrite(UctUtils.getUIComponentDefaultValue((ABaseUIComponentSetting)childSetting));
                } else {
                    FuseWord associatedFuseWord = associatedEfuseEntity.getParentFuseWord();
                    if (associatedFuseWord != null) {
                        associatedFuseWord.setValueToWrite(UctUtils.getUIComponentDefaultValue((ABaseUIComponentSetting)childSetting));
                    }
                }
            }
            EfuseControllerUtils.updateComponentsState(childSetting);
        }
        for (EfuseStructSetting childStructSetting : structSetting.getStructSettings()) {
            EfuseControllerUtils.resetStructSetting(childStructSetting);
        }
    }

    public static @Nullable EfuseEntity getEfuseEntity(ABaseUIComponentSetting component) {
        for (EfuseEntity efuseEntity : EfuseController.getInstance().getEfuseMcu().getAllEfuseEntities()) {
            if (!component.equals(efuseEntity.getUIComponentSetting())) continue;
            return efuseEntity;
        }
        return null;
    }

    public static void computeAllGuiComponentsExpressions(IEfuseMcu selectedMcu) {
        for (EfuseEntity efuseEntity : selectedMcu.getAllEfuseEntities()) {
            EfuseControllerUtils.computeGuiComponentExpression(efuseEntity.getUIComponentSetting());
        }
    }

    public static void computeGuiComponentExpression(ABaseUIComponentSetting component) {
        if (!component.getValueExpression().isEmpty()) {
            EfuseControllerUtils.setUIComponentValue(component, "0x" + Long.toHexString(EfuseExpressions.getLongValueFromExpression(component.getValueExpression())));
        }
    }

    public static void setUIComponentValue(ABaseUIComponentSetting component, String value) {
        EfuseEntity efuseEntity;
        if (component instanceof EfuseEnumSetting) {
            EfuseEnumSetting enumSetting = (EfuseEnumSetting)component;
            List<ItemSetting> enumItems = EfuseControllerUtils.getEnumSettingItems(enumSetting);
            for (ItemSetting item : enumItems) {
                if (!Long.valueOf(item.getValueToWrite()).equals(Long.decode(value))) continue;
                enumSetting.setCurrentValue(item.getId());
                enumSetting.setCurrentSelection(item.getLabel());
                break;
            }
        } else if (component instanceof EfuseBoolSetting) {
            EfuseBoolSetting boolSetting = (EfuseBoolSetting)component;
            String valueToSet = Long.decode(value).equals(1L) ? "true" : "false";
            boolSetting.setCurrentValue(valueToSet);
        } else if (component instanceof EfuseIntegerSetting) {
            component.setCurrentValue(value);
        }
        if ((NumberFormatValidator.isValidDecimal((String)value) || NumberFormatValidator.isValidHexadecimal((String)value)) && (efuseEntity = EfuseControllerUtils.getEfuseEntity(component)) != null) {
            FuseField associatedFuseField = efuseEntity.getFuseField();
            if (associatedFuseField != null) {
                associatedFuseField.setValueToWrite(Long.decode(value).longValue());
            } else {
                FuseWord associatedFuseWord = efuseEntity.getParentFuseWord();
                if (associatedFuseWord != null && !efuseEntity.isEccField()) {
                    associatedFuseWord.setValueToWrite(Long.decode(value).longValue());
                }
            }
        }
    }

    private static void initComponentState(ABaseUIComponentSetting component, ConstraintsTable constraints) {
        String[] constraintsRefList;
        String[] stringArray = constraintsRefList = component.getConstraintsReferences();
        int n = constraintsRefList.length;
        int n2 = 0;
        while (n2 < n) {
            String constraintReference = stringArray[n2];
            if (!constraintReference.isEmpty()) {
                VisibleState visibleState = constraints.getVisibleStateById(constraintReference);
                if (visibleState != null) {
                    component.setVisibleStateCondition(visibleState);
                    boolean state = EfuseControllerUtils.isComponentVisible(component);
                    component.setVisibleState(state);
                    EfuseControllerUtils.setChildrenVisibility(component, state);
                } else {
                    DisableState disableState = constraints.getDisableStateById(constraintReference);
                    if (disableState != null) {
                        component.setDisableStateCondition(disableState);
                        component.setDisableState(EfuseControllerUtils.isComponentDisable(component));
                    }
                }
            }
            ++n2;
        }
    }

    public static void setFuseMemberValueBasedOnDisableState(IEfuseMcu selectedMcu, FuseStructSetting fuseStructure, MemberFuseStructSetting fuseMember) {
        ConstraintsTable constraints;
        DisableState disableState;
        boolean state = false;
        long memberValueToWrite = UctUtils.getLongValueFromString((String)fuseMember.getDefaultValue());
        String constraintReference = fuseMember.getConstraintReference();
        if (!constraintReference.isEmpty() && (disableState = (constraints = selectedMcu.getEfuseXmlConfig().getConstraints()).getDisableStateById(constraintReference)) != null) {
            List allAndDisableConditions = disableState.getAllAndConditions();
            if (!allAndDisableConditions.isEmpty()) {
                state = true;
                int index = 0;
                while (index < allAndDisableConditions.size()) {
                    String condition = (String)allAndDisableConditions.get(index);
                    String disableCondField = UctXmlSettingsUtils.getConditionField((String)condition);
                    String disableCondValue = UctXmlSettingsUtils.getConditionValue((String)condition);
                    if (disableCondField != null && disableCondValue != null) {
                        MemberFuseStructSetting conditionMember = fuseStructure.getMemberById(disableCondField);
                        boolean conditionState = disableState.getState();
                        if (conditionMember != null) {
                            state &= conditionState & conditionMember.getValueToWrite() == UctUtils.getLongValueFromString((String)disableCondValue);
                        }
                    }
                    ++index;
                }
            } else {
                List allOrDisableConditions = disableState.getAllOrConditions();
                state = false;
                int index = 0;
                while (index < allOrDisableConditions.size()) {
                    String condition = (String)allOrDisableConditions.get(index);
                    String disableCondField = UctXmlSettingsUtils.getConditionField((String)condition);
                    String disableCondValue = UctXmlSettingsUtils.getConditionValue((String)condition);
                    if (disableCondField != null && disableCondValue != null) {
                        MemberFuseStructSetting conditionMember = fuseStructure.getMemberById(disableCondField);
                        boolean conditionState = disableState.getState();
                        if (conditionMember != null) {
                            state |= conditionState & conditionMember.getValueToWrite() == UctUtils.getLongValueFromString((String)disableCondValue);
                        }
                    }
                    ++index;
                }
            }
            if (state) {
                memberValueToWrite = disableState.getValueToWrite();
            }
        }
        fuseMember.setValueToWrite(memberValueToWrite);
    }

    public static void updateHeaderDisabledState(IEfuseMcu selectedMcu) {
        boolean state = false;
        HeaderSetting header = selectedMcu.getEfuseXmlConfig().getSerialBootHeader();
        if (header != null) {
            ConstraintsTable constraints;
            DisableState disableState;
            String constraintReference = header.getConstraintReference();
            if (!constraintReference.isEmpty() && (disableState = (constraints = selectedMcu.getEfuseXmlConfig().getConstraints()).getDisableStateById(constraintReference)) != null) {
                List allDisableConditions = disableState.getAllOrConditions();
                int index = 0;
                while (index < allDisableConditions.size()) {
                    String condition = (String)allDisableConditions.get(index);
                    String disableCondField = UctXmlSettingsUtils.getConditionField((String)condition);
                    String disableCondValue = UctXmlSettingsUtils.getConditionValue((String)condition);
                    if (disableCondField != null && disableCondValue != null) {
                        ABaseUIComponentSetting conditionComponent = EfuseControllerUtils.getUIComponentSettingById(disableCondField);
                        boolean conditionState = disableState.getState();
                        if (conditionComponent != null) {
                            state |= conditionState & conditionComponent.getCurrentValue().equals(disableCondValue);
                        }
                    }
                    ++index;
                }
            }
            header.setDisable(state);
        }
    }

    public static void updateComponentsState(ABaseUIComponentSetting conditionComponent) {
        IEfuseMcu selectedMcu = EfuseController.getInstance().getEfuseMcu();
        for (EfuseEntity efuseEntity : selectedMcu.getAllEfuseEntities()) {
            ABaseUIComponentSetting componentSetting = efuseEntity.getUIComponentSetting();
            EfuseControllerUtils.updateComponentState(componentSetting, conditionComponent);
            if (!(componentSetting instanceof EfuseEnumSetting)) continue;
            EfuseEnumSetting enumSetting = (EfuseEnumSetting)componentSetting;
            for (ItemSetting item : enumSetting.getItems()) {
                EfuseControllerUtils.updateComponentState((ABaseUIComponentSetting)item, conditionComponent);
            }
        }
    }

    public static void setChildrenVisibility(ABaseUIComponentSetting component, boolean state) {
        if (component instanceof EfuseStructSetting) {
            List childrenList = ((EfuseStructSetting)component).getChildrenComponents();
            for (ABaseUIComponentSetting child : childrenList) {
                child.setVisibleState(state);
                EfuseControllerUtils.setChildrenVisibility(child, state);
            }
        }
    }

    private static void updateComponentState(ABaseUIComponentSetting component, ABaseUIComponentSetting conditionComponent) {
        boolean newDisableState;
        DisableState disableStateCondition;
        VisibleState visibleStateCondition = component.getVisibleStateCondition();
        if (visibleStateCondition != null && visibleStateCondition.existsOrConditionWithFieldId(conditionComponent.getId())) {
            boolean state = EfuseControllerUtils.isComponentVisible(component);
            component.setVisibleState(state);
            EfuseControllerUtils.setChildrenVisibility(component, state);
        }
        if ((disableStateCondition = component.getDisableStateCondition()) != null && disableStateCondition.existsOrConditionWithFieldId(conditionComponent.getId()) && (newDisableState = EfuseControllerUtils.isComponentDisable(component)) != component.isDisabled()) {
            component.setDisableState(newDisableState);
            EfuseControllerUtils.updateComponentsState(component);
        }
    }

    public static ComponentTypes getComponentTypes() {
        return EfuseController.getInstance().getEfuseXmlConfig().getLayoutComponents().getComponentTypes();
    }

    public static String getLabel(ABaseUIComponentSetting component) {
        ComponentTypes componentTypes = EfuseControllerUtils.getComponentTypes();
        if (!component.getLabel().isEmpty()) {
            return component.getLabel();
        }
        ABaseUIComponentSetting componentType = componentTypes.getComponentTypeById(component.getTypeComponentId());
        if (componentType != null) {
            return componentType.getLabel();
        }
        return "";
    }

    public static List<ItemSetting> getEnumSettingItems(EfuseEnumSetting enumSetting) {
        ComponentTypes componentTypes = EfuseControllerUtils.getComponentTypes();
        if (!enumSetting.getItems().isEmpty()) {
            return enumSetting.getItems();
        }
        EfuseEnumSetting enumSettingType = componentTypes.getEnumTypeById(enumSetting.getTypeComponentId());
        if (enumSettingType != null) {
            enumSetting.getItems().addAll(enumSettingType.getItems());
            return enumSettingType.getItems();
        }
        return new ArrayList<ItemSetting>();
    }

    public static @Nullable ABaseUIComponentSetting getUIComponentSettingById(String id) {
        IEfuseMcu selectedMcu = EfuseController.getInstance().getEfuseMcu();
        List efuseEntities = selectedMcu.getAllEfuseEntities();
        int i = 0;
        while (i < efuseEntities.size()) {
            EfuseEntity efuseEntity = (EfuseEntity)efuseEntities.get(i);
            if (id.equals(efuseEntity.getUIComponentSetting().getId())) {
                return efuseEntity.getUIComponentSetting();
            }
            ++i;
        }
        return null;
    }

    public static void associateUISettingsWithFusesElements(IEfuseMcu mcu) {
        for (EfuseEntity baseUISettingEfuseEntity : mcu.getAllEfuseEntities()) {
            FuseWord parentFuseWord = EfuseUtils.getFuseWordByID((List)mcu.getAllFuseWords(), (String)baseUISettingEfuseEntity.getParentFuseWordID());
            if (parentFuseWord == null) continue;
            baseUISettingEfuseEntity.setParentFuseWord(parentFuseWord);
            FuseField fuseField = EfuseUtils.getFuseFieldByID((FuseWord)parentFuseWord, (String)baseUISettingEfuseEntity.getFuseFieldID());
            if (fuseField == null) continue;
            baseUISettingEfuseEntity.setFuseField(fuseField);
        }
    }

    public static void calculateFuseValueBasedOnExpression(FuseWord fuseWord) {
        long fuseValue;
        String componentValueStr;
        String valueExpression = fuseWord.getXmlSetting().getValueExpression();
        String[] valueExpressionParams = valueExpression.split("\\ ");
        String fieldId = valueExpressionParams[0];
        ABaseUIComponentSetting componentSetting = EfuseControllerUtils.getUIComponentSettingById(fieldId);
        long componentValue = fuseWord.getValueToWrite();
        if (componentSetting != null && (NumberFormatValidator.isValidDecimal((String)(componentValueStr = componentSetting.getCurrentValue())) || NumberFormatValidator.isValidHexadecimal((String)componentValueStr))) {
            componentValue = Long.decode(componentValueStr);
        }
        switch (valueExpressionParams.length) {
            case 3: {
                String operator = valueExpressionParams[1];
                String maskStr = valueExpressionParams[2];
                fuseValue = EfuseUtils.getValueBasedOnBitOperation((long)componentValue, (String)operator, (long)UctUtils.getLongValueFromString((String)maskStr));
                break;
            }
            case 5: {
                String operator1 = valueExpressionParams[1];
                String maskStr1 = valueExpressionParams[2];
                String operator2 = valueExpressionParams[3];
                String maskStr2 = valueExpressionParams[4];
                long mask1 = UctUtils.getLongValueFromString((String)maskStr1);
                long mask2 = UctUtils.getLongValueFromString((String)maskStr2);
                long intermediateValue = EfuseUtils.getValueBasedOnBitOperation((long)componentValue, (String)operator1, (long)mask1);
                fuseValue = EfuseUtils.getValueBasedOnBitOperation((long)intermediateValue, (String)operator2, (long)mask2);
                break;
            }
            default: {
                fuseValue = 0L;
            }
        }
        fuseWord.setValueToWrite(fuseValue);
    }

    public static void calculateAllFuseWordsValues(IEfuseMcu selectedMcu) {
        for (FuseWord fuseWord : selectedMcu.getAllFuseWords()) {
            EfuseControllerUtils.calculateFuseWordValue(fuseWord);
        }
    }

    public static void calculateFuseWordValue(FuseWord fuseWord) {
        if (!fuseWord.getXmlSetting().getValueExpression().isEmpty()) {
            EfuseControllerUtils.calculateFuseValueBasedOnExpression(fuseWord);
        } else if (!fuseWord.getFuseFields().isEmpty()) {
            EfuseUtils.calculateFuseValueBasedOnFields((FuseWord)fuseWord);
        }
    }

    public static void calculateAllFusesMembersValues(IEfuseMcu selectedMcu) {
        for (FuseWord fuseWord : selectedMcu.getAllFuseWords()) {
            FuseStructSetting fuseStructure = fuseWord.getXmlSetting().getFuseStructure();
            if (fuseStructure == null) continue;
            for (MemberFuseStructSetting fuseMember : fuseStructure.getMembersList()) {
                if (!fuseMember.getValueExpression().isEmpty()) {
                    long fuseMemberValueToWrite = EfuseExpressions.getLongValueFromExpression(fuseMember.getValueExpression());
                    fuseMember.setValueToWrite(fuseMemberValueToWrite);
                    continue;
                }
                EfuseControllerUtils.setFuseMemberValueBasedOnDisableState(selectedMcu, fuseStructure, fuseMember);
            }
        }
    }

    public static void calculateFuseFieldsBasedOnWord(IEfuseMcu mcu, FuseWord fuseWord) {
        if (!fuseWord.getFuseFields().isEmpty()) {
            long fieldValue = 0L;
            for (FuseField fuseField : fuseWord.getFuseFields()) {
                int fieldOffset = fuseField.getXmlSetting().getOffset();
                int fieldSize = fuseField.getXmlSetting().getSizeValueInBits();
                fieldValue = (fuseWord.getValueToWrite() & UctUtils.getBitsMaskValue((int)fieldOffset, (int)fieldSize)) >> fieldOffset - fieldSize + 1;
                ABaseUIComponentSetting component = null;
                if (EfuseUtils.isFuseFieldAssociatedWithMultipleComponents((IEfuseMcu)mcu, (String)fuseField.getXmlSetting().getId())) {
                    StorageEfuseConfiguration stEfuseConfig = StorageEfuseUtils.getStorageEfuseConfig();
                    if (stEfuseConfig != null) {
                        StorageEfuseUtils.updateStorageEfuseconfig(mcu);
                        component = EfuseControllerUtils.getComponentSettingBasedOnConstraints(stEfuseConfig.getFuseWords(), fuseField.getXmlSetting().getId());
                        fuseField.setValueToWrite(fieldValue);
                    }
                } else {
                    component = EfuseUtils.getComponentSettingById((IEfuseMcu)mcu, (String)fuseField.getXmlSetting().getId());
                    if (component != null) {
                        boolean state;
                        boolean bl = state = UctUtils.getComponentVisibilityState((IMcu)EfuseController.getInstance().getEfuseMcu(), (ABaseUIComponentSetting)component) && !EfuseControllerUtils.isComponentDisable(component) || EfuseExpressions.isFuseFieldLockSetting(fuseField, mcu.getAllFuseWords());
                        if (state) {
                            fuseField.setValueToWrite(fieldValue);
                        } else {
                            fuseField.setValueToWrite(0L);
                        }
                    }
                }
                if (component == null) continue;
                EfuseControllerUtils.setUIComponentValue(component, "0x" + Long.toHexString(fuseField.getValueToWrite()));
            }
        }
    }

    public static byte[] getFuseBytesToWrite(FuseWord fuseWord) {
        ByteBuffer fuseBytes = ByteBuffer.allocate(0);
        FuseStructSetting fuseStructure = fuseWord.getXmlSetting().getFuseStructure();
        if (fuseStructure != null) {
            int sizeInBytes = fuseStructure.getSizeValueInBytes();
            fuseBytes = ByteBuffer.allocate(sizeInBytes);
            for (MemberFuseStructSetting fuseMember : fuseStructure.getMembersList()) {
                int fuseMemberOffset = fuseMember.getOffset();
                int fuseMemberSizeInBytes = fuseMember.getSizeValueInBytes();
                byte[] fuseMemberBytes = EfuseControllerUtils.getBytesToWriteForFuseMember(fuseMember);
                int i = 0;
                while (i < fuseMemberSizeInBytes) {
                    fuseBytes.put(fuseMemberOffset + i, fuseMemberBytes[i]);
                    ++i;
                }
            }
            NumberFormatter.convertEndianness((byte[])Objects.requireNonNull(fuseBytes.array()), (int)sizeInBytes, (String)fuseStructure.getByteOrder());
        }
        return fuseBytes.array();
    }

    private static byte[] getBytesToWriteForFuseMember(MemberFuseStructSetting fuseMember) {
        int sizeInBytes = fuseMember.getSizeValueInBytes();
        ByteBuffer bufferToWrite = ByteBuffer.allocate(sizeInBytes);
        long valueToWrite = fuseMember.getValueToWrite();
        switch (sizeInBytes) {
            case 1: {
                bufferToWrite.put((byte)valueToWrite);
                break;
            }
            case 4: {
                bufferToWrite.putInt((int)valueToWrite);
            }
        }
        return NumberFormatter.convertEndianness((byte[])Objects.requireNonNull(bufferToWrite.array()), (int)sizeInBytes, (String)fuseMember.getByteOrder());
    }

    public static byte[] getEfuseBinaryContent() {
        ByteBuffer efuseConfigContent = ByteBuffer.allocate(0);
        IEfuseMcu selectedMcu = EfuseController.getInstance().getEfuseMcu();
        if (EfuseUtils.getCurrentMode().equals((Object)EfuseUtils.Mode.STANDARD)) {
            EfuseControllerUtils.calculateAllFuseWordsValues(selectedMcu);
        }
        ByteBuffer templateConfigContent = selectedMcu.getTemplateAppBinaryContent();
        EfuseControllerUtils.calculateAllFusesMembersValues(selectedMcu);
        if (!SWToolsProperties.isHeadlessOn()) {
            EfuseControllerUtils.updateHeaderDisabledState(selectedMcu);
        }
        HeaderSetting header = EfuseController.getInstance().getEfuseXmlConfig().getSerialBootHeader();
        assert (header != null);
        if (header.isDisabled()) {
            HeaderSetting efuseHeader = EfuseController.getInstance().getEfuseXmlConfig().getHeader();
            assert (efuseHeader != null);
            int efuseHeaderSize = efuseHeader.getSizeValueInBytes();
            efuseConfigContent = ByteBuffer.allocate(efuseHeaderSize + templateConfigContent.capacity());
            efuseConfigContent.put(efuseHeader.getBytesToWrite());
            efuseConfigContent.put(templateConfigContent.array());
            for (FuseWord fuseWord : selectedMcu.getAllFuseWords()) {
                FuseStructSetting fuseStructure = fuseWord.getXmlSetting().getFuseStructure();
                if (fuseStructure == null) continue;
                byte[] fuseBufferToWrite = EfuseControllerUtils.getFuseBytesToWrite(fuseWord);
                int sizeInBytes = fuseStructure.getSizeValueInBytes();
                int i = 0;
                while (i < sizeInBytes) {
                    efuseConfigContent.put(fuseStructure.getOffset() + i, fuseBufferToWrite[i]);
                    ++i;
                }
            }
        } else {
            HeaderSetting efuseHeader = EfuseController.getInstance().getEfuseXmlConfig().getHeader();
            assert (efuseHeader != null);
            int efuseHeaderSize = efuseHeader.getSizeValueInBytes();
            int headerSize = header.getSizeValueInBytes();
            efuseConfigContent = ByteBuffer.allocate(efuseHeaderSize + headerSize + templateConfigContent.capacity());
            efuseConfigContent.put(header.getBytesToWrite());
            efuseConfigContent.put(efuseHeader.getBytesToWrite());
            efuseConfigContent.put(templateConfigContent.array());
            int fusesStructOffset = headerSize;
            for (FuseWord fuseWord : selectedMcu.getAllFuseWords()) {
                FuseStructSetting fuseStructure = fuseWord.getXmlSetting().getFuseStructure();
                if (fuseStructure == null) continue;
                byte[] fuseBufferToWrite = EfuseControllerUtils.getFuseBytesToWrite(fuseWord);
                int sizeInBytes = fuseStructure.getSizeValueInBytes();
                int i = 0;
                while (i < sizeInBytes) {
                    efuseConfigContent.put(fusesStructOffset + fuseStructure.getOffset() + i, fuseBufferToWrite[i]);
                    ++i;
                }
            }
        }
        return efuseConfigContent.array();
    }

    public static byte[] getElfApplicationContent() {
        ByteBuffer elfApplicationContent = ByteBuffer.allocate(0);
        IEfuseMcu selectedMcu = EfuseController.getInstance().getEfuseMcu();
        if (EfuseUtils.getCurrentMode().equals((Object)EfuseUtils.Mode.STANDARD)) {
            EfuseControllerUtils.calculateAllFuseWordsValues(selectedMcu);
        }
        ByteBuffer templateConfigContent = selectedMcu.getElfTemplateAppBinaryContent();
        EfuseControllerUtils.calculateAllFusesMembersValues(selectedMcu);
        elfApplicationContent = ByteBuffer.allocate(templateConfigContent.capacity());
        elfApplicationContent.put(templateConfigContent.array());
        for (FuseWord fuseWord : selectedMcu.getAllFuseWords()) {
            FuseStructSetting fuseStructure = fuseWord.getXmlSetting().getFuseStructure();
            if (fuseStructure == null) continue;
            byte[] fuseBufferToWrite = EfuseControllerUtils.getFuseBytesToWrite(fuseWord);
            int sizeInBytes = fuseStructure.getSizeValueInBytes();
            int i = 0;
            while (i < sizeInBytes) {
                elfApplicationContent.put(fuseStructure.getELFOffset() + fuseStructure.getOffset() + i, fuseBufferToWrite[i]);
                ++i;
            }
        }
        return elfApplicationContent.array();
    }

    public static boolean isEccProtected(FuseWord fuseWord) {
        MemberFuseStructSetting eccMember;
        FuseStructSetting fuseStructure = fuseWord.getXmlSetting().getFuseStructure();
        if (fuseStructure != null && (eccMember = fuseStructure.getEccMember()) != null && !eccMember.getValueExpression().isEmpty()) {
            return EfuseExpressions.getLongValueFromExpression(eccMember.getValueExpression()) == 1L;
        }
        return false;
    }

    public static ByteBuffer removeSerialBootHeader(IEfuseMcu selectedMcu, ByteBuffer byteBuffer) {
        ConstraintsTable constraints;
        DisableState disableState;
        HeaderSetting header = EfuseController.getInstance().getEfuseXmlConfig().getSerialBootHeader();
        assert (header != null);
        byte[] byteBufferHeader = UctUtils.getBytesFromBuffer((ByteBuffer)byteBuffer, (int)0, (int)header.getSizeValueInBytes());
        byte[] headerBuffer = header.getBytesToWrite();
        ABaseUIComponentSetting headerComponent = null;
        String constraintReference = header.getConstraintReference();
        if (!constraintReference.isEmpty() && (disableState = (constraints = selectedMcu.getEfuseXmlConfig().getConstraints()).getDisableStateById(constraintReference)) != null) {
            List allDisableConditions = disableState.getAllOrConditions();
            int index = 0;
            while (index < allDisableConditions.size()) {
                String condition = (String)allDisableConditions.get(index);
                String disableCondField = UctXmlSettingsUtils.getConditionField((String)condition);
                String disableCondValue = UctXmlSettingsUtils.getConditionValue((String)condition);
                if (disableCondField != null && disableCondValue != null) {
                    headerComponent = EfuseControllerUtils.getUIComponentSettingById(disableCondField);
                }
                ++index;
            }
        }
        if (Arrays.equals(byteBufferHeader, headerBuffer)) {
            int headerSize;
            ByteBuffer newByteBuffer = ByteBuffer.allocate(byteBuffer.capacity() - header.getSizeValueInBytes());
            int i = headerSize = header.getSizeValueInBytes();
            while (i < byteBuffer.capacity()) {
                newByteBuffer.put(byteBuffer.get(i));
                ++i;
            }
            byteBuffer = newByteBuffer.duplicate();
            if (headerComponent != null) {
                EfuseControllerUtils.setUIComponentValue(headerComponent, "0x" + Long.toHexString(1L));
            }
        } else {
            byte[] efuseHeaderBuffer;
            HeaderSetting efuseHeader = EfuseController.getInstance().getEfuseXmlConfig().getHeader();
            assert (efuseHeader != null);
            byte[] byteBufferEfuseHeader = UctUtils.getBytesFromBuffer((ByteBuffer)byteBuffer, (int)0, (int)efuseHeader.getSizeValueInBytes());
            if (Arrays.equals(byteBufferEfuseHeader, efuseHeaderBuffer = efuseHeader.getBytesToWrite()) && headerComponent != null) {
                EfuseControllerUtils.setUIComponentValue(headerComponent, "0x" + Long.toHexString(0L));
            }
        }
        return byteBuffer;
    }

    public static boolean processEfuseImageComponents(IEfuseMcu selectedMcu, ByteBuffer byteBuffer) {
        byte[] efuseHeaderBuffer;
        HeaderSetting efuseHeader = EfuseController.getInstance().getEfuseXmlConfig().getHeader();
        assert (efuseHeader != null);
        byte[] byteBufferEfuseHeader = UctUtils.getBytesFromBuffer((ByteBuffer)byteBuffer, (int)0, (int)efuseHeader.getSizeValueInBytes());
        if (!Arrays.equals(byteBufferEfuseHeader, efuseHeaderBuffer = efuseHeader.getBytesToWrite())) {
            return false;
        }
        for (FuseWord fuseWord : selectedMcu.getAllFuseWords()) {
            FuseStructSetting fuseStructure = fuseWord.getXmlSetting().getFuseStructure();
            if (fuseStructure == null) continue;
            int fuseStructSize = fuseStructure.getSizeValueInBytes();
            int fuseStructOffset = fuseStructure.getOffset();
            byte[] fuseStructureBuffer = UctUtils.getBytesFromBuffer((ByteBuffer)byteBuffer, (int)fuseStructOffset, (int)fuseStructSize);
            fuseStructureBuffer = NumberFormatter.convertEndianness((byte[])Objects.requireNonNull(fuseStructureBuffer), (int)fuseStructSize, (String)fuseStructure.getByteOrder());
            for (MemberFuseStructSetting fuseMember : fuseStructure.getMembersList()) {
                if (fuseMember.getValueExpression().isEmpty()) continue;
                EfuseControllerUtils.processEfuseMember(fuseMember, fuseStructureBuffer, selectedMcu);
            }
        }
        EfuseControllerUtils.computeAllGuiComponentsExpressions(selectedMcu);
        EfuseControllerUtils.calculateAllFuseWordsValues(selectedMcu);
        EfuseControllerUtils.initAllComponentsState(selectedMcu);
        StorageEfuseUtils.updateStorageEfuseconfig(selectedMcu);
        return true;
    }

    private static void processEfuseMember(MemberFuseStructSetting fuseMember, byte[] fuseStructureBuffer, IEfuseMcu mcu) {
        int fuseMemberSize = fuseMember.getSizeValueInBytes();
        int fuseMemberOffset = fuseMember.getOffset();
        byte[] fuseMemberBuffer = EfuseUtils.extractBytesFromBinaryImage((byte[])fuseStructureBuffer, (int)fuseMemberOffset, (int)fuseMemberSize);
        fuseMemberBuffer = NumberFormatter.convertEndianness((byte[])Objects.requireNonNull(fuseMemberBuffer), (int)fuseMemberSize, (String)fuseMember.getByteOrder());
        String expression = fuseMember.getValueExpression();
        long valueToWrite = UctUtils.getLongValueFromByteArray((byte[])fuseMemberBuffer, (int)0, (int)fuseMemberSize);
        Matcher fuseValueMatcher = EfuseExpressions.GET_FUSE_VALUE_EXPR_REGEX.matcher(expression);
        if (fuseValueMatcher.find() && fuseValueMatcher.groupCount() == 2) {
            String fuseId = fuseValueMatcher.group(2);
            if (fuseId != null) {
                EfuseControllerUtils.processEfuseMemberBasedOnFuseValueExpr(mcu, fuseId, valueToWrite);
            }
        } else {
            Matcher settingValueMatcher = EfuseExpressions.GET_SETTING_VALUE_EXPR_REGEX.matcher(expression);
            if (settingValueMatcher.find() && settingValueMatcher.groupCount() == 2) {
                String settingId = settingValueMatcher.group(2);
                if (settingId != null) {
                    EfuseControllerUtils.processEfuseMemberBasedOnSettingValueExpr(settingId, valueToWrite);
                }
            } else {
                String lockBitsFieldId;
                Matcher lockBitsValueMatcher = EfuseExpressions.GET_LOCK_BITS_VALUE_EXPR_REGEX.matcher(expression);
                if (lockBitsValueMatcher.find() && lockBitsValueMatcher.groupCount() == 2 && (lockBitsFieldId = lockBitsValueMatcher.group(2)) != null) {
                    EfuseControllerUtils.processEfuseMemberBasedOnLockBitsValueExpr(mcu, lockBitsFieldId, valueToWrite);
                }
            }
        }
    }

    private static void processEfuseMemberBasedOnFuseValueExpr(IEfuseMcu mcu, String fuseId, long valueToWrite) {
        FuseWord fuseWord = EfuseUtils.getFuseWordByID((List)mcu.getAllFuseWords(), (String)fuseId);
        if (fuseWord != null) {
            fuseWord.setValueToWrite(valueToWrite);
            if (!fuseWord.getFuseFields().isEmpty()) {
                EfuseControllerUtils.calculateFuseFieldsBasedOnWord(mcu, fuseWord);
            } else {
                ABaseUIComponentSetting fuseWordComponent = EfuseUtils.getComponentSettingByFuseWord((IEfuseMcu)mcu, (String)fuseWord.getXmlSetting().getId());
                if (fuseWordComponent != null) {
                    EfuseControllerUtils.setUIComponentValue(fuseWordComponent, "0x" + Long.toHexString(fuseWord.getValueToWrite()));
                }
            }
        }
    }

    private static void processEfuseMemberBasedOnSettingValueExpr(String settingId, long valueToWrite) {
        ABaseUIComponentSetting componentSetting = EfuseControllerUtils.getUIComponentSettingById(settingId);
        if (componentSetting != null) {
            EfuseControllerUtils.setUIComponentValue(componentSetting, "0x" + Long.toHexString(valueToWrite));
        }
    }

    private static void processEfuseMemberBasedOnLockBitsValueExpr(IEfuseMcu mcu, String lockBitsFieldId, long valueToWrite) {
        for (FuseWord fuseWord : mcu.getAllFuseWords()) {
            FuseField lockBitsField = EfuseUtils.getFuseFieldByID((FuseWord)fuseWord, (String)lockBitsFieldId);
            if (lockBitsField == null) continue;
            EfuseExpressions.setLockBitsFieldValue(lockBitsField, valueToWrite);
            ABaseUIComponentSetting componentSetting = EfuseUtils.getComponentSettingById((IEfuseMcu)mcu, (String)lockBitsFieldId);
            if (componentSetting == null) continue;
            EfuseControllerUtils.setUIComponentValue(componentSetting, "0x" + Long.toHexString(lockBitsField.getValueToWrite()));
        }
    }

    public static boolean isComponentVisible(ABaseUIComponentSetting component) {
        boolean state = true;
        IEfuseMcu mcu = EfuseController.getInstance().getEfuseMcu();
        VisibleState visibleConditionState = component.getVisibleStateCondition();
        if (visibleConditionState != null) {
            state = UctUtils.getComponentVisibilityState((IMcu)mcu, (ABaseUIComponentSetting)component);
            EfuseEntity efuseEntity = EfuseControllerUtils.getEfuseEntity(component);
            if (efuseEntity != null) {
                FuseField associatedFuseField = efuseEntity.getFuseField();
                if (!visibleConditionState.getValueToWriteAsString().isEmpty() && associatedFuseField != null) {
                    if (EfuseUtils.isFuseFieldAssociatedWithMultipleComponents((IEfuseMcu)mcu, (String)associatedFuseField.getXmlSetting().getId())) {
                        if (state) {
                            if (component.getValueToWrite() < 0L || component.getCurrentValue().equals(component.getInitValue())) {
                                associatedFuseField.setValueToWrite(visibleConditionState.getValueToWrite());
                            } else {
                                associatedFuseField.setValueToWrite(component.getValueToWrite());
                            }
                        }
                    } else {
                        associatedFuseField.setValueToWrite(state ? component.getValueToWrite() : visibleConditionState.getValueToWrite());
                    }
                }
            }
        }
        return state;
    }

    public static boolean isComponentDisable(ABaseUIComponentSetting component) {
        boolean state = false;
        long valueToWrite = 0L;
        DisableState disableStateCondition = component.getDisableStateCondition();
        if (disableStateCondition != null) {
            FuseField associatedFuseField;
            List allOrConditions = disableStateCondition.getAllOrConditions();
            for (String condition : allOrConditions) {
                ABaseUIComponentSetting conditionComponent;
                String disableCondField = UctXmlSettingsUtils.getConditionField((String)condition);
                String disableCondValue = UctXmlSettingsUtils.getConditionValue((String)condition);
                if (disableCondField == null || disableCondValue == null || (conditionComponent = EfuseControllerUtils.getUIComponentSettingById(disableCondField)) == null || conditionComponent.isDisabled()) continue;
                boolean conditionState = disableStateCondition.getState();
                state |= conditionState & conditionComponent.getCurrentValue().equals(disableCondValue);
                if (!conditionComponent.getCurrentValue().equals(disableCondValue)) continue;
                valueToWrite = disableStateCondition.getValueToWrite();
            }
            EfuseEntity efuseEntity = EfuseControllerUtils.getEfuseEntity(component);
            if (efuseEntity != null && (associatedFuseField = efuseEntity.getFuseField()) != null) {
                associatedFuseField.setValueToWrite(state ? valueToWrite : component.getValueToWrite());
            }
        }
        return state;
    }

    public static @Nullable ABaseUIComponentSetting getComponentSettingBasedOnConstraints(List<StorageFuseWord> stFuseWords, String id) {
        IEfuseMcu mcu = EfuseController.getInstance().getEfuseMcu();
        for (EfuseEntity efuseEntity : mcu.getAllEfuseEntities()) {
            if (!efuseEntity.getFuseFieldID().equals(id) || !EfuseControllerUtils.isComponentVisibleBasedOnStorage(efuseEntity.getUIComponentSetting(), stFuseWords)) continue;
            return efuseEntity.getUIComponentSetting();
        }
        return null;
    }

    public static List<ABaseUIComponentSetting> getAllComponentSettingsAssociatedWithFuseField(String id) {
        ArrayList<ABaseUIComponentSetting> componentSettingList = new ArrayList<ABaseUIComponentSetting>();
        IEfuseMcu mcu = EfuseController.getInstance().getEfuseMcu();
        for (EfuseEntity efuseEntity : mcu.getAllEfuseEntities()) {
            if (!efuseEntity.getFuseFieldID().equals(id)) continue;
            componentSettingList.add(efuseEntity.getUIComponentSetting());
        }
        return componentSettingList;
    }

    public static boolean isComponentVisibleBasedOnStorage(ABaseUIComponentSetting component, List<StorageFuseWord> stFuseWords) {
        boolean visible = true;
        VisibleState visibleConditionState = component.getVisibleStateCondition();
        if (visibleConditionState != null) {
            visible = false;
            List allOrConditions = visibleConditionState.getAllOrConditions();
            for (String condition : allOrConditions) {
                Matcher parenthesisGroupMatcher = UctUtils.PARENTHESIS_GROUP_REGEX.matcher(condition);
                if (parenthesisGroupMatcher.find() && parenthesisGroupMatcher.groupCount() == 1) {
                    String exprString = parenthesisGroupMatcher.group(1);
                    if (exprString == null) continue;
                    List allAndConditions = UctUtils.getAllAndConditions((String)exprString);
                    visible = EfuseControllerUtils.evaluateAndConditionsBasedOnStorage(allAndConditions, visibleConditionState.getState(), stFuseWords);
                    continue;
                }
                visible |= EfuseControllerUtils.evaluateConditionBasedOnStorage(condition, visibleConditionState.getState(), stFuseWords);
            }
        }
        return visible;
    }

    private static boolean evaluateAndConditionsBasedOnStorage(List<String> conditions, boolean conditionState, List<StorageFuseWord> stFuseWords) {
        boolean result = true;
        for (String condition : conditions) {
            result &= EfuseControllerUtils.evaluateConditionBasedOnStorage(condition, conditionState, stFuseWords);
        }
        return result;
    }

    private static boolean evaluateConditionBasedOnStorage(String condition, boolean conditionState, List<StorageFuseWord> stFuseWords) {
        boolean result = false;
        String visibleCondField = UctXmlSettingsUtils.getConditionField((String)condition);
        String visibleCondValue = UctXmlSettingsUtils.getConditionValue((String)condition);
        if (visibleCondField != null && visibleCondValue != null) {
            String fuseFieldValue = EfuseControllerUtils.getFuseFieldValueFromStorage(stFuseWords, visibleCondField);
            ABaseUIComponentSetting component = EfuseControllerUtils.getUIComponentSettingById(visibleCondField);
            if (fuseFieldValue != null && component != null && !EfuseControllerUtils.isComponentDisabledBasedOnStorage(component, stFuseWords)) {
                if (component instanceof EfuseBoolSetting) {
                    fuseFieldValue = Long.decode(fuseFieldValue).equals(1L) ? "true" : "false";
                    result = conditionState & fuseFieldValue.equals(visibleCondValue);
                } else if (component instanceof EfuseEnumSetting) {
                    EfuseEnumSetting enumSetting = (EfuseEnumSetting)component;
                    List<ItemSetting> enumItems = EfuseControllerUtils.getEnumSettingItems(enumSetting);
                    for (ItemSetting item : enumItems) {
                        if (!Long.valueOf(item.getValueToWrite()).equals(Long.decode(fuseFieldValue))) continue;
                        result = conditionState & item.getId().equals(visibleCondValue);
                    }
                }
            }
        }
        return result;
    }

    private static boolean isComponentDisabledBasedOnStorage(ABaseUIComponentSetting component, List<StorageFuseWord> stFuseWords) {
        boolean result = false;
        DisableState disableStateCondition = component.getDisableStateCondition();
        if (disableStateCondition != null) {
            List allOrConditions = disableStateCondition.getAllOrConditions();
            for (String condition : allOrConditions) {
                String disableCondField = UctXmlSettingsUtils.getConditionField((String)condition);
                String disableCondValue = UctXmlSettingsUtils.getConditionValue((String)condition);
                if (disableCondField == null || disableCondValue == null) continue;
                ABaseUIComponentSetting conditionComponent = EfuseControllerUtils.getUIComponentSettingById(disableCondField);
                String storageValue = EfuseControllerUtils.getFuseFieldValueFromStorage(stFuseWords, disableCondField);
                if (!(conditionComponent instanceof EfuseBoolSetting) || storageValue == null) continue;
                storageValue = Long.decode(storageValue).equals(1L) ? "true" : "false";
                boolean conditionState = disableStateCondition.getState();
                result |= conditionState & storageValue.equals(disableCondValue);
            }
        }
        return result;
    }

    private static @Nullable String getFuseFieldValueFromStorage(List<StorageFuseWord> stFuseWords, String fuseFieldId) {
        for (StorageFuseWord stFuseWord : stFuseWords) {
            StorageFuseField stFuseField = stFuseWord.getFuseFieldById(fuseFieldId);
            if (stFuseField == null) continue;
            return stFuseField.getValue();
        }
        return null;
    }

    public static void addModifiedFusesInAdvancedArray() {
        IEfuseMcu mcu = EfuseController.getInstance().getEfuseMcu();
        List fuseWords = mcu.getAllFuseWords();
        for (FuseWord fuseWord : fuseWords) {
            ArraySetting fuseArray = EfuseControllerUtils.getAdvancedFusesArray();
            if (fuseArray == null) continue;
            AdvancedFuseSetting advancedFuseWord = fuseArray.getAdvancedFuseSettingByFuseWordId(fuseWord.getXmlSetting().getId());
            if (advancedFuseWord != null) {
                long longValue;
                int standardValueBitLength;
                EfuseIntegerSetting integerUIComponentSetting;
                String value;
                String[] valueExpressionParams;
                String fieldId;
                ABaseUIComponentSetting componentSetting;
                EfuseStructSetting fuseWordUiComponent = advancedFuseWord.getUiComponent();
                EfuseIntegerSetting valueIntegerSetting = fuseWordUiComponent.getIntegerSettingById("value_advanced");
                ABaseUIComponentSetting standardFuseWordUIComponent = EfuseUtils.getComponentSettingByFuseWord((IEfuseMcu)mcu, (String)fuseWord.getXmlSetting().getId());
                if (standardFuseWordUIComponent instanceof EfuseIntegerSetting) {
                    int standardValueBitLength2;
                    EfuseIntegerSetting integerStandardFuseWordUIComponent = (EfuseIntegerSetting)standardFuseWordUIComponent;
                    String standardValue = standardFuseWordUIComponent.getCurrentValue();
                    if (!NumberFormatValidator.isValidDecimal((String)standardValue) && !NumberFormatValidator.isValidHexadecimal((String)standardValue) || (standardValueBitLength2 = BigInteger.valueOf(Long.decode(standardValue)).bitLength()) > integerStandardFuseWordUIComponent.getSizeInBits()) continue;
                }
                String valueExpr = fuseWord.getXmlSetting().getValueExpression();
                if (standardFuseWordUIComponent == null && !valueExpr.isEmpty() && (componentSetting = EfuseControllerUtils.getUIComponentSettingById(fieldId = (valueExpressionParams = valueExpr.split("\\ "))[0])) instanceof EfuseIntegerSetting && (!NumberFormatValidator.isValidDecimal((String)(value = (integerUIComponentSetting = (EfuseIntegerSetting)componentSetting).getCurrentValue())) && !NumberFormatValidator.isValidHexadecimal((String)value) || (standardValueBitLength = BigInteger.valueOf(longValue = Long.decode(value).longValue()).bitLength()) > integerUIComponentSetting.getSizeInBits()) || valueIntegerSetting == null) continue;
                valueIntegerSetting.setCurrentValue("0x" + Long.toHexString(fuseWord.getValueToWrite()));
                continue;
            }
            long defaultFuseWordValue = EfuseControllerUtils.getDefaultFuseWordValue(fuseWord);
            if (defaultFuseWordValue != fuseWord.getValueToWrite()) {
                EfuseIntegerSetting valueIntegerSetting;
                EfuseIntegerSetting addressIntegerSetting;
                String type = fuseArray.getTypeComponentId();
                EfuseStructSetting sett = EfuseControllerUtils.getComponentTypes().getStructTypeById(type);
                if (sett == null) continue;
                String id = sett.getId();
                EfuseStructSetting stSettingNew = new EfuseStructSetting(id, sett);
                EfuseEnumSetting fuseWordEnumSetting = stSettingNew.getEnumSettingById("fuse_word_advanced");
                if (fuseWordEnumSetting != null) {
                    fuseWordEnumSetting.setCurrentSelection(fuseWord.getXmlSetting().getId());
                    fuseWordEnumSetting.setCurrentValue(fuseWord.getXmlSetting().getId());
                }
                if ((addressIntegerSetting = stSettingNew.getIntegerSettingById("address_advanced")) != null) {
                    long defaultFuseValue = EfuseControllerUtils.getDefaultFuseWordAddress(fuseWord);
                    addressIntegerSetting.setCurrentValue("0x" + Long.toHexString(defaultFuseValue));
                }
                if ((valueIntegerSetting = stSettingNew.getIntegerSettingById("value_advanced")) != null) {
                    valueIntegerSetting.setCurrentValue("0x" + Long.toHexString(fuseWord.getValueToWrite()));
                }
                AdvancedFuseSetting advancedFuse = new AdvancedFuseSetting(fuseWord.getXmlSetting().getId(), stSettingNew);
                if (fuseArray.getAdvancedFuseSettingByFuseWordId(fuseWord.getXmlSetting().getId()) != null) continue;
                fuseArray.getSettings().add(advancedFuse);
                continue;
            }
            if (fuseArray.getAdvancedFuseSettingByFuseWordId(fuseWord.getXmlSetting().getId()) == null) continue;
            fuseArray.removeAdvancedFuseWithFuseWordId(fuseWord.getXmlSetting().getId());
        }
    }

    public static @Nullable ArraySetting getAdvancedFusesArray() {
        ABaseUIComponentSetting fuseArray = EfuseControllerUtils.getUIComponentSettingById("fuse_array");
        if (fuseArray instanceof ArraySetting) {
            return (ArraySetting)fuseArray;
        }
        return null;
    }

    public static long getDefaultFuseWordAddress(FuseWord fuseWord) {
        String addressMemberId;
        MemberFuseStructSetting addressMember;
        FuseStructSetting fuseStructSetting = fuseWord.getXmlSetting().getFuseStructure();
        if (fuseStructSetting != null && (addressMember = fuseStructSetting.getMemberById(addressMemberId = String.valueOf(fuseWord.getXmlSetting().getId()) + "_" + "addr")) != null) {
            return UctUtils.getLongValueFromString((String)addressMember.getDefaultValue());
        }
        return 0L;
    }

    public static long getDefaultFuseWordValue(FuseWord fuseWord) {
        String valueMemberId;
        MemberFuseStructSetting valueMember;
        FuseStructSetting fuseStructSetting = fuseWord.getXmlSetting().getFuseStructure();
        if (fuseStructSetting != null && (valueMember = fuseStructSetting.getMemberById(valueMemberId = String.valueOf(fuseWord.getXmlSetting().getId()) + "_" + "value")) != null) {
            return UctUtils.getLongValueFromString((String)valueMember.getDefaultValue());
        }
        return 0L;
    }

    public static @Nullable ABaseUIComponentSetting getVisibleUIComponentByFuseFieldId(String fuseFieldId) {
        IEfuseMcu mcu = EfuseController.getInstance().getEfuseMcu();
        for (EfuseEntity efuseEntity : mcu.getAllEfuseEntities()) {
            if (!efuseEntity.getFuseFieldID().equals(fuseFieldId) || !EfuseControllerUtils.isComponentVisible(efuseEntity.getUIComponentSetting())) continue;
            return efuseEntity.getUIComponentSetting();
        }
        return null;
    }

    public static void setUIComponentsForFuseWord(IEfuseMcu mcu, FuseWord fuseWord, EfuseIntegerSetting integerSettingValue) {
        String value = integerSettingValue.getCurrentValue();
        if (!NumberFormatValidator.isValidDecimal((String)value) && !NumberFormatValidator.isValidHexadecimal((String)value)) {
            return;
        }
        long longValue = Long.decode(value);
        int valueBitLenght = BigInteger.valueOf(longValue).bitLength();
        if (valueBitLenght > integerSettingValue.getSizeInBits()) {
            return;
        }
        fuseWord.setValueToWrite(longValue);
        ABaseUIComponentSetting fuseWordUIComponent = EfuseUtils.getComponentSettingByFuseWord((IEfuseMcu)mcu, (String)fuseWord.getXmlSetting().getId());
        if (fuseWordUIComponent != null) {
            EfuseControllerUtils.setUIComponentValue(fuseWordUIComponent, value);
        }
        List fuseFields = fuseWord.getFuseFields();
        for (FuseField fuseField : fuseFields) {
            long fuseFieldValue = EfuseUtils.getFuseFieldValueFromFuseWord((FuseField)fuseField, (FuseWord)fuseWord);
            ABaseUIComponentSetting fuseFieldUIComponent = null;
            fuseFieldUIComponent = EfuseUtils.isFuseFieldAssociatedWithMultipleComponents((IEfuseMcu)mcu, (String)fuseField.getXmlSetting().getId()) ? EfuseControllerUtils.getVisibleUIComponentByFuseFieldId(fuseField.getXmlSetting().getId()) : EfuseUtils.getComponentSettingById((IEfuseMcu)mcu, (String)fuseField.getXmlSetting().getId());
            if (fuseFieldUIComponent == null) continue;
            if ((EfuseControllerUtils.isComponentVisible(fuseFieldUIComponent) || EfuseExpressions.isFuseFieldLockSetting(fuseField, mcu.getAllFuseWords())) && !EfuseControllerUtils.isComponentDisable(fuseFieldUIComponent)) {
                fuseField.setValueToWrite(fuseFieldValue);
                EfuseControllerUtils.setUIComponentValue(fuseFieldUIComponent, "0x" + Long.toHexString(fuseFieldValue));
            }
            EfuseControllerUtils.updateComponentsState(fuseFieldUIComponent);
        }
        if (fuseWordUIComponent == null && fuseFields.isEmpty()) {
            EfuseControllerUtils.computeAllGuiComponentsExpressions(mcu);
        }
    }

    public static void createHiddenFuseFieldsList() {
        ArrayList<FuseField> hiddenFuseFieldList = new ArrayList<FuseField>();
        IEfuseMcu mcu = EfuseController.getInstance().getEfuseMcu();
        for (EfuseEntity efuseEntity : mcu.getAllEfuseEntities()) {
            FuseField fuseField;
            ABaseUIComponentSetting component = efuseEntity.getUIComponentSetting();
            if (component.isVisible() || (fuseField = efuseEntity.getFuseField()) == null || EfuseExpressions.isFuseFieldLockSetting(fuseField, mcu.getAllFuseWords())) continue;
            if (EfuseUtils.isFuseFieldAssociatedWithMultipleComponents((IEfuseMcu)mcu, (String)fuseField.getXmlSetting().getId())) {
                Stream<EfuseEntity> entitiesStream = mcu.getAllEfuseEntities().stream().filter(c -> c.getFuseFieldID().equals(fuseField.getXmlSetting().getId()));
                List entititesList = entitiesStream.collect(Collectors.toList());
                List componentList = entititesList.stream().map(entity -> entity.getUIComponentSetting()).collect(Collectors.toList());
                ABaseUIComponentSetting visibleComp = componentList.stream().filter(c -> c.isVisible()).findFirst().get();
                if (visibleComp != null || hiddenFuseFieldList.contains(fuseField)) continue;
                hiddenFuseFieldList.add(fuseField);
                continue;
            }
            hiddenFuseFieldList.add(fuseField);
        }
        EfuseController.getInstance().setHiddenBootInterfaceFuseField(hiddenFuseFieldList);
    }

    public static void clearAdvancedFusesArray() {
        ArraySetting advancedFuseArray = EfuseControllerUtils.getAdvancedFusesArray();
        if (advancedFuseArray != null) {
            advancedFuseArray.getSettings().clear();
        }
    }

    public static boolean isValueInRange(long valueToTest, LimitValues limitValues) {
        boolean currentStatus = true;
        long minValue = limitValues.getMinLimitValue();
        long maxValue = limitValues.getMaxLimitValue();
        if (minValue > valueToTest || valueToTest > maxValue) {
            currentStatus = false;
        }
        return currentStatus;
    }

    public static boolean isValueInRange(String[] constraintsRefList, long valueToTest, ABaseUIComponentSetting component) {
        boolean currentStatus = true;
        IEfuseMcu selectedMcu = EfuseController.getInstance().getEfuseMcu();
        ConstraintsTable constraints = selectedMcu.getEfuseXmlConfig().getConstraints();
        String[] stringArray = constraintsRefList;
        int n = constraintsRefList.length;
        int n2 = 0;
        while (n2 < n) {
            LimitValues limitValues;
            String constraintReference = stringArray[n2];
            if (!constraintReference.isEmpty() && (limitValues = constraints.getLimitValuesById(constraintReference)) != null) {
                String field = UctXmlSettingsUtils.getConditionField((String)limitValues.getCondition());
                String value = UctXmlSettingsUtils.getConditionValue((String)limitValues.getCondition());
                if (field != null && field.equals(component.getId()) && value != null && value.equals(component.getCurrentValue())) {
                    currentStatus = EfuseControllerUtils.isValueInRange(valueToTest, limitValues);
                }
            }
            ++n2;
        }
        return currentStatus;
    }

    private static void setUIComponentValueToDefault(ABaseUIComponentSetting component) {
        ItemSetting defaultItem;
        if (component instanceof EfuseEnumSetting && (defaultItem = (ItemSetting)((EfuseEnumSetting)component).getItems().stream().filter(item -> item.getId().equals(component.getInitValue())).findFirst().orElse(null)) != null) {
            EfuseControllerUtils.setUIComponentValue(component, "0x" + Long.toHexString(defaultItem.getValueToWrite()));
        }
        if (component instanceof EfuseBoolSetting) {
            String initBoolValue;
            String string = initBoolValue = component.getInitValue().equalsIgnoreCase("false") ? Integer.toString(0) : Integer.toString(1);
            if (initBoolValue != null) {
                EfuseControllerUtils.setUIComponentValue(component, initBoolValue);
            }
        }
        if (component instanceof EfuseIntegerSetting) {
            EfuseControllerUtils.setUIComponentValue(component, "0x" + Long.toHexString(UctUtils.getLongValueFromString((String)component.getInitValue())));
            EfuseController.getInstance().getProblemsManager().clearProblems((IProblemSource)((EfuseIntegerSetting)component));
        }
    }

    public static void resetFuseWordAndComponentsToDefault(FuseWord fuseWord) {
        IEfuseMcu mcu = EfuseController.getInstance().getEfuseMcu();
        fuseWord.setValueToWrite(0L);
        ABaseUIComponentSetting fuseWordComponent = EfuseUtils.getComponentSettingByFuseWord((IEfuseMcu)mcu, (String)fuseWord.getXmlSetting().getId());
        if (fuseWordComponent != null) {
            EfuseControllerUtils.setUIComponentValue(fuseWordComponent, "0x" + Long.toHexString(0L));
        } else {
            String[] valueExpressionParams;
            String componentSettingId;
            String valueExpression = fuseWord.getXmlSetting().getValueExpression();
            if (!valueExpression.isEmpty() && (fuseWordComponent = EfuseControllerUtils.getUIComponentSettingById(componentSettingId = (valueExpressionParams = UtilsText.splitBySpace((String)valueExpression))[0])) != null) {
                EfuseControllerUtils.computeGuiComponentExpression(fuseWordComponent);
            }
        }
        if (fuseWordComponent instanceof EfuseIntegerSetting) {
            EfuseController.getInstance().getProblemsManager().clearProblems((IProblemSource)((EfuseIntegerSetting)fuseWordComponent));
        }
        List fuseFields = fuseWord.getFuseFields();
        for (FuseField fuseField : fuseFields) {
            ABaseUIComponentSetting fuseFieldUIComponent = null;
            if (EfuseUtils.isFuseFieldAssociatedWithMultipleComponents((IEfuseMcu)mcu, (String)fuseField.getXmlSetting().getId())) {
                List<ABaseUIComponentSetting> multipleFuseFieldUIComponents = EfuseControllerUtils.getAllComponentSettingsAssociatedWithFuseField(fuseField.getXmlSetting().getId());
                for (ABaseUIComponentSetting multipleFuseFieldUIComponent : multipleFuseFieldUIComponents) {
                    EfuseControllerUtils.setUIComponentValueToDefault(multipleFuseFieldUIComponent);
                }
                ABaseUIComponentSetting visibleComponent = EfuseControllerUtils.getVisibleUIComponentByFuseFieldId(fuseField.getXmlSetting().getId());
                if (visibleComponent == null) continue;
                fuseField.setValueToWrite(visibleComponent.getValueToWrite());
                continue;
            }
            fuseFieldUIComponent = EfuseUtils.getComponentSettingById((IEfuseMcu)mcu, (String)fuseField.getXmlSetting().getId());
            if (fuseFieldUIComponent == null) continue;
            EfuseControllerUtils.setUIComponentValueToDefault(fuseFieldUIComponent);
        }
        EfuseControllerUtils.calculateFuseWordValue(fuseWord);
    }
}

