/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.variables;

import com.nxp.s32ds.ext.rcp.internal.variables.VariableMessages;
import com.nxp.s32ds.ext.rcp.variables.RcpVariable;
import com.nxp.s32ds.ext.rcp.variables.RcpVariableListener;
import com.nxp.s32ds.ext.rcp.variables.VariableListeners;
import com.nxp.s32ds.ext.rcp.variables.VariableResolver;
import org.eclipse.core.runtime.CoreException;

public class VariableManager {
    public static final VariableManager INSTANCE = new VariableManager();
    private VariableResolver delegate = null;
    private final VariableListeners listeners = new VariableListeners();

    protected VariableManager() {
    }

    public void setResolver(VariableResolver resolver) {
        if (resolver == null) {
            throw new IllegalArgumentException("Argument resolver is null");
        }
        if (this.delegate != null) {
            throw new IllegalStateException(VariableMessages.External_delegate_has_been_set);
        }
        this.delegate = resolver;
        this.delegate.setVariablesListeners(this.listeners);
    }

    public String resolve(String variableId) throws CoreException {
        if (this.delegate == null) {
            throw new IllegalStateException(VariableMessages.External_delegate_has_not_been_set);
        }
        return this.delegate.resolve(variableId);
    }

    public String performSubstitution(String substitutableStr) throws CoreException {
        if (this.delegate == null) {
            throw new IllegalStateException(VariableMessages.External_delegate_has_not_been_set);
        }
        return this.delegate.performSubstitution(substitutableStr);
    }

    public void addListener(RcpVariable variable, RcpVariableListener listener) {
        if (this.delegate == null) {
            this.listeners.addListener(variable, listener);
        } else {
            this.delegate.addListener(variable, listener);
        }
    }

    public void removeListener(RcpVariable variable, RcpVariableListener listener) {
        if (this.delegate == null) {
            this.listeners.removeListener(variable, listener);
        } else {
            this.delegate.removeListener(variable, listener);
        }
    }
}

