/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.variables.standalone;

import com.nxp.s32ds.ext.orbit.strings.SeparatedStrings;
import com.nxp.s32ds.ext.rcp.internal.variables.VariableMessages;
import com.nxp.s32ds.ext.rcp.internal.variables.VariablesActivator;
import com.nxp.s32ds.ext.rcp.variables.RcpVariable;
import com.nxp.s32ds.ext.rcp.variables.RcpVariableListener;
import com.nxp.s32ds.ext.rcp.variables.VariableListeners;
import com.nxp.s32ds.ext.rcp.variables.VariableResolver;
import com.nxp.s32ds.ext.rcp.variables.standalone.RcpVariableArgumentFunction;
import com.nxp.s32ds.ext.rcp.variables.standalone.RcpVariableResolveFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class RcpStandaloneVariablesResolver
implements VariableResolver {
    private static final SeparatedStrings COLON_SEPARATED = new SeparatedStrings((CharSequence)":");
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");
    private final Map<String, RcpVariableResolveFunction> resolveFunctionMap;
    private final Map<String, RcpVariableArgumentFunction> argumentFunctionsMap;

    public RcpStandaloneVariablesResolver(Map<String, String> substitutionsMap, Map<String, RcpVariableArgumentFunction> argumentFunctionsMap) {
        this.resolveFunctionMap = RcpStandaloneVariablesResolver.convert(substitutionsMap);
        this.argumentFunctionsMap = new HashMap<String, RcpVariableArgumentFunction>(argumentFunctionsMap);
    }

    public RcpStandaloneVariablesResolver(Map<String, String> substitutionsMap, Map<String, RcpVariableResolveFunction> resolveFunctionMap, Map<String, RcpVariableArgumentFunction> argumentFunctionsMap) {
        this.resolveFunctionMap = RcpStandaloneVariablesResolver.convert(substitutionsMap);
        this.resolveFunctionMap.putAll(resolveFunctionMap);
        this.argumentFunctionsMap = new HashMap<String, RcpVariableArgumentFunction>(argumentFunctionsMap);
    }

    public RcpStandaloneVariablesResolver() {
        this.resolveFunctionMap = new HashMap<String, RcpVariableResolveFunction>();
        this.argumentFunctionsMap = new HashMap<String, RcpVariableArgumentFunction>();
    }

    public void putArgumentFunctions(Map<String, RcpVariableArgumentFunction> argumentFunctionsMap) {
        this.argumentFunctionsMap.putAll(argumentFunctionsMap);
    }

    public void putSubstitutions(Map<String, String> substitutionsMap) {
        this.resolveFunctionMap.putAll(RcpStandaloneVariablesResolver.convert(substitutionsMap));
    }

    public void putResolveFunctions(Map<String, RcpVariableResolveFunction> resolveFunctionMap) {
        this.resolveFunctionMap.putAll(resolveFunctionMap);
    }

    @Override
    public String resolve(String variableName) throws CoreException {
        RcpVariableResolveFunction value = this.resolveFunctionMap.get(variableName);
        if (value == null) {
            throw new CoreException(RcpStandaloneVariablesResolver.undefinedVariable(variableName));
        }
        return value.resolve(variableName);
    }

    @Override
    public String performSubstitution(String stringWithVariable) throws CoreException {
        if (stringWithVariable == null) {
            throw new IllegalArgumentException("Argument is null!");
        }
        return this.performSubstitution(stringWithVariable, new ArrayList<String>());
    }

    private String performSubstitution(String stringWithVariable, List<String> usedVariables) throws CoreException {
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = VARIABLE_PATTERN.matcher(stringWithVariable);
        while (matcher.find()) {
            String variable = matcher.group(1);
            if (usedVariables.contains(variable)) {
                throw new CoreException(VariablesActivator.getInstance().createError(NLS.bind((String)VariableMessages.RcpStandaloneVariablesResolver_recursive_definition_of_variables_0, (Object)String.join((CharSequence)"->", RcpStandaloneVariablesResolver.createNewList(usedVariables, variable)))));
            }
            RcpVariableResolveFunction resolveFunction = this.resolveFunctionMap.get(variable);
            String arg = null;
            if (resolveFunction == null) {
                String[] asArray = COLON_SEPARATED.asArray(variable);
                if (asArray.length > 0) {
                    variable = asArray[0];
                    resolveFunction = this.resolveFunctionMap.get(variable);
                }
                if (asArray.length > 1) {
                    arg = asArray[1];
                }
            }
            if (resolveFunction == null) {
                throw new CoreException(RcpStandaloneVariablesResolver.undefinedVariable(variable));
            }
            String resolved = this.performSubstitution(resolveFunction.resolve(variable), RcpStandaloneVariablesResolver.createNewList(usedVariables, variable));
            if (arg != null) {
                RcpVariableArgumentFunction argumentFunction = this.argumentFunctionsMap.get(variable);
                if (argumentFunction == null) {
                    throw new CoreException(VariablesActivator.getInstance().createError(NLS.bind((String)VariableMessages.RcpStandaloneVariablesResolver_variable_0_does_not_support_argument, (Object)variable)));
                }
                resolved = argumentFunction.apply(resolved, arg);
            }
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(resolved));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private static List<String> createNewList(List<String> usedVariables, String variable) {
        ArrayList<String> result = new ArrayList<String>(usedVariables);
        result.add(variable);
        return result;
    }

    private static IStatus undefinedVariable(String variable) {
        return VariablesActivator.getInstance().createError(NLS.bind((String)VariableMessages.RcpStandaloneVariablesResolver_reference_to_undefined_variable_0, (Object)variable));
    }

    @Override
    public void addListener(RcpVariable variable, RcpVariableListener listener) {
    }

    @Override
    public void removeListener(RcpVariable variable, RcpVariableListener listener) {
    }

    @Override
    public void setVariablesListeners(VariableListeners listeners) {
    }

    private static Map<String, RcpVariableResolveFunction> convert(Map<String, String> substitutionsMap) {
        return substitutionsMap.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> new StringSubstitutionFunction((String)e.getValue())));
    }

    private static final class StringSubstitutionFunction
    implements RcpVariableResolveFunction {
        private String value;

        public StringSubstitutionFunction(String value) {
            if (value == null) {
                throw new IllegalArgumentException();
            }
            this.value = value;
        }

        @Override
        public String resolve(String variableName) {
            return this.value;
        }
    }
}

