/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.ide.internal.refactoring.text;

import com.nxp.s32ds.ext.ide.internal.refactoring.IdeRefactoringActivator;
import com.nxp.s32ds.ext.ide.internal.refactoring.Messages;
import com.nxp.s32ds.ext.ide.internal.refactoring.text.IdeTextDocumentContext;
import com.nxp.s32ds.ext.ide.internal.refactoring.text.IdeTextDocuments;
import com.nxp.s32ds.ext.ide.refactoring.text.IdeTextEdit;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class IdeTextRefactoring
extends Refactoring {
    private final List<IdeTextEdit> edits;

    public IdeTextRefactoring(List<IdeTextEdit> edits) {
        this.edits = edits;
    }

    public String getName() {
        return Messages.IdeTextRefactoring_change_text;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.edits.isEmpty()) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.IdeTextRefactoring_no_changes_to_apply);
        }
        return new RefactoringStatus();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        IdeTextDocuments documents = new IdeTextDocuments();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)this.getName(), (int)this.edits.size()).checkCanceled();
        CompositeChange compositeChange = new CompositeChange(this.getName());
        compositeChange.addAll((Change[])this.edits.stream().sorted().collect(Collectors.groupingBy(m -> m.getMatch().getFile())).entrySet().stream().map(e -> IdeTextRefactoring.createFileChange(documents, (IFile)e.getKey(), (Collection)e.getValue(), (IProgressMonitor)subMonitor)).filter(c -> c != null).toArray(TextChange[]::new));
        return compositeChange;
    }

    private static TextChange createFileChange(IdeTextDocuments documents, IFile file, Collection<IdeTextEdit> edits, IProgressMonitor monitor) {
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (IdeTextDocumentContext documentContext = documents.createDocumentContext(file, monitor);){
                TextFileChange change = new TextFileChange(NLS.bind((String)Messages.IdeTextRefactoring_changes_for_file_0, (Object)file.getName()), file);
                change.setEdit((TextEdit)new MultiTextEdit());
                for (IdeTextEdit edit : edits) {
                    TextEdit textEdit = edit.createTextEdit(documentContext.getDocument());
                    change.addEdit(textEdit);
                    TextEditChangeGroup textEditChangeGroup = new TextEditChangeGroup((TextChange)change, new TextEditGroup(edit.getDescription(), textEdit));
                    change.addTextEditChangeGroup(textEditChangeGroup);
                }
                monitor.worked(1);
                return change;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (CoreException e) {
            IdeRefactoringActivator.getInstance().log(e.getStatus());
        }
        catch (BadLocationException e) {
            IdeRefactoringActivator.getInstance().logError("Cannot create text change.", e);
        }
        return null;
    }
}

