/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.view.column;

import com.nxp.s32ds.tad.common.rtos.IRtosConfig;
import com.nxp.s32ds.tad.common.view.column.ITadColumnId;
import com.nxp.s32ds.tad.common.view.column.TadColumnCopyable;
import com.nxp.s32ds.tad.common.view.column.TadColumnWeight;
import com.nxp.s32ds.tad.common.view.providers.TadBarGraphProvider;

public class TadColumn {
    private ITadColumnId id;
    private String name;
    private String tooltip;
    private IRtosConfig dependency;
    private TadColumnWeight weight;
    private TadBarGraphProvider styledCell;
    private TadColumnCopyable copyable;

    public TadColumn(ITadColumnId id, String name, String tooltip, TadColumnWeight weight, TadColumnCopyable copyable, TadBarGraphProvider styledCell, IRtosConfig dependency) {
        this.id = id;
        this.name = name;
        this.tooltip = tooltip;
        this.weight = weight;
        this.copyable = copyable;
        this.styledCell = styledCell;
        this.dependency = dependency;
    }

    public TadColumn(ITadColumnId id, String name, String tooltip, TadColumnWeight weight, TadColumnCopyable copyable) {
        this(id, name, tooltip, weight, copyable, null, null);
    }

    public ITadColumnId getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public int getWeight() {
        switch (this.weight) {
            case NARROW: {
                return 2;
            }
            case SMALL: {
                return 5;
            }
            case WIDE: {
                return 15;
            }
        }
        return 10;
    }

    public TadBarGraphProvider getStyledCell() {
        return this.styledCell;
    }

    public IRtosConfig getDependency() {
        return this.dependency;
    }

    public boolean isCopyable() {
        return this.copyable == TadColumnCopyable.COPYABLE;
    }
}

