/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.view.items;

import com.nxp.s32ds.tad.common.messages.Separator;
import com.nxp.s32ds.tad.common.view.column.ITadColumnId;
import java.text.DecimalFormat;
import java.util.List;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public abstract class TadItem {
    protected final int index;

    public TadItem(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void onClickEvent(ITadColumnId column) {
    }

    public TadItem getParent() {
        return null;
    }

    public boolean isParent() {
        return this.getParent() == null;
    }

    public List<? extends TadItem> getChildItems() {
        return null;
    }

    public boolean hasChildItems() {
        return this.getChildItems() != null && !this.getChildItems().isEmpty();
    }

    public List<? extends TadItem> getTreeChildren() {
        return null;
    }

    public boolean hasTreeChildren() {
        return this.getTreeChildren() != null && !this.getTreeChildren().isEmpty();
    }

    public abstract String getText(ITadColumnId var1);

    public Image getImage(ITadColumnId column) {
        return null;
    }

    public Long getNumValue(ITadColumnId column) {
        return null;
    }

    public abstract String toString(Separator var1);

    protected String toString(ITadColumnId[] columns, Separator separator) {
        StringBuilder line = new StringBuilder();
        ITadColumnId[] iTadColumnIdArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            ITadColumnId column = iTadColumnIdArray[n2];
            String value = this.getText(column);
            if (value != null) {
                line.append(value);
            }
            line.append(separator.toString());
            ++n2;
        }
        return line.toString();
    }

    public boolean isValid() {
        return true;
    }

    public Color getTextColour() {
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        ITheme currentTheme = themeManager.getCurrentTheme();
        ColorRegistry colorRegistry = currentTheme.getColorRegistry();
        return colorRegistry.get("COLOR_BLACK");
    }

    public static final String formatBytes(long bytes) {
        float number = bytes;
        String[] stringArray = new String[]{"B", "kB", "MB"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String unit = stringArray[n2];
            if (!(number >= 1024.0f)) {
                return String.valueOf(new DecimalFormat("###0.##").format(number)) + " " + unit;
            }
            number = (float)((double)number / 1024.0);
            ++n2;
        }
        return String.format("%d B", bytes);
    }
}

