/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controller.states;

import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.states.GtmCheckingConstraintsState;
import com.nxp.swtools.gtm.controller.states.IGtmConstraintsState;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GtmIdleConstraintsState
implements IGtmConstraintsState {
    private GtmController gtmController;
    private static final Logger LOGGER = LogManager.getLogger(GtmIdleConstraintsState.class);

    public GtmIdleConstraintsState(GtmController gtmController) {
        this.gtmController = gtmController;
    }

    @Override
    public void changeInCurrentPane() {
    }

    @Override
    public void changeInTreePane() {
    }

    @Override
    public void updateConstraintsDeque() {
        Thread constraintsThread = this.gtmController.getConstraintsThread();
        if (constraintsThread.isAlive()) {
            try {
                constraintsThread.join();
            }
            catch (InterruptedException interruptedException) {
                LOGGER.log(Level.SEVERE, "Unexpected interruption while waiting for the constraints task to finish.");
            }
        }
        if (!this.gtmController.getConstraintsDequeContainer().isEmpty()) {
            this.gtmController.lockConstraintsLock();
            try {
                this.gtmController.changeConstraintsState(new GtmCheckingConstraintsState(this.gtmController));
                this.gtmController.requestConstraintsCheck();
            }
            finally {
                this.gtmController.unlockConstraintsLock();
            }
        } else {
            this.gtmController.validate();
            if (!this.gtmController.getProblemsManager().hasGtmToolErrors()) {
                this.gtmController.requestRegenerateCode();
            }
            this.gtmController.handleSettingChange(16, this.gtmController.getSharedConfig(), null, null);
        }
    }
}

