/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controller.validation;

import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.validation.IProblemSource;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.Messages;
import com.nxp.swtools.gtm.controller.validation.GtmProblem;
import com.nxp.swtools.gtm.controller.validation.GtmProblemsManager;
import com.nxp.swtools.gtm.controller.validators.GtmDisabledPropertyChangeValidator;
import com.nxp.swtools.gtm.controller.validators.GtmValueChangeValidator;
import com.nxp.swtools.gtm.controller.validators.IGtmValidator;
import com.nxp.swtools.gtm.model.xml.settings.GtmConstraintsTable;
import com.nxp.swtools.gtm.model.xml.settings.GtmEnumSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmIntegerSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import com.nxp.swtools.validation.engine.GenericProblem;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;

public class GtmValidationHandler {
    private PropertyChangeListener valueChangeListener;
    private PropertyChangeListener disableStateChangeListener;
    private Queue<IGtmValidator> validationQueue = new LinkedList<IGtmValidator>();

    public GtmValidationHandler() {
        this.valueChangeListener = evt -> {
            Objects.requireNonNull(evt);
            if ("value".equalsIgnoreCase(evt.getPropertyName())) {
                if (evt.getSource() instanceof GtmIntegerSetting) {
                    assert (evt.getSource() instanceof GtmIntegerSetting) : Messages.ValidationAssertFailed;
                    GtmIntegerSetting integerSetting = (GtmIntegerSetting)evt.getSource();
                    this.validationQueue.add(new GtmValueChangeValidator((ABaseUIComponentSetting)integerSetting, this));
                } else if (evt.getSource() instanceof GtmEnumSetting) {
                    GtmEnumSetting enumSetting = (GtmEnumSetting)evt.getSource();
                    this.validationQueue.add(new GtmValueChangeValidator((ABaseUIComponentSetting)enumSetting, this));
                }
            }
        };
        this.disableStateChangeListener = evt -> {
            Objects.requireNonNull(evt);
            if ("disable".equalsIgnoreCase(evt.getPropertyName())) {
                if (evt.getSource() instanceof GtmIntegerSetting) {
                    assert (evt.getSource() instanceof GtmIntegerSetting) : Messages.ValidationAssertFailed;
                    GtmIntegerSetting integerSetting = (GtmIntegerSetting)evt.getSource();
                    this.validationQueue.add(new GtmDisabledPropertyChangeValidator((ABaseUIComponentSetting)integerSetting, this));
                } else if (evt.getSource() instanceof GtmEnumSetting) {
                    GtmEnumSetting enumSetting = (GtmEnumSetting)evt.getSource();
                    this.validationQueue.add(new GtmDisabledPropertyChangeValidator((ABaseUIComponentSetting)enumSetting, this));
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        Queue<IGtmValidator> queue = this.validationQueue;
        synchronized (queue) {
            while (!this.validationQueue.isEmpty()) {
                IGtmValidator validator = this.validationQueue.remove();
                validator.validate();
            }
        }
    }

    public void validateValue(ABaseUIComponentSetting componentSetting) {
        if (componentSetting instanceof GtmIntegerSetting) {
            this.validateValue((GtmIntegerSetting)componentSetting);
        } else if (componentSetting instanceof GtmEnumSetting) {
            this.validateValue((GtmEnumSetting)componentSetting);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateValue(GtmIntegerSetting integerSetting) {
        GtmProblemsManager problemsManager;
        GtmProblemsManager gtmProblemsManager = problemsManager = GtmController.getInstance().getProblemsManager();
        synchronized (gtmProblemsManager) {
            GtmProblem limitValueProblem;
            GtmProblem emptyValueProblem;
            problemsManager.clearProblems((IProblemSource)integerSetting);
            integerSetting.setValueValid(true);
            GtmProblem invalidValueProblem = problemsManager.getInvalidFieldValueProblem(integerSetting);
            if (invalidValueProblem != null) {
                problemsManager.addProblem((GenericProblem)invalidValueProblem);
                integerSetting.setValueValid(false);
            }
            if ((emptyValueProblem = problemsManager.getEmptyValueProblem(integerSetting)) != null) {
                problemsManager.addProblem((GenericProblem)emptyValueProblem);
                integerSetting.setValueValid(false);
            }
            if ((limitValueProblem = problemsManager.getLimitValueProblem(integerSetting)) != null) {
                problemsManager.addProblem((GenericProblem)limitValueProblem);
                integerSetting.setValueValid(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateValue(GtmEnumSetting enumSetting) {
        GtmProblemsManager problemsManager;
        GtmProblemsManager gtmProblemsManager = problemsManager = GtmController.getInstance().getProblemsManager();
        synchronized (gtmProblemsManager) {
            GtmProblem validationProblem;
            problemsManager.clearProblems((IProblemSource)enumSetting);
            enumSetting.setValueValid(true);
            if (!enumSetting.isDisabled() && (validationProblem = problemsManager.getValidationProblem(enumSetting)) != null) {
                problemsManager.addProblem((GenericProblem)validationProblem);
                enumSetting.setValueValid(false);
            }
        }
    }

    public void validateAllIntegerSettings() {
        GtmStructSetting parentStruct = GtmController.getInstance().getGtmXmlConfig().getLayoutComponents().getParentLayoutContent();
        this.validateStructIntegerSettings(parentStruct);
    }

    private void validateStructIntegerSettings(GtmStructSetting structSetting) {
        GtmConstraintsTable constraints = GtmController.getInstance().getGtmXmlConfig().getConstraints();
        structSetting.checkConstraints(GtmController.getInstance().getGtmMcu(), constraints);
        for (GtmIntegerSetting integerSetting : structSetting.getIntegerSettings()) {
            integerSetting.checkConstraints(GtmController.getInstance().getGtmMcu(), constraints);
            if (integerSetting.isDisabled()) continue;
            this.validateValue(integerSetting);
        }
        for (GtmStructSetting childStructSetting : structSetting.getStructSettings()) {
            this.validateStructIntegerSettings(childStructSetting);
        }
    }

    public void validateAllEnumSettings() {
        GtmStructSetting parentStruct = GtmController.getInstance().getGtmXmlConfig().getLayoutComponents().getParentLayoutContent();
        this.validateStructEnumSettings(parentStruct);
    }

    private void validateStructEnumSettings(GtmStructSetting structSetting) {
        GtmConstraintsTable constraints = GtmController.getInstance().getGtmXmlConfig().getConstraints();
        for (GtmEnumSetting enumSetting : structSetting.getEnumSettings()) {
            enumSetting.checkConstraints(GtmController.getInstance().getGtmMcu(), constraints);
            if (enumSetting.isDisabled()) continue;
            this.validateValue(enumSetting);
        }
        for (GtmStructSetting childStructSetting : structSetting.getStructSettings()) {
            this.validateStructEnumSettings(childStructSetting);
        }
    }

    public PropertyChangeListener getValueChangeListener() {
        return this.valueChangeListener;
    }

    public PropertyChangeListener getDisableStateListener() {
        return this.disableStateChangeListener;
    }

    public Queue<IGtmValidator> getValidationQueue() {
        return this.validationQueue;
    }
}

