/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard;

import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.ProjectContext;
import com.freescale.s32ds.cross.wizard.S32DSAbstractWizard;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.WizardArtifactType;
import com.freescale.s32ds.cross.wizard.backend.WizardBackend;
import com.freescale.s32ds.cross.wizard.backend.WizardBackendException;
import com.freescale.s32ds.cross.wizard.page1.S32DSMultiPageOne;
import com.freescale.s32ds.cross.wizard.page2.S32DSMultiPageTwo;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class S32DSMultiProjectWizard
extends S32DSAbstractWizard {
    private S32DSMultiPageOne startingPage;

    public S32DSMultiProjectWizard(String title, String desc, HWModel model, WizardArtifactType type) {
        super(title, desc, model, new WizardBackend(), type);
    }

    public S32DSMultiProjectWizard(String title, String desc, WizardArtifactType type) {
        super(title, desc, new WizardBackend(), type);
    }

    protected S32DSMultiPageOne createStartingPage(String pageName) {
        return new S32DSMultiPageOne(pageName, this);
    }

    public S32DSMultiPageOne getStartingPage() {
        if (this.startingPage == null) {
            this.startingPage = this.createStartingPage(this.getWizadrTitle());
            this.startingPage.setDescription(this.getWizardDescription());
        }
        return this.startingPage;
    }

    public IProject getProject(boolean defaults) {
        throw new UnsupportedOperationException();
    }

    public IProject getProject(boolean defaults, boolean onFinish) {
        throw new UnsupportedOperationException();
    }

    public boolean canFinish() {
        if (this.startingPage.isCurrentPage()) {
            return false;
        }
        IWizardPage p = this.getStartingPage().getNextPage();
        return p != null && p.isPageComplete();
    }

    public boolean performFinish() {
        this.setComplete();
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(monitor -> {
                try {
                    this.getBackend().create(this, this.getContext(), (IRunnableContext)this.getContainer(), monitor);
                }
                catch (WizardBackendException e) {
                    throw new InvocationTargetException(e);
                }
            }));
        }
        catch (InterruptedException | InvocationTargetException e) {
            S32DSWizardPlugin.log(e);
            return false;
        }
        return true;
    }

    public void updateAll() {
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        CoreModel coreModel = CoreModel.getDefault();
        IProject autostart = null;
        ArrayList<IProject> projects = new ArrayList<IProject>();
        for (IAdaptable a : this.getBackend().getIAd()) {
            IProject p = (IProject)a;
            ProjectContext pc = this.getContext().getProjectContext(p);
            if (pc instanceof CProjectMasterContext && ((CProjectMasterContext)pc).isAutoStart()) {
                autostart = p;
                continue;
            }
            projects.add(p);
        }
        if (autostart != null) {
            projects.add(autostart);
        }
        for (IProject p : projects) {
            ICProject c = coreModel.getCModel().getCProject(p.getName());
            if (c == null) continue;
            CCorePlugin.getIndexManager().setIndexerId(c, null);
            this.selectAndReveal((IResource)p);
        }
    }

    protected void setComplete() {
        WizardDialog container = (WizardDialog)this.getContainer();
        ((WizardPage)container.getCurrentPage()).setPageComplete(true);
        this.disableButtonsOnfinish(container);
    }

    @Deprecated
    private void disableButtonsOnfinish(WizardDialog container) {
        Field[] declaredFields;
        List<String> namesToDisable = Arrays.asList("finishButton", "cancelButton", "nextButton", "backButton");
        Field[] fieldArray = declaredFields = container.getClass().getDeclaredFields();
        int n = declaredFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (namesToDisable.contains(f.getName())) {
                f.setAccessible(true);
                try {
                    Button b = (Button)f.get(container);
                    b.setEnabled(false);
                }
                catch (Exception e) {
                    S32DSWizardPlugin.log(e);
                }
                f.setAccessible(false);
            }
            ++n2;
        }
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage instanceof S32DSMultiPageTwo) {
            ((S32DSMultiPageTwo)currentPage).disableUI();
        }
    }
}

