/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.handler;

import com.freescale.s32ds.cross.core.model.DefaultParameterHandler;
import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.ParameterType;
import com.freescale.s32ds.cross.core.model.context.AbstractContext;
import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.core.model.context.ChangeResult;
import com.freescale.s32ds.cross.core.model.context.ContextChange;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.CoreNatureSlaveData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class CoProcessorHandler
extends DefaultParameterHandler {
    private static final String CO_PROCESSOR_TAG = "CoProcessor";
    private static final String CO_PROCESSOR_ENABLE_TAG = "CoProcessorEnable";
    private static final String APU_CO_PROCESSOR_TAG = "apuCoProcessor";
    private static final String SEQUENCER_ENABLE_TAG = "SequencerEnable";
    private static final String ISP_CO_PROCESSOR_STATIC_SEQUENCER_ENABLE_TAG = "ispCoProcessorStaticSequencerEnable";
    private static final String ISP_CO_PROCESSOR_TAG = "ispCoProcessor";
    private static final String ISP_CO_PROCESSOR_GRAPH_ENABLE_TAG = "ispCoProcessorGraphEnable";
    private static final String ENABLE_TAG = "Enable";
    private static final String GRAPH_ENABLE_TAG = "GraphEnable";
    private final Map<String, Boolean> processorGraphEnableMap = new HashMap<String, Boolean>();

    public ChangeResult onInit(String tag, Object newValue, AbstractContext context) {
        CoreNatureSlaveData coProcessor = this.getCoProcessor(tag, context);
        if (coProcessor == null) {
            return null;
        }
        String prefix = tag.contains(GRAPH_ENABLE_TAG) ? tag.replace(GRAPH_ENABLE_TAG, "") : tag.replace(ENABLE_TAG, "");
        ContextChange change = new ContextChange(context, String.valueOf(prefix) + ENABLE_TAG);
        change.addValue(String.valueOf(prefix) + ENABLE_TAG, (Object)coProcessor.isEnabledByDefault());
        change.addValue(String.valueOf(prefix) + GRAPH_ENABLE_TAG, (Object)coProcessor.isEnabledByDefault());
        change.addValue(ISP_CO_PROCESSOR_STATIC_SEQUENCER_ENABLE_TAG, (Object)false);
        return new ChangeResult(Arrays.asList(change));
    }

    public ChangeResult onEdit(String tag, Object newValue, AbstractContext context) {
        CoreNatureSlaveData coProcessor = this.getCoProcessor(tag, context);
        if (coProcessor == null) {
            return null;
        }
        String prefix = tag.contains(GRAPH_ENABLE_TAG) ? tag.replace(GRAPH_ENABLE_TAG, "") : tag.replace(ENABLE_TAG, "");
        ContextChange change = new ContextChange(context, String.valueOf(prefix) + ENABLE_TAG);
        boolean isCoProcEnabled = context.getBooleanValue(String.valueOf(prefix) + ENABLE_TAG);
        boolean coProcessorEnabled = (Boolean)newValue;
        boolean graphEnabled = this.isGraphEnabled(coProcessorEnabled, coProcessor, context, String.valueOf(prefix) + GRAPH_ENABLE_TAG, String.valueOf(prefix) + ENABLE_TAG);
        graphEnabled = isCoProcEnabled && graphEnabled;
        change.addValue(String.valueOf(prefix) + GRAPH_ENABLE_TAG, (Object)graphEnabled);
        if ((tag.contains(ISP_CO_PROCESSOR_GRAPH_ENABLE_TAG) || tag.contains(ISP_CO_PROCESSOR_TAG)) && !coProcessorEnabled) {
            change.addValue(ISP_CO_PROCESSOR_STATIC_SEQUENCER_ENABLE_TAG, (Object)graphEnabled);
        }
        if (tag.contains(SEQUENCER_ENABLE_TAG) && !(graphEnabled = context.getBooleanValue(ISP_CO_PROCESSOR_GRAPH_ENABLE_TAG))) {
            change.addValue(ISP_CO_PROCESSOR_STATIC_SEQUENCER_ENABLE_TAG, (Object)graphEnabled);
        }
        if (!coProcessorEnabled && tag.contains(CO_PROCESSOR_ENABLE_TAG)) {
            String coProcessor_tag = null;
            if (APU_CO_PROCESSOR_TAG.equalsIgnoreCase(prefix)) {
                coProcessor_tag = ISP_CO_PROCESSOR_TAG;
            } else if (ISP_CO_PROCESSOR_TAG.equalsIgnoreCase(prefix)) {
                coProcessor_tag = APU_CO_PROCESSOR_TAG;
            }
            if (coProcessor_tag != null) {
                change.addValue(String.valueOf(coProcessor_tag) + ENABLE_TAG, (Object)(!coProcessorEnabled ? 1 : 0));
            }
        }
        if (APU_CO_PROCESSOR_TAG.equalsIgnoreCase(prefix)) {
            change.addValue(String.valueOf(prefix) + GRAPH_ENABLE_TAG, (Object)((Boolean)newValue));
        }
        return new ChangeResult(Arrays.asList(change));
    }

    private CoreNatureSlaveData getCoProcessor(String tag, AbstractContext context) {
        Parameter parameter = context.getParameter(tag);
        ParameterType refParameterType = parameter.getType().getRefParameterType();
        if (refParameterType != null && refParameterType.getTag().equals("coProcessor") && context instanceof CProjectMasterContext) {
            CoreNatureData coreNature = ((CProjectMasterContext)context).getCoreNature();
            if (tag.contains(CO_PROCESSOR_TAG)) {
                String[] split = tag.split(CO_PROCESSOR_TAG);
                CoreNatureSlaveData coProcessor = coreNature.getSlave(split[0]);
                return coProcessor;
            }
        }
        return null;
    }

    private boolean isGraphEnabled(boolean coProcessorEnabled, CoreNatureSlaveData coProcessor, AbstractContext context, String paramGraph, String paramCoProc) {
        boolean graphEnabled = coProcessorEnabled;
        Parameter graphEnabledParameter = context.getParameter(paramGraph);
        Parameter coProcessorEnabledParameter = context.getParameter(paramCoProc);
        if (coProcessorEnabledParameter != null && coProcessorEnabledParameter.isVisible() && graphEnabledParameter != null && graphEnabledParameter.isVisible()) {
            if (coProcessorEnabled) {
                Boolean b = this.processorGraphEnableMap.get(coProcessor.getParent().getId());
                graphEnabled = b != null ? b : graphEnabled;
            } else {
                this.processorGraphEnableMap.put(coProcessor.getParent().getId(), context.getBooleanValue(paramGraph));
            }
        }
        return graphEnabled;
    }
}

