/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page1;

import com.freescale.s32ds.cross.wizard.Messages;
import com.freescale.s32ds.cross.wizard.S32DSWizardPlugin;
import com.freescale.s32ds.cross.wizard.page1.S32DSMultiPageOne;
import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LocationArea {
    private static final String KEY_PATH = "loc_path";
    private static final int SIZE_TEXT_FIELD_WIDTH = 250;
    private String userPath = "";
    private Text locationPath;
    private Button browseButton;
    private Button defaultsButton;
    private Label locationLabel;
    private final S32DSMultiPageOne wizardPage;

    public LocationArea(Composite composite, S32DSMultiPageOne page) {
        this.createContents(composite, true);
        this.wizardPage = page;
    }

    private void createContents(Composite composite, boolean isDefaultEnabled) {
        Composite projectComposite = new Composite(composite, 0);
        projectComposite.setLayout((Layout)new GridLayout(4, false));
        projectComposite.setLayoutData((Object)new GridData(768));
        this.defaultsButton = new Button(projectComposite, 131104);
        this.defaultsButton.setText(Messages.LocationArea_Use_default_loc);
        this.defaultsButton.setSelection(isDefaultEnabled);
        this.defaultsButton.setLayoutData((Object)new GridData(1, 2, false, false, 4, 1));
        this.createUserEntryArea(isDefaultEnabled, projectComposite);
        this.defaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LocationArea.this.defaultsButton.getSelection()) {
                    LocationArea.this.userPath = LocationArea.this.locationPath.getText();
                    LocationArea.this.locationPath.setText(TextProcessor.process((String)LocationArea.getDefaultPathDisplayString()));
                } else {
                    LocationArea.this.locationPath.setText(TextProcessor.process((String)LocationArea.this.userPath));
                }
                LocationArea.this.setUserAreaEnabled(!LocationArea.this.defaultsButton.getSelection());
            }
        });
        this.setUserAreaEnabled(!isDefaultEnabled);
    }

    public boolean isDefault() {
        return this.defaultsButton.getSelection();
    }

    private void createUserEntryArea(boolean isDefaultEnabled, Composite composite) {
        this.locationLabel = new Label(composite, 0);
        this.locationLabel.setText(Messages.LocationArea_location);
        this.locationPath = new Text(composite, 2048);
        if (isDefaultEnabled) {
            this.locationPath.setText(TextProcessor.process((String)LocationArea.getDefaultPathDisplayString()));
        } else {
            this.locationPath.setText("");
        }
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 250;
        this.locationPath.setLayoutData((Object)gridData);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setText(Messages.LocationArea_browse);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                LocationArea.this.handleLocationBrowseBtnPressed();
            }
        });
        this.locationPath.addModifyListener(e -> {
            this.wizardPage.getContext().setBaseProjectPath(this.locationPath.getText());
            this.wizardPage.updateState();
        });
    }

    private static String getDefaultPathDisplayString() {
        IPath location = Platform.getLocation();
        if (location != null) {
            return location.toOSString();
        }
        return "";
    }

    private void setUserAreaEnabled(boolean enabled) {
        this.locationLabel.setEnabled(enabled);
        this.locationPath.setEnabled(enabled);
        this.browseButton.setEnabled(enabled);
    }

    public static IFileInfo getFileInfo(String s) {
        Path location = new Path(s);
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)location);
        try {
            URI uri = file != null ? file.getLocationURI() : location.toFile().toURI();
            IFileStore store = EFS.getStore((URI)uri);
            if (store != null) {
                return store.fetchInfo();
            }
        }
        catch (CoreException e) {
            S32DSWizardPlugin.log(e);
        }
        return null;
    }

    private void handleLocationBrowseBtnPressed() {
        String dirName = this.getPathFromLocationField();
        if (!dirName.isEmpty()) {
            IFileInfo info = LocationArea.getFileInfo(dirName);
            if (info == null || !info.exists()) {
                dirName = "";
            }
        } else {
            dirName = LocationArea.loadSettings(KEY_PATH);
        }
        DirectoryDialog dialog = new DirectoryDialog(this.locationPath.getShell(), 0x10000000);
        dialog.setMessage(Messages.LocationArea_select_dir);
        dialog.setFilterPath(dirName);
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            this.locationPath.setText(TextProcessor.process((String)(String.valueOf(selectedDirectory) + File.separator)));
            LocationArea.saveSettings(KEY_PATH, selectedDirectory);
        }
    }

    private String getPathFromLocationField() {
        String path = URIUtil.toURI((String)this.locationPath.getText(), (boolean)true).getPath();
        return path != null ? path : this.locationPath.getText();
    }

    public URI getProjectLocationURI() {
        return URIUtil.toURI((String)this.locationPath.getText(), (boolean)true);
    }

    public String getProjectLocation() {
        IPath locationPath = Platform.getLocation();
        String location = "";
        if (locationPath != null) {
            location = locationPath.toOSString();
        }
        return this.isDefault() ? location : this.locationPath.getText();
    }

    public Button getBrowseButton() {
        return this.browseButton;
    }

    private static void saveSettings(String key, String path) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.wizard");
        prefs.put(key, path);
        try {
            prefs.flush();
        }
        catch (Exception e) {
            S32DSWizardPlugin.log(e);
        }
    }

    private static String loadSettings(String key) {
        return InstanceScope.INSTANCE.getNode("com.freescale.s32ds.cross.wizard").get(key, "");
    }
}

