/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.wizard.page2;

import com.freescale.s32ds.cross.core.model.Parameter;
import com.freescale.s32ds.cross.core.model.context.CProjectContext;
import com.freescale.s32ds.cross.core.model.context.ChangeResult;
import com.freescale.s32ds.cross.core.model.context.ProcessorContext;
import com.freescale.s32ds.cross.wizard.ParameterControl;
import com.freescale.s32ds.cross.wizard.page2.Page2AbstractManager;
import com.freescale.s32ds.cross.wizard.page2.S32DSMultiPageTwo;
import com.nxp.s32ds.cle.runtime.hardware.registry.ClusterDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.OperationModeDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.OperationModeDescriptors;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Combo;

public class OpModeActivateListener
extends SelectionAdapter {
    private static final String DECOUPLE_STEP = "ds";
    private static final String LOCK_STEP = "ls";
    private static final String EMPTY_VALUE = "";
    private static final String LOCKSTEP = "Lockstep";
    private final S32DSMultiPageTwo wizardPage;
    private final CProjectContext projectContext;
    private final Page2AbstractManager pageManager;
    private final Parameter parameter;

    public OpModeActivateListener(Page2AbstractManager pageManager, CProjectContext projectContext, S32DSMultiPageTwo wizardPage, Parameter parameter) {
        this.projectContext = projectContext;
        this.pageManager = pageManager;
        this.wizardPage = wizardPage;
        this.parameter = parameter;
    }

    public void widgetSelected(SelectionEvent e) {
        List operationModes;
        ClusterDescriptor cluster;
        String currentOpmode = ((Combo)e.widget).getText();
        ChangeResult result = this.projectContext.setValue(this.parameter.getTag(), (Object)currentOpmode);
        ProcessorContext processorContext = this.projectContext.getProcessorContext();
        List projectContexts = processorContext.getProjectContexts();
        ArrayList changes = new ArrayList();
        String device = processorContext.getStringValue("deviceId");
        String deviceCore = this.projectContext.getStringValue("core");
        DeviceCoreDescriptor primaryDeviceCore = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCore);
        String clusterId = primaryDeviceCore.getClusterId();
        String clusterName = EMPTY_VALUE;
        if (!clusterId.isEmpty() && (cluster = DeviceDescriptors.getDeviceRegistry().getClusterDescriptor(clusterId)) != null) {
            clusterName = cluster.getName();
        }
        if ((operationModes = OperationModeDescriptors.getOperationModeDescriptorByCluster((String)device, (String)clusterName)).isEmpty()) {
            return;
        }
        boolean isLockStep = LOCKSTEP.equals(currentOpmode);
        for (CProjectContext pcontext : projectContexts) {
            DeviceCoreDescriptor contextDeviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)pcontext.getStringValue("core"));
            Optional<OperationModeDescriptor> operationModePrimaryDescriptor = OpModeActivateListener.getOpModeDescriptorByPrimaryCore(operationModes, contextDeviceCoreDescriptor);
            if (operationModePrimaryDescriptor.isPresent()) {
                OperationModeDescriptor descriptor = operationModePrimaryDescriptor.get();
                if (isLockStep) {
                    OpModeActivateListener.setOperationModeProjectContext(pcontext, descriptor);
                    continue;
                }
                OpModeActivateListener.setDefaultProjectContext(pcontext);
                continue;
            }
            Optional<OperationModeDescriptor> secondaryDescriptorOpt = OpModeActivateListener.getOpModeDescriptorBySecondaryCore(operationModes, contextDeviceCoreDescriptor);
            if (!secondaryDescriptorOpt.isPresent()) continue;
            pcontext.setValue("primaryCore", (Object)deviceCore);
            pcontext.setActive(!isLockStep);
            this.updateColumnControls(pcontext);
        }
        changes.addAll(result.getContextChanges());
        if (!changes.isEmpty()) {
            this.pageManager.update(new ChangeResult(changes));
        }
        this.wizardPage.setPageComplete(this.wizardPage.validatePage());
    }

    private static void setOperationModeProjectContext(CProjectContext pcontext, OperationModeDescriptor descriptor) {
        pcontext.setContextValue("opmodeCoreId", descriptor.getDeviceCoreLocked());
        pcontext.setContextValue("opmode", LOCK_STEP);
    }

    private static void setDefaultProjectContext(CProjectContext pcontext) {
        pcontext.setContextValue("opmodeCoreId", EMPTY_VALUE);
        pcontext.setContextValue("opmode", DECOUPLE_STEP);
    }

    private void updateColumnControls(CProjectContext pcontext) {
        for (ParameterControl control : this.getControls(pcontext)) {
            control.updateOpModeState();
        }
    }

    private static Optional<OperationModeDescriptor> getOpModeDescriptorByPrimaryCore(List<OperationModeDescriptor> operationModes, DeviceCoreDescriptor contextDeviceCoreDescriptor) {
        return operationModes.stream().filter(p -> p.getPrimary2Secondary().containsKey(contextDeviceCoreDescriptor.getId())).findFirst();
    }

    private static Optional<OperationModeDescriptor> getOpModeDescriptorBySecondaryCore(List<OperationModeDescriptor> operationModes, DeviceCoreDescriptor contextDeviceCoreDescriptor) {
        return operationModes.stream().filter(p -> p.getPrimary2Secondary().containsValue(contextDeviceCoreDescriptor.getId())).findFirst();
    }

    private List<ParameterControl> getControls(CProjectContext pcontext) {
        return ParameterControl.filterControls(pcontext, this.pageManager.getControls());
    }
}

